/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a short summary and metadata for a <code>ManagedNotificationChildEvent</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedNotificationChildEventSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedNotificationChildEventSummary.Builder, ManagedNotificationChildEventSummary> {
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(ManagedNotificationChildEventSummary::schemaVersionAsString))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<ManagedSourceEventMetadataSummary> SOURCE_EVENT_METADATA_FIELD = SdkField
            .<ManagedSourceEventMetadataSummary> builder(MarshallingType.SDK_POJO).memberName("sourceEventMetadata")
            .getter(getter(ManagedNotificationChildEventSummary::sourceEventMetadata))
            .setter(setter(Builder::sourceEventMetadata)).constructor(ManagedSourceEventMetadataSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventMetadata").build())
            .build();

    private static final SdkField<MessageComponentsSummary> MESSAGE_COMPONENTS_FIELD = SdkField
            .<MessageComponentsSummary> builder(MarshallingType.SDK_POJO).memberName("messageComponents")
            .getter(getter(ManagedNotificationChildEventSummary::messageComponents)).setter(setter(Builder::messageComponents))
            .constructor(MessageComponentsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageComponents").build()).build();

    private static final SdkField<AggregationDetail> AGGREGATION_DETAIL_FIELD = SdkField
            .<AggregationDetail> builder(MarshallingType.SDK_POJO).memberName("aggregationDetail")
            .getter(getter(ManagedNotificationChildEventSummary::aggregationDetail)).setter(setter(Builder::aggregationDetail))
            .constructor(AggregationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDetail").build()).build();

    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventStatus").getter(getter(ManagedNotificationChildEventSummary::eventStatusAsString))
            .setter(setter(Builder::eventStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatus").build()).build();

    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationType").getter(getter(ManagedNotificationChildEventSummary::notificationTypeAsString))
            .setter(setter(Builder::notificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD,
            SOURCE_EVENT_METADATA_FIELD, MESSAGE_COMPONENTS_FIELD, AGGREGATION_DETAIL_FIELD, EVENT_STATUS_FIELD,
            NOTIFICATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schemaVersion;

    private final ManagedSourceEventMetadataSummary sourceEventMetadata;

    private final MessageComponentsSummary messageComponents;

    private final AggregationDetail aggregationDetail;

    private final String eventStatus;

    private final String notificationType;

    private ManagedNotificationChildEventSummary(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.sourceEventMetadata = builder.sourceEventMetadata;
        this.messageComponents = builder.messageComponents;
        this.aggregationDetail = builder.aggregationDetail;
        this.eventStatus = builder.eventStatus;
        this.notificationType = builder.notificationType;
    }

    /**
     * <p>
     * The schema version of the <code>ManagedNotificationChildEvent</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaVersion}
     * will return {@link SchemaVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaVersionAsString}.
     * </p>
     * 
     * @return The schema version of the <code>ManagedNotificationChildEvent</code>.
     * @see SchemaVersion
     */
    public final SchemaVersion schemaVersion() {
        return SchemaVersion.fromValue(schemaVersion);
    }

    /**
     * <p>
     * The schema version of the <code>ManagedNotificationChildEvent</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaVersion}
     * will return {@link SchemaVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaVersionAsString}.
     * </p>
     * 
     * @return The schema version of the <code>ManagedNotificationChildEvent</code>.
     * @see SchemaVersion
     */
    public final String schemaVersionAsString() {
        return schemaVersion;
    }

    /**
     * <p>
     * Contains all event metadata present identically across all <code>NotificationEvents</code>. All fields are
     * present in Source Events via Eventbridge.
     * </p>
     * 
     * @return Contains all event metadata present identically across all <code>NotificationEvents</code>. All fields
     *         are present in Source Events via Eventbridge.
     */
    public final ManagedSourceEventMetadataSummary sourceEventMetadata() {
        return sourceEventMetadata;
    }

    /**
     * Returns the value of the MessageComponents property for this object.
     * 
     * @return The value of the MessageComponents property for this object.
     */
    public final MessageComponentsSummary messageComponents() {
        return messageComponents;
    }

    /**
     * <p>
     * Provides detailed information about the dimensions used for event summarization and aggregation.
     * </p>
     * 
     * @return Provides detailed information about the dimensions used for event summarization and aggregation.
     */
    public final AggregationDetail aggregationDetail() {
        return aggregationDetail;
    }

    /**
     * <p>
     * The perceived nature of the event.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All EventRules are <code>ACTIVE</code> and any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link EventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The perceived nature of the event.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All EventRules are <code>ACTIVE</code> and any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see EventStatus
     */
    public final EventStatus eventStatus() {
        return EventStatus.fromValue(eventStatus);
    }

    /**
     * <p>
     * The perceived nature of the event.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All EventRules are <code>ACTIVE</code> and any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link EventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The perceived nature of the event.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All EventRules are <code>ACTIVE</code> and any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see EventStatus
     */
    public final String eventStatusAsString() {
        return eventStatus;
    }

    /**
     * <p>
     * The Type of the event causing this notification.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALERT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold was
     * breached.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where an issue is about to arise. For example, something is approaching a
     * threshold.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ANNOUNCEMENT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an important event. For example, a step in a workflow or escalation path or that a workflow
     * was updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about informational messages. For example, recommendations, service announcements, or reminders.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The Type of the event causing this notification.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALERT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where something was triggered, initiated, reopened, deployed, or a
     *         threshold was breached.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where an issue is about to arise. For example, something is approaching a
     *         threshold.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANNOUNCEMENT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an important event. For example, a step in a workflow or escalation path or that a
     *         workflow was updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about informational messages. For example, recommendations, service announcements, or
     *         reminders.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationType
     */
    public final NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * <p>
     * The Type of the event causing this notification.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALERT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold was
     * breached.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where an issue is about to arise. For example, something is approaching a
     * threshold.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ANNOUNCEMENT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an important event. For example, a step in a workflow or escalation path or that a workflow
     * was updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about informational messages. For example, recommendations, service announcements, or reminders.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The Type of the event causing this notification.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALERT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where something was triggered, initiated, reopened, deployed, or a
     *         threshold was breached.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where an issue is about to arise. For example, something is approaching a
     *         threshold.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANNOUNCEMENT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an important event. For example, a step in a workflow or escalation path or that a
     *         workflow was updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about informational messages. For example, recommendations, service announcements, or
     *         reminders.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationType
     */
    public final String notificationTypeAsString() {
        return notificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(messageComponents());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationChildEventSummary)) {
            return false;
        }
        ManagedNotificationChildEventSummary other = (ManagedNotificationChildEventSummary) obj;
        return Objects.equals(schemaVersionAsString(), other.schemaVersionAsString())
                && Objects.equals(sourceEventMetadata(), other.sourceEventMetadata())
                && Objects.equals(messageComponents(), other.messageComponents())
                && Objects.equals(aggregationDetail(), other.aggregationDetail())
                && Objects.equals(eventStatusAsString(), other.eventStatusAsString())
                && Objects.equals(notificationTypeAsString(), other.notificationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedNotificationChildEventSummary").add("SchemaVersion", schemaVersionAsString())
                .add("SourceEventMetadata", sourceEventMetadata()).add("MessageComponents", messageComponents())
                .add("AggregationDetail", aggregationDetail()).add("EventStatus", eventStatusAsString())
                .add("NotificationType", notificationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersionAsString()));
        case "sourceEventMetadata":
            return Optional.ofNullable(clazz.cast(sourceEventMetadata()));
        case "messageComponents":
            return Optional.ofNullable(clazz.cast(messageComponents()));
        case "aggregationDetail":
            return Optional.ofNullable(clazz.cast(aggregationDetail()));
        case "eventStatus":
            return Optional.ofNullable(clazz.cast(eventStatusAsString()));
        case "notificationType":
            return Optional.ofNullable(clazz.cast(notificationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        map.put("sourceEventMetadata", SOURCE_EVENT_METADATA_FIELD);
        map.put("messageComponents", MESSAGE_COMPONENTS_FIELD);
        map.put("aggregationDetail", AGGREGATION_DETAIL_FIELD);
        map.put("eventStatus", EVENT_STATUS_FIELD);
        map.put("notificationType", NOTIFICATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationChildEventSummary, T> g) {
        return obj -> g.apply((ManagedNotificationChildEventSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedNotificationChildEventSummary> {
        /**
         * <p>
         * The schema version of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of the <code>ManagedNotificationChildEvent</code>.
         * @see SchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersion
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The schema version of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of the <code>ManagedNotificationChildEvent</code>.
         * @see SchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersion
         */
        Builder schemaVersion(SchemaVersion schemaVersion);

        /**
         * <p>
         * Contains all event metadata present identically across all <code>NotificationEvents</code>. All fields are
         * present in Source Events via Eventbridge.
         * </p>
         * 
         * @param sourceEventMetadata
         *        Contains all event metadata present identically across all <code>NotificationEvents</code>. All fields
         *        are present in Source Events via Eventbridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEventMetadata(ManagedSourceEventMetadataSummary sourceEventMetadata);

        /**
         * <p>
         * Contains all event metadata present identically across all <code>NotificationEvents</code>. All fields are
         * present in Source Events via Eventbridge.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ManagedSourceEventMetadataSummary.Builder} avoiding the need to create one manually via
         * {@link ManagedSourceEventMetadataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedSourceEventMetadataSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceEventMetadata(ManagedSourceEventMetadataSummary)}.
         * 
         * @param sourceEventMetadata
         *        a consumer that will call methods on {@link ManagedSourceEventMetadataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEventMetadata(ManagedSourceEventMetadataSummary)
         */
        default Builder sourceEventMetadata(Consumer<ManagedSourceEventMetadataSummary.Builder> sourceEventMetadata) {
            return sourceEventMetadata(ManagedSourceEventMetadataSummary.builder().applyMutation(sourceEventMetadata).build());
        }

        /**
         * Sets the value of the MessageComponents property for this object.
         *
         * @param messageComponents
         *        The new value for the MessageComponents property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageComponents(MessageComponentsSummary messageComponents);

        /**
         * Sets the value of the MessageComponents property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MessageComponentsSummary.Builder}
         * avoiding the need to create one manually via {@link MessageComponentsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageComponentsSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #messageComponents(MessageComponentsSummary)}.
         * 
         * @param messageComponents
         *        a consumer that will call methods on {@link MessageComponentsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageComponents(MessageComponentsSummary)
         */
        default Builder messageComponents(Consumer<MessageComponentsSummary.Builder> messageComponents) {
            return messageComponents(MessageComponentsSummary.builder().applyMutation(messageComponents).build());
        }

        /**
         * <p>
         * Provides detailed information about the dimensions used for event summarization and aggregation.
         * </p>
         * 
         * @param aggregationDetail
         *        Provides detailed information about the dimensions used for event summarization and aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationDetail(AggregationDetail aggregationDetail);

        /**
         * <p>
         * Provides detailed information about the dimensions used for event summarization and aggregation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationDetail.Builder} avoiding the
         * need to create one manually via {@link AggregationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationDetail(AggregationDetail)}.
         * 
         * @param aggregationDetail
         *        a consumer that will call methods on {@link AggregationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationDetail(AggregationDetail)
         */
        default Builder aggregationDetail(Consumer<AggregationDetail.Builder> aggregationDetail) {
            return aggregationDetail(AggregationDetail.builder().applyMutation(aggregationDetail).build());
        }

        /**
         * <p>
         * The perceived nature of the event.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All EventRules are <code>ACTIVE</code> and any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param eventStatus
         *        The perceived nature of the event.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All EventRules are <code>ACTIVE</code> and any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see EventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStatus
         */
        Builder eventStatus(String eventStatus);

        /**
         * <p>
         * The perceived nature of the event.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All EventRules are <code>ACTIVE</code> and any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param eventStatus
         *        The perceived nature of the event.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All EventRules are <code>ACTIVE</code> and any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see EventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStatus
         */
        Builder eventStatus(EventStatus eventStatus);

        /**
         * <p>
         * The Type of the event causing this notification.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALERT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold
         * was breached.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where an issue is about to arise. For example, something is approaching a
         * threshold.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ANNOUNCEMENT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an important event. For example, a step in a workflow or escalation path or that a
         * workflow was updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about informational messages. For example, recommendations, service announcements, or
         * reminders.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        The Type of the event causing this notification.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALERT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where something was triggered, initiated, reopened, deployed, or a
         *        threshold was breached.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where an issue is about to arise. For example, something is approaching
         *        a threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANNOUNCEMENT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an important event. For example, a step in a workflow or escalation path or that
         *        a workflow was updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about informational messages. For example, recommendations, service announcements, or
         *        reminders.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * <p>
         * The Type of the event causing this notification.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALERT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold
         * was breached.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where an issue is about to arise. For example, something is approaching a
         * threshold.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ANNOUNCEMENT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an important event. For example, a step in a workflow or escalation path or that a
         * workflow was updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about informational messages. For example, recommendations, service announcements, or
         * reminders.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        The Type of the event causing this notification.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALERT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where something was triggered, initiated, reopened, deployed, or a
         *        threshold was breached.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where an issue is about to arise. For example, something is approaching
         *        a threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANNOUNCEMENT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an important event. For example, a step in a workflow or escalation path or that
         *        a workflow was updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about informational messages. For example, recommendations, service announcements, or
         *        reminders.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);
    }

    static final class BuilderImpl implements Builder {
        private String schemaVersion;

        private ManagedSourceEventMetadataSummary sourceEventMetadata;

        private MessageComponentsSummary messageComponents;

        private AggregationDetail aggregationDetail;

        private String eventStatus;

        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationChildEventSummary model) {
            schemaVersion(model.schemaVersion);
            sourceEventMetadata(model.sourceEventMetadata);
            messageComponents(model.messageComponents);
            aggregationDetail(model.aggregationDetail);
            eventStatus(model.eventStatus);
            notificationType(model.notificationType);
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public final Builder schemaVersion(SchemaVersion schemaVersion) {
            this.schemaVersion(schemaVersion == null ? null : schemaVersion.toString());
            return this;
        }

        public final ManagedSourceEventMetadataSummary.Builder getSourceEventMetadata() {
            return sourceEventMetadata != null ? sourceEventMetadata.toBuilder() : null;
        }

        public final void setSourceEventMetadata(ManagedSourceEventMetadataSummary.BuilderImpl sourceEventMetadata) {
            this.sourceEventMetadata = sourceEventMetadata != null ? sourceEventMetadata.build() : null;
        }

        @Override
        public final Builder sourceEventMetadata(ManagedSourceEventMetadataSummary sourceEventMetadata) {
            this.sourceEventMetadata = sourceEventMetadata;
            return this;
        }

        public final MessageComponentsSummary.Builder getMessageComponents() {
            return messageComponents != null ? messageComponents.toBuilder() : null;
        }

        public final void setMessageComponents(MessageComponentsSummary.BuilderImpl messageComponents) {
            this.messageComponents = messageComponents != null ? messageComponents.build() : null;
        }

        @Override
        public final Builder messageComponents(MessageComponentsSummary messageComponents) {
            this.messageComponents = messageComponents;
            return this;
        }

        public final AggregationDetail.Builder getAggregationDetail() {
            return aggregationDetail != null ? aggregationDetail.toBuilder() : null;
        }

        public final void setAggregationDetail(AggregationDetail.BuilderImpl aggregationDetail) {
            this.aggregationDetail = aggregationDetail != null ? aggregationDetail.build() : null;
        }

        @Override
        public final Builder aggregationDetail(AggregationDetail aggregationDetail) {
            this.aggregationDetail = aggregationDetail;
            return this;
        }

        public final String getEventStatus() {
            return eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(EventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        @Override
        public ManagedNotificationChildEventSummary build() {
            return new ManagedNotificationChildEventSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
