/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A notification-focused representation of an event. They contain semantic information used by AccountContacts or
 * Additional Channels to create end-user notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedNotificationEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedNotificationEvent.Builder, ManagedNotificationEvent> {
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(ManagedNotificationEvent::schemaVersionAsString))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ManagedNotificationEvent::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MessageComponents> MESSAGE_COMPONENTS_FIELD = SdkField
            .<MessageComponents> builder(MarshallingType.SDK_POJO).memberName("messageComponents")
            .getter(getter(ManagedNotificationEvent::messageComponents)).setter(setter(Builder::messageComponents))
            .constructor(MessageComponents::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageComponents").build()).build();

    private static final SdkField<String> SOURCE_EVENT_DETAIL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceEventDetailUrl").getter(getter(ManagedNotificationEvent::sourceEventDetailUrl))
            .setter(setter(Builder::sourceEventDetailUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventDetailUrl").build())
            .build();

    private static final SdkField<String> SOURCE_EVENT_DETAIL_URL_DISPLAY_TEXT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sourceEventDetailUrlDisplayText")
            .getter(getter(ManagedNotificationEvent::sourceEventDetailUrlDisplayText))
            .setter(setter(Builder::sourceEventDetailUrlDisplayText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventDetailUrlDisplayText")
                    .build()).build();

    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationType").getter(getter(ManagedNotificationEvent::notificationTypeAsString))
            .setter(setter(Builder::notificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationType").build()).build();

    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventStatus").getter(getter(ManagedNotificationEvent::eventStatusAsString))
            .setter(setter(Builder::eventStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatus").build()).build();

    private static final SdkField<String> AGGREGATION_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationEventType").getter(getter(ManagedNotificationEvent::aggregationEventTypeAsString))
            .setter(setter(Builder::aggregationEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationEventType").build())
            .build();

    private static final SdkField<AggregationSummary> AGGREGATION_SUMMARY_FIELD = SdkField
            .<AggregationSummary> builder(MarshallingType.SDK_POJO).memberName("aggregationSummary")
            .getter(getter(ManagedNotificationEvent::aggregationSummary)).setter(setter(Builder::aggregationSummary))
            .constructor(AggregationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationSummary").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(ManagedNotificationEvent::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ManagedNotificationEvent::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, TextPartValue>> TEXT_PARTS_FIELD = SdkField
            .<Map<String, TextPartValue>> builder(MarshallingType.MAP)
            .memberName("textParts")
            .getter(getter(ManagedNotificationEvent::textParts))
            .setter(setter(Builder::textParts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textParts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TextPartValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextPartValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitId").getter(getter(ManagedNotificationEvent::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD,
            ID_FIELD, MESSAGE_COMPONENTS_FIELD, SOURCE_EVENT_DETAIL_URL_FIELD, SOURCE_EVENT_DETAIL_URL_DISPLAY_TEXT_FIELD,
            NOTIFICATION_TYPE_FIELD, EVENT_STATUS_FIELD, AGGREGATION_EVENT_TYPE_FIELD, AGGREGATION_SUMMARY_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, TEXT_PARTS_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schemaVersion;

    private final String id;

    private final MessageComponents messageComponents;

    private final String sourceEventDetailUrl;

    private final String sourceEventDetailUrlDisplayText;

    private final String notificationType;

    private final String eventStatus;

    private final String aggregationEventType;

    private final AggregationSummary aggregationSummary;

    private final Instant startTime;

    private final Instant endTime;

    private final Map<String, TextPartValue> textParts;

    private final String organizationalUnitId;

    private ManagedNotificationEvent(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.id = builder.id;
        this.messageComponents = builder.messageComponents;
        this.sourceEventDetailUrl = builder.sourceEventDetailUrl;
        this.sourceEventDetailUrlDisplayText = builder.sourceEventDetailUrlDisplayText;
        this.notificationType = builder.notificationType;
        this.eventStatus = builder.eventStatus;
        this.aggregationEventType = builder.aggregationEventType;
        this.aggregationSummary = builder.aggregationSummary;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.textParts = builder.textParts;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    /**
     * <p>
     * Version of the <code>ManagedNotificationEvent</code> schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaVersion}
     * will return {@link SchemaVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaVersionAsString}.
     * </p>
     * 
     * @return Version of the <code>ManagedNotificationEvent</code> schema.
     * @see SchemaVersion
     */
    public final SchemaVersion schemaVersion() {
        return SchemaVersion.fromValue(schemaVersion);
    }

    /**
     * <p>
     * Version of the <code>ManagedNotificationEvent</code> schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaVersion}
     * will return {@link SchemaVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaVersionAsString}.
     * </p>
     * 
     * @return Version of the <code>ManagedNotificationEvent</code> schema.
     * @see SchemaVersion
     */
    public final String schemaVersionAsString() {
        return schemaVersion;
    }

    /**
     * <p>
     * Unique identifier for a <code>ManagedNotificationEvent</code>.
     * </p>
     * 
     * @return Unique identifier for a <code>ManagedNotificationEvent</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the MessageComponents property for this object.
     * 
     * @return The value of the MessageComponents property for this object.
     */
    public final MessageComponents messageComponents() {
        return messageComponents;
    }

    /**
     * <p>
     * URL defined by Source Service to be used by notification consumers to get additional information about event.
     * </p>
     * 
     * @return URL defined by Source Service to be used by notification consumers to get additional information about
     *         event.
     */
    public final String sourceEventDetailUrl() {
        return sourceEventDetailUrl;
    }

    /**
     * <p>
     * Text that needs to be hyperlinked with the sourceEventDetailUrl. For example, the description of the
     * sourceEventDetailUrl.
     * </p>
     * 
     * @return Text that needs to be hyperlinked with the sourceEventDetailUrl. For example, the description of the
     *         sourceEventDetailUrl.
     */
    public final String sourceEventDetailUrlDisplayText() {
        return sourceEventDetailUrlDisplayText;
    }

    /**
     * <p>
     * The nature of the event causing this notification.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALERT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold was
     * breached.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where an issue is about to arise. For example, something is approaching a
     * threshold.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ANNOUNCEMENT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an important event. For example, a step in a workflow or escalation path or that a workflow
     * was updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about informational messages. For example, recommendations, service announcements, or reminders.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The nature of the event causing this notification.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALERT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where something was triggered, initiated, reopened, deployed, or a
     *         threshold was breached.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where an issue is about to arise. For example, something is approaching a
     *         threshold.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANNOUNCEMENT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an important event. For example, a step in a workflow or escalation path or that a
     *         workflow was updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about informational messages. For example, recommendations, service announcements, or
     *         reminders.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationType
     */
    public final NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * <p>
     * The nature of the event causing this notification.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALERT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold was
     * breached.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where an issue is about to arise. For example, something is approaching a
     * threshold.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ANNOUNCEMENT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an important event. For example, a step in a workflow or escalation path or that a workflow
     * was updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about informational messages. For example, recommendations, service announcements, or reminders.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The nature of the event causing this notification.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALERT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where something was triggered, initiated, reopened, deployed, or a
     *         threshold was breached.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where an issue is about to arise. For example, something is approaching a
     *         threshold.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANNOUNCEMENT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an important event. For example, a step in a workflow or escalation path or that a
     *         workflow was updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about informational messages. For example, recommendations, service announcements, or
     *         reminders.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationType
     */
    public final String notificationTypeAsString() {
        return notificationType;
    }

    /**
     * <p>
     * The status of an event.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All EventRules are <code>ACTIVE</code> and any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link EventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The status of an event.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All EventRules are <code>ACTIVE</code> and any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see EventStatus
     */
    public final EventStatus eventStatus() {
        return EventStatus.fromValue(eventStatus);
    }

    /**
     * <p>
     * The status of an event.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All EventRules are <code>ACTIVE</code> and any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link EventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The status of an event.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All EventRules are <code>ACTIVE</code> and any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see EventStatus
     */
    public final String eventStatusAsString() {
        return eventStatus;
    }

    /**
     * <p>
     * The notifications aggregation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationEventType} will return {@link AggregationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationEventTypeAsString}.
     * </p>
     * 
     * @return The notifications aggregation type.
     * @see AggregationEventType
     */
    public final AggregationEventType aggregationEventType() {
        return AggregationEventType.fromValue(aggregationEventType);
    }

    /**
     * <p>
     * The notifications aggregation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationEventType} will return {@link AggregationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationEventTypeAsString}.
     * </p>
     * 
     * @return The notifications aggregation type.
     * @see AggregationEventType
     */
    public final String aggregationEventTypeAsString() {
        return aggregationEventType;
    }

    /**
     * Returns the value of the AggregationSummary property for this object.
     * 
     * @return The value of the AggregationSummary property for this object.
     */
    public final AggregationSummary aggregationSummary() {
        return aggregationSummary;
    }

    /**
     * <p>
     * The earliest time of events to return from this call.
     * </p>
     * 
     * @return The earliest time of events to return from this call.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the notification event.
     * </p>
     * 
     * @return The end time of the notification event.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the TextParts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTextParts() {
        return textParts != null && !(textParts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of text values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextParts} method.
     * </p>
     * 
     * @return A list of text values.
     */
    public final Map<String, TextPartValue> textParts() {
        return textParts;
    }

    /**
     * <p>
     * The Organizational Unit Id that an Amazon Web Services account belongs to.
     * </p>
     * 
     * @return The Organizational Unit Id that an Amazon Web Services account belongs to.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(messageComponents());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEventDetailUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEventDetailUrlDisplayText());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTextParts() ? textParts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationEvent)) {
            return false;
        }
        ManagedNotificationEvent other = (ManagedNotificationEvent) obj;
        return Objects.equals(schemaVersionAsString(), other.schemaVersionAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(messageComponents(), other.messageComponents())
                && Objects.equals(sourceEventDetailUrl(), other.sourceEventDetailUrl())
                && Objects.equals(sourceEventDetailUrlDisplayText(), other.sourceEventDetailUrlDisplayText())
                && Objects.equals(notificationTypeAsString(), other.notificationTypeAsString())
                && Objects.equals(eventStatusAsString(), other.eventStatusAsString())
                && Objects.equals(aggregationEventTypeAsString(), other.aggregationEventTypeAsString())
                && Objects.equals(aggregationSummary(), other.aggregationSummary())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasTextParts() == other.hasTextParts() && Objects.equals(textParts(), other.textParts())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedNotificationEvent").add("SchemaVersion", schemaVersionAsString()).add("Id", id())
                .add("MessageComponents", messageComponents()).add("SourceEventDetailUrl", sourceEventDetailUrl())
                .add("SourceEventDetailUrlDisplayText", sourceEventDetailUrlDisplayText())
                .add("NotificationType", notificationTypeAsString()).add("EventStatus", eventStatusAsString())
                .add("AggregationEventType", aggregationEventTypeAsString()).add("AggregationSummary", aggregationSummary())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("TextParts", hasTextParts() ? textParts() : null)
                .add("OrganizationalUnitId", organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersionAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "messageComponents":
            return Optional.ofNullable(clazz.cast(messageComponents()));
        case "sourceEventDetailUrl":
            return Optional.ofNullable(clazz.cast(sourceEventDetailUrl()));
        case "sourceEventDetailUrlDisplayText":
            return Optional.ofNullable(clazz.cast(sourceEventDetailUrlDisplayText()));
        case "notificationType":
            return Optional.ofNullable(clazz.cast(notificationTypeAsString()));
        case "eventStatus":
            return Optional.ofNullable(clazz.cast(eventStatusAsString()));
        case "aggregationEventType":
            return Optional.ofNullable(clazz.cast(aggregationEventTypeAsString()));
        case "aggregationSummary":
            return Optional.ofNullable(clazz.cast(aggregationSummary()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "textParts":
            return Optional.ofNullable(clazz.cast(textParts()));
        case "organizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        map.put("id", ID_FIELD);
        map.put("messageComponents", MESSAGE_COMPONENTS_FIELD);
        map.put("sourceEventDetailUrl", SOURCE_EVENT_DETAIL_URL_FIELD);
        map.put("sourceEventDetailUrlDisplayText", SOURCE_EVENT_DETAIL_URL_DISPLAY_TEXT_FIELD);
        map.put("notificationType", NOTIFICATION_TYPE_FIELD);
        map.put("eventStatus", EVENT_STATUS_FIELD);
        map.put("aggregationEventType", AGGREGATION_EVENT_TYPE_FIELD);
        map.put("aggregationSummary", AGGREGATION_SUMMARY_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("textParts", TEXT_PARTS_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationEvent, T> g) {
        return obj -> g.apply((ManagedNotificationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedNotificationEvent> {
        /**
         * <p>
         * Version of the <code>ManagedNotificationEvent</code> schema.
         * </p>
         * 
         * @param schemaVersion
         *        Version of the <code>ManagedNotificationEvent</code> schema.
         * @see SchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersion
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * Version of the <code>ManagedNotificationEvent</code> schema.
         * </p>
         * 
         * @param schemaVersion
         *        Version of the <code>ManagedNotificationEvent</code> schema.
         * @see SchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersion
         */
        Builder schemaVersion(SchemaVersion schemaVersion);

        /**
         * <p>
         * Unique identifier for a <code>ManagedNotificationEvent</code>.
         * </p>
         * 
         * @param id
         *        Unique identifier for a <code>ManagedNotificationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the MessageComponents property for this object.
         *
         * @param messageComponents
         *        The new value for the MessageComponents property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageComponents(MessageComponents messageComponents);

        /**
         * Sets the value of the MessageComponents property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MessageComponents.Builder} avoiding the
         * need to create one manually via {@link MessageComponents#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageComponents.Builder#build()} is called immediately and its
         * result is passed to {@link #messageComponents(MessageComponents)}.
         * 
         * @param messageComponents
         *        a consumer that will call methods on {@link MessageComponents.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageComponents(MessageComponents)
         */
        default Builder messageComponents(Consumer<MessageComponents.Builder> messageComponents) {
            return messageComponents(MessageComponents.builder().applyMutation(messageComponents).build());
        }

        /**
         * <p>
         * URL defined by Source Service to be used by notification consumers to get additional information about event.
         * </p>
         * 
         * @param sourceEventDetailUrl
         *        URL defined by Source Service to be used by notification consumers to get additional information about
         *        event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEventDetailUrl(String sourceEventDetailUrl);

        /**
         * <p>
         * Text that needs to be hyperlinked with the sourceEventDetailUrl. For example, the description of the
         * sourceEventDetailUrl.
         * </p>
         * 
         * @param sourceEventDetailUrlDisplayText
         *        Text that needs to be hyperlinked with the sourceEventDetailUrl. For example, the description of the
         *        sourceEventDetailUrl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEventDetailUrlDisplayText(String sourceEventDetailUrlDisplayText);

        /**
         * <p>
         * The nature of the event causing this notification.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALERT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold
         * was breached.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where an issue is about to arise. For example, something is approaching a
         * threshold.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ANNOUNCEMENT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an important event. For example, a step in a workflow or escalation path or that a
         * workflow was updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about informational messages. For example, recommendations, service announcements, or
         * reminders.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        The nature of the event causing this notification.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALERT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where something was triggered, initiated, reopened, deployed, or a
         *        threshold was breached.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where an issue is about to arise. For example, something is approaching
         *        a threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANNOUNCEMENT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an important event. For example, a step in a workflow or escalation path or that
         *        a workflow was updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about informational messages. For example, recommendations, service announcements, or
         *        reminders.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * <p>
         * The nature of the event causing this notification.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALERT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold
         * was breached.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where an issue is about to arise. For example, something is approaching a
         * threshold.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ANNOUNCEMENT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an important event. For example, a step in a workflow or escalation path or that a
         * workflow was updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about informational messages. For example, recommendations, service announcements, or
         * reminders.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        The nature of the event causing this notification.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALERT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where something was triggered, initiated, reopened, deployed, or a
         *        threshold was breached.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where an issue is about to arise. For example, something is approaching
         *        a threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANNOUNCEMENT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an important event. For example, a step in a workflow or escalation path or that
         *        a workflow was updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about informational messages. For example, recommendations, service announcements, or
         *        reminders.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);

        /**
         * <p>
         * The status of an event.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All EventRules are <code>ACTIVE</code> and any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param eventStatus
         *        The status of an event.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All EventRules are <code>ACTIVE</code> and any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see EventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStatus
         */
        Builder eventStatus(String eventStatus);

        /**
         * <p>
         * The status of an event.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All EventRules are <code>ACTIVE</code> and any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param eventStatus
         *        The status of an event.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All EventRules are <code>ACTIVE</code> and any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some EventRules are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see EventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStatus
         */
        Builder eventStatus(EventStatus eventStatus);

        /**
         * <p>
         * The notifications aggregation type.
         * </p>
         * 
         * @param aggregationEventType
         *        The notifications aggregation type.
         * @see AggregationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationEventType
         */
        Builder aggregationEventType(String aggregationEventType);

        /**
         * <p>
         * The notifications aggregation type.
         * </p>
         * 
         * @param aggregationEventType
         *        The notifications aggregation type.
         * @see AggregationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationEventType
         */
        Builder aggregationEventType(AggregationEventType aggregationEventType);

        /**
         * Sets the value of the AggregationSummary property for this object.
         *
         * @param aggregationSummary
         *        The new value for the AggregationSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationSummary(AggregationSummary aggregationSummary);

        /**
         * Sets the value of the AggregationSummary property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AggregationSummary.Builder} avoiding the
         * need to create one manually via {@link AggregationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationSummary(AggregationSummary)}.
         * 
         * @param aggregationSummary
         *        a consumer that will call methods on {@link AggregationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationSummary(AggregationSummary)
         */
        default Builder aggregationSummary(Consumer<AggregationSummary.Builder> aggregationSummary) {
            return aggregationSummary(AggregationSummary.builder().applyMutation(aggregationSummary).build());
        }

        /**
         * <p>
         * The earliest time of events to return from this call.
         * </p>
         * 
         * @param startTime
         *        The earliest time of events to return from this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the notification event.
         * </p>
         * 
         * @param endTime
         *        The end time of the notification event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A list of text values.
         * </p>
         * 
         * @param textParts
         *        A list of text values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textParts(Map<String, TextPartValue> textParts);

        /**
         * <p>
         * The Organizational Unit Id that an Amazon Web Services account belongs to.
         * </p>
         * 
         * @param organizationalUnitId
         *        The Organizational Unit Id that an Amazon Web Services account belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);
    }

    static final class BuilderImpl implements Builder {
        private String schemaVersion;

        private String id;

        private MessageComponents messageComponents;

        private String sourceEventDetailUrl;

        private String sourceEventDetailUrlDisplayText;

        private String notificationType;

        private String eventStatus;

        private String aggregationEventType;

        private AggregationSummary aggregationSummary;

        private Instant startTime;

        private Instant endTime;

        private Map<String, TextPartValue> textParts = DefaultSdkAutoConstructMap.getInstance();

        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationEvent model) {
            schemaVersion(model.schemaVersion);
            id(model.id);
            messageComponents(model.messageComponents);
            sourceEventDetailUrl(model.sourceEventDetailUrl);
            sourceEventDetailUrlDisplayText(model.sourceEventDetailUrlDisplayText);
            notificationType(model.notificationType);
            eventStatus(model.eventStatus);
            aggregationEventType(model.aggregationEventType);
            aggregationSummary(model.aggregationSummary);
            startTime(model.startTime);
            endTime(model.endTime);
            textParts(model.textParts);
            organizationalUnitId(model.organizationalUnitId);
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public final Builder schemaVersion(SchemaVersion schemaVersion) {
            this.schemaVersion(schemaVersion == null ? null : schemaVersion.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MessageComponents.Builder getMessageComponents() {
            return messageComponents != null ? messageComponents.toBuilder() : null;
        }

        public final void setMessageComponents(MessageComponents.BuilderImpl messageComponents) {
            this.messageComponents = messageComponents != null ? messageComponents.build() : null;
        }

        @Override
        public final Builder messageComponents(MessageComponents messageComponents) {
            this.messageComponents = messageComponents;
            return this;
        }

        public final String getSourceEventDetailUrl() {
            return sourceEventDetailUrl;
        }

        public final void setSourceEventDetailUrl(String sourceEventDetailUrl) {
            this.sourceEventDetailUrl = sourceEventDetailUrl;
        }

        @Override
        public final Builder sourceEventDetailUrl(String sourceEventDetailUrl) {
            this.sourceEventDetailUrl = sourceEventDetailUrl;
            return this;
        }

        public final String getSourceEventDetailUrlDisplayText() {
            return sourceEventDetailUrlDisplayText;
        }

        public final void setSourceEventDetailUrlDisplayText(String sourceEventDetailUrlDisplayText) {
            this.sourceEventDetailUrlDisplayText = sourceEventDetailUrlDisplayText;
        }

        @Override
        public final Builder sourceEventDetailUrlDisplayText(String sourceEventDetailUrlDisplayText) {
            this.sourceEventDetailUrlDisplayText = sourceEventDetailUrlDisplayText;
            return this;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        public final String getEventStatus() {
            return eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(EventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final String getAggregationEventType() {
            return aggregationEventType;
        }

        public final void setAggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
        }

        @Override
        public final Builder aggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
            return this;
        }

        @Override
        public final Builder aggregationEventType(AggregationEventType aggregationEventType) {
            this.aggregationEventType(aggregationEventType == null ? null : aggregationEventType.toString());
            return this;
        }

        public final AggregationSummary.Builder getAggregationSummary() {
            return aggregationSummary != null ? aggregationSummary.toBuilder() : null;
        }

        public final void setAggregationSummary(AggregationSummary.BuilderImpl aggregationSummary) {
            this.aggregationSummary = aggregationSummary != null ? aggregationSummary.build() : null;
        }

        @Override
        public final Builder aggregationSummary(AggregationSummary aggregationSummary) {
            this.aggregationSummary = aggregationSummary;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Map<String, TextPartValue.Builder> getTextParts() {
            Map<String, TextPartValue.Builder> result = TextPartsCopier.copyToBuilder(this.textParts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTextParts(Map<String, TextPartValue.BuilderImpl> textParts) {
            this.textParts = TextPartsCopier.copyFromBuilder(textParts);
        }

        @Override
        public final Builder textParts(Map<String, TextPartValue> textParts) {
            this.textParts = TextPartsCopier.copy(textParts);
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        @Override
        public ManagedNotificationEvent build() {
            return new ManagedNotificationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
