/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an overview and metadata for a ManagedNotificationEvent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedNotificationEventOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedNotificationEventOverview.Builder, ManagedNotificationEventOverview> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ManagedNotificationEventOverview::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("managedNotificationConfigurationArn")
            .getter(getter(ManagedNotificationEventOverview::managedNotificationConfigurationArn))
            .setter(setter(Builder::managedNotificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("managedNotificationConfigurationArn").build()).build();

    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedAccount").getter(getter(ManagedNotificationEventOverview::relatedAccount))
            .setter(setter(Builder::relatedAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedAccount").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ManagedNotificationEventOverview::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ManagedNotificationEventSummary> NOTIFICATION_EVENT_FIELD = SdkField
            .<ManagedNotificationEventSummary> builder(MarshallingType.SDK_POJO).memberName("notificationEvent")
            .getter(getter(ManagedNotificationEventOverview::notificationEvent)).setter(setter(Builder::notificationEvent))
            .constructor(ManagedNotificationEventSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEvent").build()).build();

    private static final SdkField<String> AGGREGATION_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationEventType").getter(getter(ManagedNotificationEventOverview::aggregationEventTypeAsString))
            .setter(setter(Builder::aggregationEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationEventType").build())
            .build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitId").getter(getter(ManagedNotificationEventOverview::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitId").build())
            .build();

    private static final SdkField<AggregationSummary> AGGREGATION_SUMMARY_FIELD = SdkField
            .<AggregationSummary> builder(MarshallingType.SDK_POJO).memberName("aggregationSummary")
            .getter(getter(ManagedNotificationEventOverview::aggregationSummary)).setter(setter(Builder::aggregationSummary))
            .constructor(AggregationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationSummary").build())
            .build();

    private static final SdkField<List<String>> AGGREGATED_NOTIFICATION_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("aggregatedNotificationRegions")
            .getter(getter(ManagedNotificationEventOverview::aggregatedNotificationRegions))
            .setter(setter(Builder::aggregatedNotificationRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedNotificationRegions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD, RELATED_ACCOUNT_FIELD, CREATION_TIME_FIELD, NOTIFICATION_EVENT_FIELD,
            AGGREGATION_EVENT_TYPE_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD, AGGREGATION_SUMMARY_FIELD,
            AGGREGATED_NOTIFICATION_REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String managedNotificationConfigurationArn;

    private final String relatedAccount;

    private final Instant creationTime;

    private final ManagedNotificationEventSummary notificationEvent;

    private final String aggregationEventType;

    private final String organizationalUnitId;

    private final AggregationSummary aggregationSummary;

    private final List<String> aggregatedNotificationRegions;

    private ManagedNotificationEventOverview(BuilderImpl builder) {
        this.arn = builder.arn;
        this.managedNotificationConfigurationArn = builder.managedNotificationConfigurationArn;
        this.relatedAccount = builder.relatedAccount;
        this.creationTime = builder.creationTime;
        this.notificationEvent = builder.notificationEvent;
        this.aggregationEventType = builder.aggregationEventType;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.aggregationSummary = builder.aggregationSummary;
        this.aggregatedNotificationRegions = builder.aggregatedNotificationRegions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ManagedNotificationEvent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ManagedNotificationEvent.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code>.
     */
    public final String managedNotificationConfigurationArn() {
        return managedNotificationConfigurationArn;
    }

    /**
     * <p>
     * The account that related to the <code>ManagedNotificationEvent</code>.
     * </p>
     * 
     * @return The account that related to the <code>ManagedNotificationEvent</code>.
     */
    public final String relatedAccount() {
        return relatedAccount;
    }

    /**
     * <p>
     * The creation time of the <code>ManagedNotificationEvent</code>.
     * </p>
     * 
     * @return The creation time of the <code>ManagedNotificationEvent</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the NotificationEvent property for this object.
     * 
     * @return The value of the NotificationEvent property for this object.
     */
    public final ManagedNotificationEventSummary notificationEvent() {
        return notificationEvent;
    }

    /**
     * <p>
     * The notifications aggregation type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AGGREGATE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The notification event is an aggregate notification. Aggregate notifications summarize grouped events over a
     * specified time period.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The notification isn't aggregated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationEventType} will return {@link AggregationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationEventTypeAsString}.
     * </p>
     * 
     * @return The notifications aggregation type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AGGREGATE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The notification event is an aggregate notification. Aggregate notifications summarize grouped events
     *         over a specified time period.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be
     *         run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The notification isn't aggregated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see AggregationEventType
     */
    public final AggregationEventType aggregationEventType() {
        return AggregationEventType.fromValue(aggregationEventType);
    }

    /**
     * <p>
     * The notifications aggregation type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AGGREGATE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The notification event is an aggregate notification. Aggregate notifications summarize grouped events over a
     * specified time period.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The notification isn't aggregated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationEventType} will return {@link AggregationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationEventTypeAsString}.
     * </p>
     * 
     * @return The notifications aggregation type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AGGREGATE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The notification event is an aggregate notification. Aggregate notifications summarize grouped events
     *         over a specified time period.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be
     *         run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The notification isn't aggregated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see AggregationEventType
     */
    public final String aggregationEventTypeAsString() {
        return aggregationEventType;
    }

    /**
     * <p>
     * The Organizational Unit Id that an Amazon Web Services account belongs to.
     * </p>
     * 
     * @return The Organizational Unit Id that an Amazon Web Services account belongs to.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    /**
     * Returns the value of the AggregationSummary property for this object.
     * 
     * @return The value of the AggregationSummary property for this object.
     */
    public final AggregationSummary aggregationSummary() {
        return aggregationSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregatedNotificationRegions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAggregatedNotificationRegions() {
        return aggregatedNotificationRegions != null && !(aggregatedNotificationRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the regions where the aggregated notifications in this <code>NotificationEvent</code> originated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregatedNotificationRegions} method.
     * </p>
     * 
     * @return The list of the regions where the aggregated notifications in this <code>NotificationEvent</code>
     *         originated.
     */
    public final List<String> aggregatedNotificationRegions() {
        return aggregatedNotificationRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(managedNotificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(relatedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEvent());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregatedNotificationRegions() ? aggregatedNotificationRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationEventOverview)) {
            return false;
        }
        ManagedNotificationEventOverview other = (ManagedNotificationEventOverview) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(managedNotificationConfigurationArn(), other.managedNotificationConfigurationArn())
                && Objects.equals(relatedAccount(), other.relatedAccount())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(notificationEvent(), other.notificationEvent())
                && Objects.equals(aggregationEventTypeAsString(), other.aggregationEventTypeAsString())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId())
                && Objects.equals(aggregationSummary(), other.aggregationSummary())
                && hasAggregatedNotificationRegions() == other.hasAggregatedNotificationRegions()
                && Objects.equals(aggregatedNotificationRegions(), other.aggregatedNotificationRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ManagedNotificationEventOverview")
                .add("Arn", arn())
                .add("ManagedNotificationConfigurationArn", managedNotificationConfigurationArn())
                .add("RelatedAccount", relatedAccount())
                .add("CreationTime", creationTime())
                .add("NotificationEvent", notificationEvent())
                .add("AggregationEventType", aggregationEventTypeAsString())
                .add("OrganizationalUnitId", organizationalUnitId())
                .add("AggregationSummary", aggregationSummary())
                .add("AggregatedNotificationRegions", hasAggregatedNotificationRegions() ? aggregatedNotificationRegions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "managedNotificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(managedNotificationConfigurationArn()));
        case "relatedAccount":
            return Optional.ofNullable(clazz.cast(relatedAccount()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "notificationEvent":
            return Optional.ofNullable(clazz.cast(notificationEvent()));
        case "aggregationEventType":
            return Optional.ofNullable(clazz.cast(aggregationEventTypeAsString()));
        case "organizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        case "aggregationSummary":
            return Optional.ofNullable(clazz.cast(aggregationSummary()));
        case "aggregatedNotificationRegions":
            return Optional.ofNullable(clazz.cast(aggregatedNotificationRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("managedNotificationConfigurationArn", MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("notificationEvent", NOTIFICATION_EVENT_FIELD);
        map.put("aggregationEventType", AGGREGATION_EVENT_TYPE_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("aggregationSummary", AGGREGATION_SUMMARY_FIELD);
        map.put("aggregatedNotificationRegions", AGGREGATED_NOTIFICATION_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationEventOverview, T> g) {
        return obj -> g.apply((ManagedNotificationEventOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedNotificationEventOverview> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ManagedNotificationEvent.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the ManagedNotificationEvent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code>.
         * </p>
         * 
         * @param managedNotificationConfigurationArn
         *        The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn);

        /**
         * <p>
         * The account that related to the <code>ManagedNotificationEvent</code>.
         * </p>
         * 
         * @param relatedAccount
         *        The account that related to the <code>ManagedNotificationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedAccount(String relatedAccount);

        /**
         * <p>
         * The creation time of the <code>ManagedNotificationEvent</code>.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the <code>ManagedNotificationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the NotificationEvent property for this object.
         *
         * @param notificationEvent
         *        The new value for the NotificationEvent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEvent(ManagedNotificationEventSummary notificationEvent);

        /**
         * Sets the value of the NotificationEvent property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ManagedNotificationEventSummary.Builder}
         * avoiding the need to create one manually via {@link ManagedNotificationEventSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedNotificationEventSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationEvent(ManagedNotificationEventSummary)}.
         * 
         * @param notificationEvent
         *        a consumer that will call methods on {@link ManagedNotificationEventSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationEvent(ManagedNotificationEventSummary)
         */
        default Builder notificationEvent(Consumer<ManagedNotificationEventSummary.Builder> notificationEvent) {
            return notificationEvent(ManagedNotificationEventSummary.builder().applyMutation(notificationEvent).build());
        }

        /**
         * <p>
         * The notifications aggregation type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AGGREGATE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The notification event is an aggregate notification. Aggregate notifications summarize grouped events over a
         * specified time period.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The notification isn't aggregated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param aggregationEventType
         *        The notifications aggregation type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AGGREGATE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The notification event is an aggregate notification. Aggregate notifications summarize grouped events
         *        over a specified time period.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can
         *        be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The notification isn't aggregated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see AggregationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationEventType
         */
        Builder aggregationEventType(String aggregationEventType);

        /**
         * <p>
         * The notifications aggregation type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AGGREGATE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The notification event is an aggregate notification. Aggregate notifications summarize grouped events over a
         * specified time period.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The notification isn't aggregated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param aggregationEventType
         *        The notifications aggregation type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AGGREGATE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The notification event is an aggregate notification. Aggregate notifications summarize grouped events
         *        over a specified time period.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can
         *        be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The notification isn't aggregated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see AggregationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationEventType
         */
        Builder aggregationEventType(AggregationEventType aggregationEventType);

        /**
         * <p>
         * The Organizational Unit Id that an Amazon Web Services account belongs to.
         * </p>
         * 
         * @param organizationalUnitId
         *        The Organizational Unit Id that an Amazon Web Services account belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        /**
         * Sets the value of the AggregationSummary property for this object.
         *
         * @param aggregationSummary
         *        The new value for the AggregationSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationSummary(AggregationSummary aggregationSummary);

        /**
         * Sets the value of the AggregationSummary property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AggregationSummary.Builder} avoiding the
         * need to create one manually via {@link AggregationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationSummary(AggregationSummary)}.
         * 
         * @param aggregationSummary
         *        a consumer that will call methods on {@link AggregationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationSummary(AggregationSummary)
         */
        default Builder aggregationSummary(Consumer<AggregationSummary.Builder> aggregationSummary) {
            return aggregationSummary(AggregationSummary.builder().applyMutation(aggregationSummary).build());
        }

        /**
         * <p>
         * The list of the regions where the aggregated notifications in this <code>NotificationEvent</code> originated.
         * </p>
         * 
         * @param aggregatedNotificationRegions
         *        The list of the regions where the aggregated notifications in this <code>NotificationEvent</code>
         *        originated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedNotificationRegions(Collection<String> aggregatedNotificationRegions);

        /**
         * <p>
         * The list of the regions where the aggregated notifications in this <code>NotificationEvent</code> originated.
         * </p>
         * 
         * @param aggregatedNotificationRegions
         *        The list of the regions where the aggregated notifications in this <code>NotificationEvent</code>
         *        originated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedNotificationRegions(String... aggregatedNotificationRegions);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String managedNotificationConfigurationArn;

        private String relatedAccount;

        private Instant creationTime;

        private ManagedNotificationEventSummary notificationEvent;

        private String aggregationEventType;

        private String organizationalUnitId;

        private AggregationSummary aggregationSummary;

        private List<String> aggregatedNotificationRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationEventOverview model) {
            arn(model.arn);
            managedNotificationConfigurationArn(model.managedNotificationConfigurationArn);
            relatedAccount(model.relatedAccount);
            creationTime(model.creationTime);
            notificationEvent(model.notificationEvent);
            aggregationEventType(model.aggregationEventType);
            organizationalUnitId(model.organizationalUnitId);
            aggregationSummary(model.aggregationSummary);
            aggregatedNotificationRegions(model.aggregatedNotificationRegions);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getManagedNotificationConfigurationArn() {
            return managedNotificationConfigurationArn;
        }

        public final void setManagedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
        }

        @Override
        public final Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        public final String getRelatedAccount() {
            return relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ManagedNotificationEventSummary.Builder getNotificationEvent() {
            return notificationEvent != null ? notificationEvent.toBuilder() : null;
        }

        public final void setNotificationEvent(ManagedNotificationEventSummary.BuilderImpl notificationEvent) {
            this.notificationEvent = notificationEvent != null ? notificationEvent.build() : null;
        }

        @Override
        public final Builder notificationEvent(ManagedNotificationEventSummary notificationEvent) {
            this.notificationEvent = notificationEvent;
            return this;
        }

        public final String getAggregationEventType() {
            return aggregationEventType;
        }

        public final void setAggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
        }

        @Override
        public final Builder aggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
            return this;
        }

        @Override
        public final Builder aggregationEventType(AggregationEventType aggregationEventType) {
            this.aggregationEventType(aggregationEventType == null ? null : aggregationEventType.toString());
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final AggregationSummary.Builder getAggregationSummary() {
            return aggregationSummary != null ? aggregationSummary.toBuilder() : null;
        }

        public final void setAggregationSummary(AggregationSummary.BuilderImpl aggregationSummary) {
            this.aggregationSummary = aggregationSummary != null ? aggregationSummary.build() : null;
        }

        @Override
        public final Builder aggregationSummary(AggregationSummary aggregationSummary) {
            this.aggregationSummary = aggregationSummary;
            return this;
        }

        public final Collection<String> getAggregatedNotificationRegions() {
            if (aggregatedNotificationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return aggregatedNotificationRegions;
        }

        public final void setAggregatedNotificationRegions(Collection<String> aggregatedNotificationRegions) {
            this.aggregatedNotificationRegions = AggregatedNotificationRegionsCopier.copy(aggregatedNotificationRegions);
        }

        @Override
        public final Builder aggregatedNotificationRegions(Collection<String> aggregatedNotificationRegions) {
            this.aggregatedNotificationRegions = AggregatedNotificationRegionsCopier.copy(aggregatedNotificationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedNotificationRegions(String... aggregatedNotificationRegions) {
            aggregatedNotificationRegions(Arrays.asList(aggregatedNotificationRegions));
            return this;
        }

        @Override
        public ManagedNotificationEventOverview build() {
            return new ManagedNotificationEventOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
