/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a short summary of a <code>NotificationEvent</code>. This is only used when listing notification events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationEventOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationEventOverview.Builder, NotificationEventOverview> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(NotificationEventOverview::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("notificationConfigurationArn")
            .getter(getter(NotificationEventOverview::notificationConfigurationArn))
            .setter(setter(Builder::notificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn")
                    .build()).build();

    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedAccount").getter(getter(NotificationEventOverview::relatedAccount))
            .setter(setter(Builder::relatedAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedAccount").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(NotificationEventOverview::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<NotificationEventSummary> NOTIFICATION_EVENT_FIELD = SdkField
            .<NotificationEventSummary> builder(MarshallingType.SDK_POJO).memberName("notificationEvent")
            .getter(getter(NotificationEventOverview::notificationEvent)).setter(setter(Builder::notificationEvent))
            .constructor(NotificationEventSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEvent").build()).build();

    private static final SdkField<String> AGGREGATION_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationEventType").getter(getter(NotificationEventOverview::aggregationEventTypeAsString))
            .setter(setter(Builder::aggregationEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationEventType").build())
            .build();

    private static final SdkField<String> AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("aggregateNotificationEventArn")
            .getter(getter(NotificationEventOverview::aggregateNotificationEventArn))
            .setter(setter(Builder::aggregateNotificationEventArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateNotificationEventArn")
                    .build()).build();

    private static final SdkField<AggregationSummary> AGGREGATION_SUMMARY_FIELD = SdkField
            .<AggregationSummary> builder(MarshallingType.SDK_POJO).memberName("aggregationSummary")
            .getter(getter(NotificationEventOverview::aggregationSummary)).setter(setter(Builder::aggregationSummary))
            .constructor(AggregationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            NOTIFICATION_CONFIGURATION_ARN_FIELD, RELATED_ACCOUNT_FIELD, CREATION_TIME_FIELD, NOTIFICATION_EVENT_FIELD,
            AGGREGATION_EVENT_TYPE_FIELD, AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD, AGGREGATION_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String notificationConfigurationArn;

    private final String relatedAccount;

    private final Instant creationTime;

    private final NotificationEventSummary notificationEvent;

    private final String aggregationEventType;

    private final String aggregateNotificationEventArn;

    private final AggregationSummary aggregationSummary;

    private NotificationEventOverview(BuilderImpl builder) {
        this.arn = builder.arn;
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.relatedAccount = builder.relatedAccount;
        this.creationTime = builder.creationTime;
        this.notificationEvent = builder.notificationEvent;
        this.aggregationEventType = builder.aggregationEventType;
        this.aggregateNotificationEventArn = builder.aggregateNotificationEventArn;
        this.aggregationSummary = builder.aggregationSummary;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The ARN of the <code>NotificationConfiguration</code>.
     */
    public final String notificationConfigurationArn() {
        return notificationConfigurationArn;
    }

    /**
     * <p>
     * The account name containing the <code>NotificationHub</code>.
     * </p>
     * 
     * @return The account name containing the <code>NotificationHub</code>.
     */
    public final String relatedAccount() {
        return relatedAccount;
    }

    /**
     * <p>
     * The creation time of the <code>NotificationEvent</code>.
     * </p>
     * 
     * @return The creation time of the <code>NotificationEvent</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Refers to a <code>NotificationEventSummary</code> object.
     * </p>
     * <p>
     * Similar in structure to <code>content</code> in the <code>GetNotificationEvent</code> response.
     * </p>
     * 
     * @return Refers to a <code>NotificationEventSummary</code> object.</p>
     *         <p>
     *         Similar in structure to <code>content</code> in the <code>GetNotificationEvent</code> response.
     */
    public final NotificationEventSummary notificationEvent() {
        return notificationEvent;
    }

    /**
     * <p>
     * The <code>NotificationConfiguration</code>'s aggregation type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AGGREGATE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The notification event is an aggregate notification. Aggregate notifications summarize grouped events over a
     * specified time period.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The notification isn't aggregated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationEventType} will return {@link AggregationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationEventTypeAsString}.
     * </p>
     * 
     * @return The <code>NotificationConfiguration</code>'s aggregation type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AGGREGATE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The notification event is an aggregate notification. Aggregate notifications summarize grouped events
     *         over a specified time period.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be
     *         run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The notification isn't aggregated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see AggregationEventType
     */
    public final AggregationEventType aggregationEventType() {
        return AggregationEventType.fromValue(aggregationEventType);
    }

    /**
     * <p>
     * The <code>NotificationConfiguration</code>'s aggregation type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AGGREGATE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The notification event is an aggregate notification. Aggregate notifications summarize grouped events over a
     * specified time period.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The notification isn't aggregated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationEventType} will return {@link AggregationEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationEventTypeAsString}.
     * </p>
     * 
     * @return The <code>NotificationConfiguration</code>'s aggregation type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AGGREGATE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The notification event is an aggregate notification. Aggregate notifications summarize grouped events
     *         over a specified time period.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be
     *         run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The notification isn't aggregated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see AggregationEventType
     */
    public final String aggregationEventTypeAsString() {
        return aggregationEventType;
    }

    /**
     * <p>
     * The ARN of the <code>aggregatedNotificationEventArn</code> to match.
     * </p>
     * 
     * @return The ARN of the <code>aggregatedNotificationEventArn</code> to match.
     */
    public final String aggregateNotificationEventArn() {
        return aggregateNotificationEventArn;
    }

    /**
     * <p>
     * Provides an aggregated summary data for notification events.
     * </p>
     * 
     * @return Provides an aggregated summary data for notification events.
     */
    public final AggregationSummary aggregationSummary() {
        return aggregationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(relatedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEvent());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateNotificationEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationEventOverview)) {
            return false;
        }
        NotificationEventOverview other = (NotificationEventOverview) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(notificationConfigurationArn(), other.notificationConfigurationArn())
                && Objects.equals(relatedAccount(), other.relatedAccount())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(notificationEvent(), other.notificationEvent())
                && Objects.equals(aggregationEventTypeAsString(), other.aggregationEventTypeAsString())
                && Objects.equals(aggregateNotificationEventArn(), other.aggregateNotificationEventArn())
                && Objects.equals(aggregationSummary(), other.aggregationSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationEventOverview").add("Arn", arn())
                .add("NotificationConfigurationArn", notificationConfigurationArn()).add("RelatedAccount", relatedAccount())
                .add("CreationTime", creationTime()).add("NotificationEvent", notificationEvent())
                .add("AggregationEventType", aggregationEventTypeAsString())
                .add("AggregateNotificationEventArn", aggregateNotificationEventArn())
                .add("AggregationSummary", aggregationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "notificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(notificationConfigurationArn()));
        case "relatedAccount":
            return Optional.ofNullable(clazz.cast(relatedAccount()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "notificationEvent":
            return Optional.ofNullable(clazz.cast(notificationEvent()));
        case "aggregationEventType":
            return Optional.ofNullable(clazz.cast(aggregationEventTypeAsString()));
        case "aggregateNotificationEventArn":
            return Optional.ofNullable(clazz.cast(aggregateNotificationEventArn()));
        case "aggregationSummary":
            return Optional.ofNullable(clazz.cast(aggregationSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("notificationEvent", NOTIFICATION_EVENT_FIELD);
        map.put("aggregationEventType", AGGREGATION_EVENT_TYPE_FIELD);
        map.put("aggregateNotificationEventArn", AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD);
        map.put("aggregationSummary", AGGREGATION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationEventOverview, T> g) {
        return obj -> g.apply((NotificationEventOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationEventOverview> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param notificationConfigurationArn
         *        The ARN of the <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurationArn(String notificationConfigurationArn);

        /**
         * <p>
         * The account name containing the <code>NotificationHub</code>.
         * </p>
         * 
         * @param relatedAccount
         *        The account name containing the <code>NotificationHub</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedAccount(String relatedAccount);

        /**
         * <p>
         * The creation time of the <code>NotificationEvent</code>.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the <code>NotificationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Refers to a <code>NotificationEventSummary</code> object.
         * </p>
         * <p>
         * Similar in structure to <code>content</code> in the <code>GetNotificationEvent</code> response.
         * </p>
         * 
         * @param notificationEvent
         *        Refers to a <code>NotificationEventSummary</code> object.</p>
         *        <p>
         *        Similar in structure to <code>content</code> in the <code>GetNotificationEvent</code> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEvent(NotificationEventSummary notificationEvent);

        /**
         * <p>
         * Refers to a <code>NotificationEventSummary</code> object.
         * </p>
         * <p>
         * Similar in structure to <code>content</code> in the <code>GetNotificationEvent</code> response.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationEventSummary.Builder}
         * avoiding the need to create one manually via {@link NotificationEventSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationEventSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationEvent(NotificationEventSummary)}.
         * 
         * @param notificationEvent
         *        a consumer that will call methods on {@link NotificationEventSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationEvent(NotificationEventSummary)
         */
        default Builder notificationEvent(Consumer<NotificationEventSummary.Builder> notificationEvent) {
            return notificationEvent(NotificationEventSummary.builder().applyMutation(notificationEvent).build());
        }

        /**
         * <p>
         * The <code>NotificationConfiguration</code>'s aggregation type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AGGREGATE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The notification event is an aggregate notification. Aggregate notifications summarize grouped events over a
         * specified time period.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The notification isn't aggregated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param aggregationEventType
         *        The <code>NotificationConfiguration</code>'s aggregation type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AGGREGATE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The notification event is an aggregate notification. Aggregate notifications summarize grouped events
         *        over a specified time period.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can
         *        be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The notification isn't aggregated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see AggregationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationEventType
         */
        Builder aggregationEventType(String aggregationEventType);

        /**
         * <p>
         * The <code>NotificationConfiguration</code>'s aggregation type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AGGREGATE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The notification event is an aggregate notification. Aggregate notifications summarize grouped events over a
         * specified time period.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The notification isn't aggregated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param aggregationEventType
         *        The <code>NotificationConfiguration</code>'s aggregation type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AGGREGATE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The notification event is an aggregate notification. Aggregate notifications summarize grouped events
         *        over a specified time period.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can
         *        be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The notification isn't aggregated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see AggregationEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationEventType
         */
        Builder aggregationEventType(AggregationEventType aggregationEventType);

        /**
         * <p>
         * The ARN of the <code>aggregatedNotificationEventArn</code> to match.
         * </p>
         * 
         * @param aggregateNotificationEventArn
         *        The ARN of the <code>aggregatedNotificationEventArn</code> to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateNotificationEventArn(String aggregateNotificationEventArn);

        /**
         * <p>
         * Provides an aggregated summary data for notification events.
         * </p>
         * 
         * @param aggregationSummary
         *        Provides an aggregated summary data for notification events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationSummary(AggregationSummary aggregationSummary);

        /**
         * <p>
         * Provides an aggregated summary data for notification events.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationSummary.Builder} avoiding the
         * need to create one manually via {@link AggregationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationSummary(AggregationSummary)}.
         * 
         * @param aggregationSummary
         *        a consumer that will call methods on {@link AggregationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationSummary(AggregationSummary)
         */
        default Builder aggregationSummary(Consumer<AggregationSummary.Builder> aggregationSummary) {
            return aggregationSummary(AggregationSummary.builder().applyMutation(aggregationSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String notificationConfigurationArn;

        private String relatedAccount;

        private Instant creationTime;

        private NotificationEventSummary notificationEvent;

        private String aggregationEventType;

        private String aggregateNotificationEventArn;

        private AggregationSummary aggregationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationEventOverview model) {
            arn(model.arn);
            notificationConfigurationArn(model.notificationConfigurationArn);
            relatedAccount(model.relatedAccount);
            creationTime(model.creationTime);
            notificationEvent(model.notificationEvent);
            aggregationEventType(model.aggregationEventType);
            aggregateNotificationEventArn(model.aggregateNotificationEventArn);
            aggregationSummary(model.aggregationSummary);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNotificationConfigurationArn() {
            return notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final String getRelatedAccount() {
            return relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final NotificationEventSummary.Builder getNotificationEvent() {
            return notificationEvent != null ? notificationEvent.toBuilder() : null;
        }

        public final void setNotificationEvent(NotificationEventSummary.BuilderImpl notificationEvent) {
            this.notificationEvent = notificationEvent != null ? notificationEvent.build() : null;
        }

        @Override
        public final Builder notificationEvent(NotificationEventSummary notificationEvent) {
            this.notificationEvent = notificationEvent;
            return this;
        }

        public final String getAggregationEventType() {
            return aggregationEventType;
        }

        public final void setAggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
        }

        @Override
        public final Builder aggregationEventType(String aggregationEventType) {
            this.aggregationEventType = aggregationEventType;
            return this;
        }

        @Override
        public final Builder aggregationEventType(AggregationEventType aggregationEventType) {
            this.aggregationEventType(aggregationEventType == null ? null : aggregationEventType.toString());
            return this;
        }

        public final String getAggregateNotificationEventArn() {
            return aggregateNotificationEventArn;
        }

        public final void setAggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
        }

        @Override
        public final Builder aggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
            return this;
        }

        public final AggregationSummary.Builder getAggregationSummary() {
            return aggregationSummary != null ? aggregationSummary.toBuilder() : null;
        }

        public final void setAggregationSummary(AggregationSummary.BuilderImpl aggregationSummary) {
            this.aggregationSummary = aggregationSummary != null ? aggregationSummary.build() : null;
        }

        @Override
        public final Builder aggregationSummary(AggregationSummary aggregationSummary) {
            this.aggregationSummary = aggregationSummary;
            return this;
        }

        @Override
        public NotificationEventOverview build() {
            return new NotificationEventOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
