/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an overview of a <code>NotificationHub</code>.
 * </p>
 * <p>
 * A <code>NotificationConfiguration</code> is an account-level setting used to select the Regions where you want to
 * store, process and replicate your notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationHubOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationHubOverview.Builder, NotificationHubOverview> {
    private static final SdkField<String> NOTIFICATION_HUB_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationHubRegion").getter(getter(NotificationHubOverview::notificationHubRegion))
            .setter(setter(Builder::notificationHubRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationHubRegion").build())
            .build();

    private static final SdkField<NotificationHubStatusSummary> STATUS_SUMMARY_FIELD = SdkField
            .<NotificationHubStatusSummary> builder(MarshallingType.SDK_POJO).memberName("statusSummary")
            .getter(getter(NotificationHubOverview::statusSummary)).setter(setter(Builder::statusSummary))
            .constructor(NotificationHubStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(NotificationHubOverview::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_ACTIVATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastActivationTime")
            .getter(getter(NotificationHubOverview::lastActivationTime))
            .setter(setter(Builder::lastActivationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActivationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_HUB_REGION_FIELD,
            STATUS_SUMMARY_FIELD, CREATION_TIME_FIELD, LAST_ACTIVATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String notificationHubRegion;

    private final NotificationHubStatusSummary statusSummary;

    private final Instant creationTime;

    private final Instant lastActivationTime;

    private NotificationHubOverview(BuilderImpl builder) {
        this.notificationHubRegion = builder.notificationHubRegion;
        this.statusSummary = builder.statusSummary;
        this.creationTime = builder.creationTime;
        this.lastActivationTime = builder.lastActivationTime;
    }

    /**
     * <p>
     * The Region of the resource.
     * </p>
     * 
     * @return The Region of the resource.
     */
    public final String notificationHubRegion() {
        return notificationHubRegion;
    }

    /**
     * <p>
     * The status summary of the resource.
     * </p>
     * 
     * @return The status summary of the resource.
     */
    public final NotificationHubStatusSummary statusSummary() {
        return statusSummary;
    }

    /**
     * <p>
     * The date and time the <code>NotificationHubOverview</code> was created.
     * </p>
     * 
     * @return The date and time the <code>NotificationHubOverview</code> was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The most recent time this <code>NotificationHub</code> had an <code>ACTIVE</code> status.
     * </p>
     * 
     * @return The most recent time this <code>NotificationHub</code> had an <code>ACTIVE</code> status.
     */
    public final Instant lastActivationTime() {
        return lastActivationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationHubRegion());
        hashCode = 31 * hashCode + Objects.hashCode(statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastActivationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationHubOverview)) {
            return false;
        }
        NotificationHubOverview other = (NotificationHubOverview) obj;
        return Objects.equals(notificationHubRegion(), other.notificationHubRegion())
                && Objects.equals(statusSummary(), other.statusSummary()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastActivationTime(), other.lastActivationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationHubOverview").add("NotificationHubRegion", notificationHubRegion())
                .add("StatusSummary", statusSummary()).add("CreationTime", creationTime())
                .add("LastActivationTime", lastActivationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationHubRegion":
            return Optional.ofNullable(clazz.cast(notificationHubRegion()));
        case "statusSummary":
            return Optional.ofNullable(clazz.cast(statusSummary()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastActivationTime":
            return Optional.ofNullable(clazz.cast(lastActivationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("notificationHubRegion", NOTIFICATION_HUB_REGION_FIELD);
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastActivationTime", LAST_ACTIVATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationHubOverview, T> g) {
        return obj -> g.apply((NotificationHubOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationHubOverview> {
        /**
         * <p>
         * The Region of the resource.
         * </p>
         * 
         * @param notificationHubRegion
         *        The Region of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationHubRegion(String notificationHubRegion);

        /**
         * <p>
         * The status summary of the resource.
         * </p>
         * 
         * @param statusSummary
         *        The status summary of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummary(NotificationHubStatusSummary statusSummary);

        /**
         * <p>
         * The status summary of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationHubStatusSummary.Builder}
         * avoiding the need to create one manually via {@link NotificationHubStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationHubStatusSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #statusSummary(NotificationHubStatusSummary)}.
         * 
         * @param statusSummary
         *        a consumer that will call methods on {@link NotificationHubStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummary(NotificationHubStatusSummary)
         */
        default Builder statusSummary(Consumer<NotificationHubStatusSummary.Builder> statusSummary) {
            return statusSummary(NotificationHubStatusSummary.builder().applyMutation(statusSummary).build());
        }

        /**
         * <p>
         * The date and time the <code>NotificationHubOverview</code> was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time the <code>NotificationHubOverview</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The most recent time this <code>NotificationHub</code> had an <code>ACTIVE</code> status.
         * </p>
         * 
         * @param lastActivationTime
         *        The most recent time this <code>NotificationHub</code> had an <code>ACTIVE</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastActivationTime(Instant lastActivationTime);
    }

    static final class BuilderImpl implements Builder {
        private String notificationHubRegion;

        private NotificationHubStatusSummary statusSummary;

        private Instant creationTime;

        private Instant lastActivationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationHubOverview model) {
            notificationHubRegion(model.notificationHubRegion);
            statusSummary(model.statusSummary);
            creationTime(model.creationTime);
            lastActivationTime(model.lastActivationTime);
        }

        public final String getNotificationHubRegion() {
            return notificationHubRegion;
        }

        public final void setNotificationHubRegion(String notificationHubRegion) {
            this.notificationHubRegion = notificationHubRegion;
        }

        @Override
        public final Builder notificationHubRegion(String notificationHubRegion) {
            this.notificationHubRegion = notificationHubRegion;
            return this;
        }

        public final NotificationHubStatusSummary.Builder getStatusSummary() {
            return statusSummary != null ? statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(NotificationHubStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(NotificationHubStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastActivationTime() {
            return lastActivationTime;
        }

        public final void setLastActivationTime(Instant lastActivationTime) {
            this.lastActivationTime = lastActivationTime;
        }

        @Override
        public final Builder lastActivationTime(Instant lastActivationTime) {
            this.lastActivationTime = lastActivationTime;
            return this;
        }

        @Override
        public NotificationHubOverview build() {
            return new NotificationHubOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
