/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides additional information about the current <code>NotificationHub</code> status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationHubStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationHubStatusSummary.Builder, NotificationHubStatusSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(NotificationHubStatusSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(NotificationHubStatusSummary::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String reason;

    private NotificationHubStatusSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * Status information about the <code>NotificationHub</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Incoming <code>NotificationEvents</code> are replicated to this <code>NotificationHub</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>REGISTERING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>NotificationConfiguration</code> is initializing. A <code>NotificationConfiguration</code> with this
     * status can't be deregistered.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>DEREGISTERING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>NotificationConfiguration</code> is being deleted. You can't register additional
     * <code>NotificationHubs</code> in the same Region as a <code>NotificationConfiguration</code> with this status.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationHubStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status information about the <code>NotificationHub</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Incoming <code>NotificationEvents</code> are replicated to this <code>NotificationHub</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGISTERING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>NotificationConfiguration</code> is initializing. A <code>NotificationConfiguration</code> with
     *         this status can't be deregistered.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEREGISTERING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>NotificationConfiguration</code> is being deleted. You can't register additional
     *         <code>NotificationHubs</code> in the same Region as a <code>NotificationConfiguration</code> with this
     *         status.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationHubStatus
     */
    public final NotificationHubStatus status() {
        return NotificationHubStatus.fromValue(status);
    }

    /**
     * <p>
     * Status information about the <code>NotificationHub</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Incoming <code>NotificationEvents</code> are replicated to this <code>NotificationHub</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>REGISTERING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>NotificationConfiguration</code> is initializing. A <code>NotificationConfiguration</code> with this
     * status can't be deregistered.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>DEREGISTERING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>NotificationConfiguration</code> is being deleted. You can't register additional
     * <code>NotificationHubs</code> in the same Region as a <code>NotificationConfiguration</code> with this status.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationHubStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status information about the <code>NotificationHub</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Incoming <code>NotificationEvents</code> are replicated to this <code>NotificationHub</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGISTERING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>NotificationConfiguration</code> is initializing. A <code>NotificationConfiguration</code> with
     *         this status can't be deregistered.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEREGISTERING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>NotificationConfiguration</code> is being deleted. You can't register additional
     *         <code>NotificationHubs</code> in the same Region as a <code>NotificationConfiguration</code> with this
     *         status.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationHubStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An explanation for the current status.
     * </p>
     * 
     * @return An explanation for the current status.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationHubStatusSummary)) {
            return false;
        }
        NotificationHubStatusSummary other = (NotificationHubStatusSummary) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationHubStatusSummary").add("Status", statusAsString()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationHubStatusSummary, T> g) {
        return obj -> g.apply((NotificationHubStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationHubStatusSummary> {
        /**
         * <p>
         * Status information about the <code>NotificationHub</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Incoming <code>NotificationEvents</code> are replicated to this <code>NotificationHub</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>REGISTERING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>NotificationConfiguration</code> is initializing. A <code>NotificationConfiguration</code> with
         * this status can't be deregistered.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>DEREGISTERING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>NotificationConfiguration</code> is being deleted. You can't register additional
         * <code>NotificationHubs</code> in the same Region as a <code>NotificationConfiguration</code> with this
         * status.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param status
         *        Status information about the <code>NotificationHub</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Incoming <code>NotificationEvents</code> are replicated to this <code>NotificationHub</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTERING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>NotificationConfiguration</code> is initializing. A <code>NotificationConfiguration</code>
         *        with this status can't be deregistered.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEREGISTERING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>NotificationConfiguration</code> is being deleted. You can't register additional
         *        <code>NotificationHubs</code> in the same Region as a <code>NotificationConfiguration</code> with this
         *        status.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationHubStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationHubStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status information about the <code>NotificationHub</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Incoming <code>NotificationEvents</code> are replicated to this <code>NotificationHub</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>REGISTERING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>NotificationConfiguration</code> is initializing. A <code>NotificationConfiguration</code> with
         * this status can't be deregistered.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>DEREGISTERING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>NotificationConfiguration</code> is being deleted. You can't register additional
         * <code>NotificationHubs</code> in the same Region as a <code>NotificationConfiguration</code> with this
         * status.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param status
         *        Status information about the <code>NotificationHub</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Incoming <code>NotificationEvents</code> are replicated to this <code>NotificationHub</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTERING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>NotificationConfiguration</code> is initializing. A <code>NotificationConfiguration</code>
         *        with this status can't be deregistered.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEREGISTERING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>NotificationConfiguration</code> is being deleted. You can't register additional
         *        <code>NotificationHubs</code> in the same Region as a <code>NotificationConfiguration</code> with this
         *        status.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationHubStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationHubStatus
         */
        Builder status(NotificationHubStatus status);

        /**
         * <p>
         * An explanation for the current status.
         * </p>
         * 
         * @param reason
         *        An explanation for the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationHubStatusSummary model) {
            status(model.status);
            reason(model.reason);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationHubStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public NotificationHubStatusSummary build() {
            return new NotificationHubStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
