/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Orgs Service trust for User Notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationsAccessForOrganization implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationsAccessForOrganization.Builder, NotificationsAccessForOrganization> {
    private static final SdkField<String> ACCESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessStatus").getter(getter(NotificationsAccessForOrganization::accessStatusAsString))
            .setter(setter(Builder::accessStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessStatus;

    private NotificationsAccessForOrganization(BuilderImpl builder) {
        this.accessStatus = builder.accessStatus;
    }

    /**
     * <p>
     * Access Status for the Orgs Service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessStatus} will
     * return {@link AccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessStatusAsString}.
     * </p>
     * 
     * @return Access Status for the Orgs Service.
     * @see AccessStatus
     */
    public final AccessStatus accessStatus() {
        return AccessStatus.fromValue(accessStatus);
    }

    /**
     * <p>
     * Access Status for the Orgs Service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessStatus} will
     * return {@link AccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessStatusAsString}.
     * </p>
     * 
     * @return Access Status for the Orgs Service.
     * @see AccessStatus
     */
    public final String accessStatusAsString() {
        return accessStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationsAccessForOrganization)) {
            return false;
        }
        NotificationsAccessForOrganization other = (NotificationsAccessForOrganization) obj;
        return Objects.equals(accessStatusAsString(), other.accessStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationsAccessForOrganization").add("AccessStatus", accessStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessStatus":
            return Optional.ofNullable(clazz.cast(accessStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessStatus", ACCESS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationsAccessForOrganization, T> g) {
        return obj -> g.apply((NotificationsAccessForOrganization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationsAccessForOrganization> {
        /**
         * <p>
         * Access Status for the Orgs Service.
         * </p>
         * 
         * @param accessStatus
         *        Access Status for the Orgs Service.
         * @see AccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessStatus
         */
        Builder accessStatus(String accessStatus);

        /**
         * <p>
         * Access Status for the Orgs Service.
         * </p>
         * 
         * @param accessStatus
         *        Access Status for the Orgs Service.
         * @see AccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessStatus
         */
        Builder accessStatus(AccessStatus accessStatus);
    }

    static final class BuilderImpl implements Builder {
        private String accessStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationsAccessForOrganization model) {
            accessStatus(model.accessStatus);
        }

        public final String getAccessStatus() {
            return accessStatus;
        }

        public final void setAccessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
        }

        @Override
        public final Builder accessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
            return this;
        }

        @Override
        public final Builder accessStatus(AccessStatus accessStatus) {
            this.accessStatus(accessStatus == null ? null : accessStatus.toString());
            return this;
        }

        @Override
        public NotificationsAccessForOrganization build() {
            return new NotificationsAccessForOrganization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
