/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides an overview of how data is summarized across different dimensions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SummarizationDimensionOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<SummarizationDimensionOverview.Builder, SummarizationDimensionOverview> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SummarizationDimensionOverview::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(SummarizationDimensionOverview::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<List<String>> SAMPLE_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sampleValues")
            .getter(getter(SummarizationDimensionOverview::sampleValues))
            .setter(setter(Builder::sampleValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COUNT_FIELD,
            SAMPLE_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer count;

    private final List<String> sampleValues;

    private SummarizationDimensionOverview(BuilderImpl builder) {
        this.name = builder.name;
        this.count = builder.count;
        this.sampleValues = builder.sampleValues;
    }

    /**
     * <p>
     * Name of the summarization dimension.
     * </p>
     * 
     * @return Name of the summarization dimension.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Total number of occurrences for this dimension.
     * </p>
     * 
     * @return Total number of occurrences for this dimension.
     */
    public final Integer count() {
        return count;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampleValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSampleValues() {
        return sampleValues != null && !(sampleValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the sample values found within the dimension.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampleValues} method.
     * </p>
     * 
     * @return Indicates the sample values found within the dimension.
     */
    public final List<String> sampleValues() {
        return sampleValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleValues() ? sampleValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizationDimensionOverview)) {
            return false;
        }
        SummarizationDimensionOverview other = (SummarizationDimensionOverview) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(count(), other.count())
                && hasSampleValues() == other.hasSampleValues() && Objects.equals(sampleValues(), other.sampleValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SummarizationDimensionOverview").add("Name", name()).add("Count", count())
                .add("SampleValues", hasSampleValues() ? sampleValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "sampleValues":
            return Optional.ofNullable(clazz.cast(sampleValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("sampleValues", SAMPLE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SummarizationDimensionOverview, T> g) {
        return obj -> g.apply((SummarizationDimensionOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SummarizationDimensionOverview> {
        /**
         * <p>
         * Name of the summarization dimension.
         * </p>
         * 
         * @param name
         *        Name of the summarization dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Total number of occurrences for this dimension.
         * </p>
         * 
         * @param count
         *        Total number of occurrences for this dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * Indicates the sample values found within the dimension.
         * </p>
         * 
         * @param sampleValues
         *        Indicates the sample values found within the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleValues(Collection<String> sampleValues);

        /**
         * <p>
         * Indicates the sample values found within the dimension.
         * </p>
         * 
         * @param sampleValues
         *        Indicates the sample values found within the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleValues(String... sampleValues);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer count;

        private List<String> sampleValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SummarizationDimensionOverview model) {
            name(model.name);
            count(model.count);
            sampleValues(model.sampleValues);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getSampleValues() {
            if (sampleValues instanceof SdkAutoConstructList) {
                return null;
            }
            return sampleValues;
        }

        public final void setSampleValues(Collection<String> sampleValues) {
            this.sampleValues = SampleAggregationDimensionValuesCopier.copy(sampleValues);
        }

        @Override
        public final Builder sampleValues(Collection<String> sampleValues) {
            this.sampleValues = SampleAggregationDimensionValuesCopier.copy(sampleValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleValues(String... sampleValues) {
            sampleValues(Arrays.asList(sampleValues));
            return this;
        }

        @Override
        public SummarizationDimensionOverview build() {
            return new SummarizationDimensionOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
