/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNotificationConfigurationRequest extends NotificationsRequest implements
        ToCopyableBuilder<UpdateNotificationConfigurationRequest.Builder, UpdateNotificationConfigurationRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateNotificationConfigurationRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateNotificationConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateNotificationConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> AGGREGATION_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationDuration")
            .getter(getter(UpdateNotificationConfigurationRequest::aggregationDurationAsString))
            .setter(setter(Builder::aggregationDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, AGGREGATION_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String description;

    private final String aggregationDuration;

    private UpdateNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.aggregationDuration = builder.aggregationDuration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used to update the <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) used to update the <code>NotificationConfiguration</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The name of the <code>NotificationConfiguration</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The description of the <code>NotificationConfiguration</code>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The aggregation preference of the <code>NotificationConfiguration</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LONG</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aggregate notifications for long periods of time (12 hours).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>SHORT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aggregate notifications for short periods of time (5 minutes).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Don't aggregate notifications.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationDuration} will return {@link AggregationDuration#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationDurationAsString}.
     * </p>
     * 
     * @return The aggregation preference of the <code>NotificationConfiguration</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LONG</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aggregate notifications for long periods of time (12 hours).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHORT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aggregate notifications for short periods of time (5 minutes).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Don't aggregate notifications.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see AggregationDuration
     */
    public final AggregationDuration aggregationDuration() {
        return AggregationDuration.fromValue(aggregationDuration);
    }

    /**
     * <p>
     * The aggregation preference of the <code>NotificationConfiguration</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LONG</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aggregate notifications for long periods of time (12 hours).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>SHORT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aggregate notifications for short periods of time (5 minutes).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Don't aggregate notifications.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationDuration} will return {@link AggregationDuration#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationDurationAsString}.
     * </p>
     * 
     * @return The aggregation preference of the <code>NotificationConfiguration</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LONG</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aggregate notifications for long periods of time (12 hours).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHORT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aggregate notifications for short periods of time (5 minutes).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Don't aggregate notifications.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see AggregationDuration
     */
    public final String aggregationDurationAsString() {
        return aggregationDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationDurationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationConfigurationRequest)) {
            return false;
        }
        UpdateNotificationConfigurationRequest other = (UpdateNotificationConfigurationRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(aggregationDurationAsString(), other.aggregationDurationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNotificationConfigurationRequest").add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("AggregationDuration", aggregationDurationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "aggregationDuration":
            return Optional.ofNullable(clazz.cast(aggregationDurationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("aggregationDuration", AGGREGATION_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotificationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateNotificationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NotificationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateNotificationConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) used to update the <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) used to update the <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param description
         *        The description of the <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The aggregation preference of the <code>NotificationConfiguration</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LONG</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aggregate notifications for long periods of time (12 hours).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>SHORT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aggregate notifications for short periods of time (5 minutes).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Don't aggregate notifications.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param aggregationDuration
         *        The aggregation preference of the <code>NotificationConfiguration</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LONG</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aggregate notifications for long periods of time (12 hours).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHORT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aggregate notifications for short periods of time (5 minutes).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Don't aggregate notifications.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see AggregationDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationDuration
         */
        Builder aggregationDuration(String aggregationDuration);

        /**
         * <p>
         * The aggregation preference of the <code>NotificationConfiguration</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LONG</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aggregate notifications for long periods of time (12 hours).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>SHORT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aggregate notifications for short periods of time (5 minutes).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Don't aggregate notifications.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param aggregationDuration
         *        The aggregation preference of the <code>NotificationConfiguration</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LONG</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aggregate notifications for long periods of time (12 hours).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHORT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aggregate notifications for short periods of time (5 minutes).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Don't aggregate notifications.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see AggregationDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationDuration
         */
        Builder aggregationDuration(AggregationDuration aggregationDuration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NotificationsRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String aggregationDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationConfigurationRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            aggregationDuration(model.aggregationDuration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAggregationDuration() {
            return aggregationDuration;
        }

        public final void setAggregationDuration(String aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
        }

        @Override
        public final Builder aggregationDuration(String aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
            return this;
        }

        @Override
        public final Builder aggregationDuration(AggregationDuration aggregationDuration) {
            this.aggregationDuration(aggregationDuration == null ? null : aggregationDuration.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationConfigurationRequest build() {
            return new UpdateNotificationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
