/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.notifications.model.AssociateChannelRequest;
import software.amazon.awssdk.services.notifications.model.AssociateChannelResponse;
import software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAccountContactRequest;
import software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAccountContactResponse;
import software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAdditionalChannelRequest;
import software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAdditionalChannelResponse;
import software.amazon.awssdk.services.notifications.model.AssociateOrganizationalUnitRequest;
import software.amazon.awssdk.services.notifications.model.AssociateOrganizationalUnitResponse;
import software.amazon.awssdk.services.notifications.model.CreateEventRuleRequest;
import software.amazon.awssdk.services.notifications.model.CreateEventRuleResponse;
import software.amazon.awssdk.services.notifications.model.CreateNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.CreateNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.DeleteEventRuleRequest;
import software.amazon.awssdk.services.notifications.model.DeleteEventRuleResponse;
import software.amazon.awssdk.services.notifications.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.DeregisterNotificationHubRequest;
import software.amazon.awssdk.services.notifications.model.DeregisterNotificationHubResponse;
import software.amazon.awssdk.services.notifications.model.DisableNotificationsAccessForOrganizationRequest;
import software.amazon.awssdk.services.notifications.model.DisableNotificationsAccessForOrganizationResponse;
import software.amazon.awssdk.services.notifications.model.DisassociateChannelRequest;
import software.amazon.awssdk.services.notifications.model.DisassociateChannelResponse;
import software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAccountContactRequest;
import software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAccountContactResponse;
import software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAdditionalChannelRequest;
import software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAdditionalChannelResponse;
import software.amazon.awssdk.services.notifications.model.DisassociateOrganizationalUnitRequest;
import software.amazon.awssdk.services.notifications.model.DisassociateOrganizationalUnitResponse;
import software.amazon.awssdk.services.notifications.model.EnableNotificationsAccessForOrganizationRequest;
import software.amazon.awssdk.services.notifications.model.EnableNotificationsAccessForOrganizationResponse;
import software.amazon.awssdk.services.notifications.model.GetEventRuleRequest;
import software.amazon.awssdk.services.notifications.model.GetEventRuleResponse;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationChildEventRequest;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationChildEventResponse;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationEventRequest;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationEventResponse;
import software.amazon.awssdk.services.notifications.model.GetNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.GetNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.GetNotificationEventRequest;
import software.amazon.awssdk.services.notifications.model.GetNotificationEventResponse;
import software.amazon.awssdk.services.notifications.model.GetNotificationsAccessForOrganizationRequest;
import software.amazon.awssdk.services.notifications.model.GetNotificationsAccessForOrganizationResponse;
import software.amazon.awssdk.services.notifications.model.ListChannelsRequest;
import software.amazon.awssdk.services.notifications.model.ListChannelsResponse;
import software.amazon.awssdk.services.notifications.model.ListEventRulesRequest;
import software.amazon.awssdk.services.notifications.model.ListEventRulesResponse;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse;
import software.amazon.awssdk.services.notifications.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.notifications.model.ListMemberAccountsResponse;
import software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse;
import software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse;
import software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse;
import software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest;
import software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsResponse;
import software.amazon.awssdk.services.notifications.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.notifications.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.notifications.model.RegisterNotificationHubRequest;
import software.amazon.awssdk.services.notifications.model.RegisterNotificationHubResponse;
import software.amazon.awssdk.services.notifications.model.TagResourceRequest;
import software.amazon.awssdk.services.notifications.model.TagResourceResponse;
import software.amazon.awssdk.services.notifications.model.UntagResourceRequest;
import software.amazon.awssdk.services.notifications.model.UntagResourceResponse;
import software.amazon.awssdk.services.notifications.model.UpdateEventRuleRequest;
import software.amazon.awssdk.services.notifications.model.UpdateEventRuleResponse;
import software.amazon.awssdk.services.notifications.model.UpdateNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.UpdateNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListEventRulesPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListMemberAccountsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsPublisher;
import software.amazon.awssdk.services.notifications.paginators.ListOrganizationalUnitsPublisher;

/**
 * Service client for accessing AWS User Notifications asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * The <i>User Notifications API Reference</i> provides descriptions, API request parameters, and the JSON response for
 * each of the User Notifications API actions.
 * </p>
 * <p>
 * User Notification control plane APIs are currently available in US East (Virginia) - <code>us-east-1</code>.
 * </p>
 * <p>
 * <a href="https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetNotificationEvent.html">
 * GetNotificationEvent</a> and <a
 * href="https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListNotificationEvents.html"
 * >ListNotificationEvents</a> APIs are currently available in <a
 * href="https://docs.aws.amazon.com/notifications/latest/userguide/supported-regions.html">commercial partition
 * Regions</a> and only return notifications stored in the same Region in which they're called.
 * </p>
 * <p>
 * The User Notifications console can only be used in US East (Virginia). Your data however, is stored in each Region
 * chosen as a <a href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">notification
 * hub</a> in addition to US East (Virginia).
 * </p>
 * <note>
 * <p>
 * For information about descriptions, API request parameters, and the JSON response for email contact related API
 * actions, see the <a href="https://docs.aws.amazon.com/notificationscontacts/latest/APIReference/Welcome.html">User
 * Notifications Contacts API Reference Guide</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NotificationsAsyncClient extends AwsClient {
    String SERVICE_NAME = "notifications";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "notifications";

    /**
     * <p>
     * Associates a delivery <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/managing-delivery-channels.html">Channel</a>
     * with a particular <code>NotificationConfiguration</code>. Supported Channels include Amazon Q Developer in chat
     * applications, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     *
     * @param associateChannelRequest
     * @return A Java Future containing the result of the AssociateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.AssociateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateChannelResponse> associateChannel(AssociateChannelRequest associateChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a delivery <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/managing-delivery-channels.html">Channel</a>
     * with a particular <code>NotificationConfiguration</code>. Supported Channels include Amazon Q Developer in chat
     * applications, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateChannelRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateChannelRequest#builder()}
     * </p>
     *
     * @param associateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.AssociateChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.AssociateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateChannelResponse> associateChannel(
            Consumer<AssociateChannelRequest.Builder> associateChannelRequest) {
        return associateChannel(AssociateChannelRequest.builder().applyMutation(associateChannelRequest).build());
    }

    /**
     * <p>
     * Associates an Account Contact with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     *
     * @param associateManagedNotificationAccountContactRequest
     * @return A Java Future containing the result of the AssociateManagedNotificationAccountContact operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.AssociateManagedNotificationAccountContact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateManagedNotificationAccountContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateManagedNotificationAccountContactResponse> associateManagedNotificationAccountContact(
            AssociateManagedNotificationAccountContactRequest associateManagedNotificationAccountContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Account Contact with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateManagedNotificationAccountContactRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateManagedNotificationAccountContactRequest#builder()}
     * </p>
     *
     * @param associateManagedNotificationAccountContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAccountContactRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateManagedNotificationAccountContact operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.AssociateManagedNotificationAccountContact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateManagedNotificationAccountContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateManagedNotificationAccountContactResponse> associateManagedNotificationAccountContact(
            Consumer<AssociateManagedNotificationAccountContactRequest.Builder> associateManagedNotificationAccountContactRequest) {
        return associateManagedNotificationAccountContact(AssociateManagedNotificationAccountContactRequest.builder()
                .applyMutation(associateManagedNotificationAccountContactRequest).build());
    }

    /**
     * <p>
     * Associates an additional Channel with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported Channels include Amazon Q Developer in chat applications, the Console Mobile Application, and emails
     * (notifications-contacts).
     * </p>
     *
     * @param associateManagedNotificationAdditionalChannelRequest
     * @return A Java Future containing the result of the AssociateManagedNotificationAdditionalChannel operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.AssociateManagedNotificationAdditionalChannel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateManagedNotificationAdditionalChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateManagedNotificationAdditionalChannelResponse> associateManagedNotificationAdditionalChannel(
            AssociateManagedNotificationAdditionalChannelRequest associateManagedNotificationAdditionalChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an additional Channel with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported Channels include Amazon Q Developer in chat applications, the Console Mobile Application, and emails
     * (notifications-contacts).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateManagedNotificationAdditionalChannelRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateManagedNotificationAdditionalChannelRequest#builder()}
     * </p>
     *
     * @param associateManagedNotificationAdditionalChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAdditionalChannelRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateManagedNotificationAdditionalChannel operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.AssociateManagedNotificationAdditionalChannel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateManagedNotificationAdditionalChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateManagedNotificationAdditionalChannelResponse> associateManagedNotificationAdditionalChannel(
            Consumer<AssociateManagedNotificationAdditionalChannelRequest.Builder> associateManagedNotificationAdditionalChannelRequest) {
        return associateManagedNotificationAdditionalChannel(AssociateManagedNotificationAdditionalChannelRequest.builder()
                .applyMutation(associateManagedNotificationAdditionalChannelRequest).build());
    }

    /**
     * <p>
     * Associates an organizational unit with a notification configuration.
     * </p>
     *
     * @param associateOrganizationalUnitRequest
     * @return A Java Future containing the result of the AssociateOrganizationalUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.AssociateOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateOrganizationalUnitResponse> associateOrganizationalUnit(
            AssociateOrganizationalUnitRequest associateOrganizationalUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an organizational unit with a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateOrganizationalUnitRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateOrganizationalUnitRequest#builder()}
     * </p>
     *
     * @param associateOrganizationalUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.AssociateOrganizationalUnitRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateOrganizationalUnit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.AssociateOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateOrganizationalUnitResponse> associateOrganizationalUnit(
            Consumer<AssociateOrganizationalUnitRequest.Builder> associateOrganizationalUnitRequest) {
        return associateOrganizationalUnit(AssociateOrganizationalUnitRequest.builder()
                .applyMutation(associateOrganizationalUnitRequest).build());
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/notifications/latest/userguide/glossary.html">
     * <code>EventRule</code> </a> that is associated with a specified <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param createEventRuleRequest
     * @return A Java Future containing the result of the CreateEventRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.CreateEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/CreateEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventRuleResponse> createEventRule(CreateEventRuleRequest createEventRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/notifications/latest/userguide/glossary.html">
     * <code>EventRule</code> </a> that is associated with a specified <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEventRuleRequest#builder()}
     * </p>
     *
     * @param createEventRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.CreateEventRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.CreateEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/CreateEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventRuleResponse> createEventRule(
            Consumer<CreateEventRuleRequest.Builder> createEventRuleRequest) {
        return createEventRule(CreateEventRuleRequest.builder().applyMutation(createEventRuleRequest).build());
    }

    /**
     * <p>
     * Creates a new <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param createNotificationConfigurationRequest
     * @return A Java Future containing the result of the CreateNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.CreateNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotificationConfigurationResponse> createNotificationConfiguration(
            CreateNotificationConfigurationRequest createNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param createNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.CreateNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.CreateNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotificationConfigurationResponse> createNotificationConfiguration(
            Consumer<CreateNotificationConfigurationRequest.Builder> createNotificationConfigurationRequest) {
        return createNotificationConfiguration(CreateNotificationConfigurationRequest.builder()
                .applyMutation(createNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an <code>EventRule</code>.
     * </p>
     *
     * @param deleteEventRuleRequest
     * @return A Java Future containing the result of the DeleteEventRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DeleteEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeleteEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventRuleResponse> deleteEventRule(DeleteEventRuleRequest deleteEventRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <code>EventRule</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEventRuleRequest#builder()}
     * </p>
     *
     * @param deleteEventRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DeleteEventRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DeleteEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeleteEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventRuleResponse> deleteEventRule(
            Consumer<DeleteEventRuleRequest.Builder> deleteEventRuleRequest) {
        return deleteEventRule(DeleteEventRuleRequest.builder().applyMutation(deleteEventRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     * @return A Java Future containing the result of the DeleteNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DeleteNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationConfigurationResponse> deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DeleteNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DeleteNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotificationConfigurationResponse> deleteNotificationConfiguration(
            Consumer<DeleteNotificationConfigurationRequest.Builder> deleteNotificationConfigurationRequest) {
        return deleteNotificationConfiguration(DeleteNotificationConfigurationRequest.builder()
                .applyMutation(deleteNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deregisters a <code>NotificationConfiguration</code> in the specified Region.
     * </p>
     * <note>
     * <p>
     * You can't deregister the last <code>NotificationHub</code> in the account. <code>NotificationEvents</code> stored
     * in the deregistered <code>NotificationConfiguration</code> are no longer be visible. Recreating a new
     * <code>NotificationConfiguration</code> in the same Region restores access to those
     * <code>NotificationEvents</code>.
     * </p>
     * </note>
     *
     * @param deregisterNotificationHubRequest
     * @return A Java Future containing the result of the DeregisterNotificationHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DeregisterNotificationHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeregisterNotificationHub"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterNotificationHubResponse> deregisterNotificationHub(
            DeregisterNotificationHubRequest deregisterNotificationHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a <code>NotificationConfiguration</code> in the specified Region.
     * </p>
     * <note>
     * <p>
     * You can't deregister the last <code>NotificationHub</code> in the account. <code>NotificationEvents</code> stored
     * in the deregistered <code>NotificationConfiguration</code> are no longer be visible. Recreating a new
     * <code>NotificationConfiguration</code> in the same Region restores access to those
     * <code>NotificationEvents</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterNotificationHubRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterNotificationHubRequest#builder()}
     * </p>
     *
     * @param deregisterNotificationHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DeregisterNotificationHubRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeregisterNotificationHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DeregisterNotificationHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeregisterNotificationHub"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterNotificationHubResponse> deregisterNotificationHub(
            Consumer<DeregisterNotificationHubRequest.Builder> deregisterNotificationHubRequest) {
        return deregisterNotificationHub(DeregisterNotificationHubRequest.builder()
                .applyMutation(deregisterNotificationHubRequest).build());
    }

    /**
     * <p>
     * Disables service trust between User Notifications and Amazon Web Services Organizations.
     * </p>
     *
     * @param disableNotificationsAccessForOrganizationRequest
     * @return A Java Future containing the result of the DisableNotificationsAccessForOrganization operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisableNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisableNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableNotificationsAccessForOrganizationResponse> disableNotificationsAccessForOrganization(
            DisableNotificationsAccessForOrganizationRequest disableNotificationsAccessForOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables service trust between User Notifications and Amazon Web Services Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisableNotificationsAccessForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DisableNotificationsAccessForOrganizationRequest#builder()}
     * </p>
     *
     * @param disableNotificationsAccessForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisableNotificationsAccessForOrganizationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisableNotificationsAccessForOrganization operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisableNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisableNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableNotificationsAccessForOrganizationResponse> disableNotificationsAccessForOrganization(
            Consumer<DisableNotificationsAccessForOrganizationRequest.Builder> disableNotificationsAccessForOrganizationRequest) {
        return disableNotificationsAccessForOrganization(DisableNotificationsAccessForOrganizationRequest.builder()
                .applyMutation(disableNotificationsAccessForOrganizationRequest).build());
    }

    /**
     * <p>
     * Disassociates a Channel from a specified <code>NotificationConfiguration</code>. Supported Channels include
     * Amazon Q Developer in chat applications, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     *
     * @param disassociateChannelRequest
     * @return A Java Future containing the result of the DisassociateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisassociateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateChannelResponse> disassociateChannel(
            DisassociateChannelRequest disassociateChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Channel from a specified <code>NotificationConfiguration</code>. Supported Channels include
     * Amazon Q Developer in chat applications, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateChannelRequest#builder()}
     * </p>
     *
     * @param disassociateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisassociateChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisassociateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateChannelResponse> disassociateChannel(
            Consumer<DisassociateChannelRequest.Builder> disassociateChannelRequest) {
        return disassociateChannel(DisassociateChannelRequest.builder().applyMutation(disassociateChannelRequest).build());
    }

    /**
     * <p>
     * Disassociates an Account Contact with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     *
     * @param disassociateManagedNotificationAccountContactRequest
     * @return A Java Future containing the result of the DisassociateManagedNotificationAccountContact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisassociateManagedNotificationAccountContact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateManagedNotificationAccountContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateManagedNotificationAccountContactResponse> disassociateManagedNotificationAccountContact(
            DisassociateManagedNotificationAccountContactRequest disassociateManagedNotificationAccountContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an Account Contact with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateManagedNotificationAccountContactRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateManagedNotificationAccountContactRequest#builder()}
     * </p>
     *
     * @param disassociateManagedNotificationAccountContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAccountContactRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateManagedNotificationAccountContact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisassociateManagedNotificationAccountContact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateManagedNotificationAccountContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateManagedNotificationAccountContactResponse> disassociateManagedNotificationAccountContact(
            Consumer<DisassociateManagedNotificationAccountContactRequest.Builder> disassociateManagedNotificationAccountContactRequest) {
        return disassociateManagedNotificationAccountContact(DisassociateManagedNotificationAccountContactRequest.builder()
                .applyMutation(disassociateManagedNotificationAccountContactRequest).build());
    }

    /**
     * <p>
     * Disassociates an additional Channel from a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported Channels include Amazon Q Developer in chat applications, the Console Mobile Application, and emails
     * (notifications-contacts).
     * </p>
     *
     * @param disassociateManagedNotificationAdditionalChannelRequest
     * @return A Java Future containing the result of the DisassociateManagedNotificationAdditionalChannel operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisassociateManagedNotificationAdditionalChannel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateManagedNotificationAdditionalChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateManagedNotificationAdditionalChannelResponse> disassociateManagedNotificationAdditionalChannel(
            DisassociateManagedNotificationAdditionalChannelRequest disassociateManagedNotificationAdditionalChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an additional Channel from a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported Channels include Amazon Q Developer in chat applications, the Console Mobile Application, and emails
     * (notifications-contacts).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateManagedNotificationAdditionalChannelRequest.Builder} avoiding the need to create one manually
     * via {@link DisassociateManagedNotificationAdditionalChannelRequest#builder()}
     * </p>
     *
     * @param disassociateManagedNotificationAdditionalChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAdditionalChannelRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateManagedNotificationAdditionalChannel operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisassociateManagedNotificationAdditionalChannel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateManagedNotificationAdditionalChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateManagedNotificationAdditionalChannelResponse> disassociateManagedNotificationAdditionalChannel(
            Consumer<DisassociateManagedNotificationAdditionalChannelRequest.Builder> disassociateManagedNotificationAdditionalChannelRequest) {
        return disassociateManagedNotificationAdditionalChannel(DisassociateManagedNotificationAdditionalChannelRequest.builder()
                .applyMutation(disassociateManagedNotificationAdditionalChannelRequest).build());
    }

    /**
     * <p>
     * Removes the association between an organizational unit and a notification configuration.
     * </p>
     *
     * @param disassociateOrganizationalUnitRequest
     * @return A Java Future containing the result of the DisassociateOrganizationalUnit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisassociateOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateOrganizationalUnitResponse> disassociateOrganizationalUnit(
            DisassociateOrganizationalUnitRequest disassociateOrganizationalUnitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between an organizational unit and a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateOrganizationalUnitRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateOrganizationalUnitRequest#builder()}
     * </p>
     *
     * @param disassociateOrganizationalUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisassociateOrganizationalUnitRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateOrganizationalUnit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.DisassociateOrganizationalUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateOrganizationalUnit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateOrganizationalUnitResponse> disassociateOrganizationalUnit(
            Consumer<DisassociateOrganizationalUnitRequest.Builder> disassociateOrganizationalUnitRequest) {
        return disassociateOrganizationalUnit(DisassociateOrganizationalUnitRequest.builder()
                .applyMutation(disassociateOrganizationalUnitRequest).build());
    }

    /**
     * <p>
     * Enables service trust between User Notifications and Amazon Web Services Organizations.
     * </p>
     *
     * @param enableNotificationsAccessForOrganizationRequest
     * @return A Java Future containing the result of the EnableNotificationsAccessForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.EnableNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/EnableNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableNotificationsAccessForOrganizationResponse> enableNotificationsAccessForOrganization(
            EnableNotificationsAccessForOrganizationRequest enableNotificationsAccessForOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables service trust between User Notifications and Amazon Web Services Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link EnableNotificationsAccessForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link EnableNotificationsAccessForOrganizationRequest#builder()}
     * </p>
     *
     * @param enableNotificationsAccessForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.EnableNotificationsAccessForOrganizationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the EnableNotificationsAccessForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.EnableNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/EnableNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableNotificationsAccessForOrganizationResponse> enableNotificationsAccessForOrganization(
            Consumer<EnableNotificationsAccessForOrganizationRequest.Builder> enableNotificationsAccessForOrganizationRequest) {
        return enableNotificationsAccessForOrganization(EnableNotificationsAccessForOrganizationRequest.builder()
                .applyMutation(enableNotificationsAccessForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>EventRule</code>.
     * </p>
     *
     * @param getEventRuleRequest
     * @return A Java Future containing the result of the GetEventRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventRuleResponse> getEventRule(GetEventRuleRequest getEventRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>EventRule</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventRuleRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventRuleRequest#builder()}
     * </p>
     *
     * @param getEventRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetEventRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventRuleResponse> getEventRule(Consumer<GetEventRuleRequest.Builder> getEventRuleRequest) {
        return getEventRule(GetEventRuleRequest.builder().applyMutation(getEventRuleRequest).build());
    }

    /**
     * <p>
     * Returns the child event of a specific given <code>ManagedNotificationEvent</code>.
     * </p>
     *
     * @param getManagedNotificationChildEventRequest
     * @return A Java Future containing the result of the GetManagedNotificationChildEvent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetManagedNotificationChildEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationChildEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedNotificationChildEventResponse> getManagedNotificationChildEvent(
            GetManagedNotificationChildEventRequest getManagedNotificationChildEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the child event of a specific given <code>ManagedNotificationEvent</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedNotificationChildEventRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedNotificationChildEventRequest#builder()}
     * </p>
     *
     * @param getManagedNotificationChildEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetManagedNotificationChildEventRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetManagedNotificationChildEvent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetManagedNotificationChildEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationChildEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedNotificationChildEventResponse> getManagedNotificationChildEvent(
            Consumer<GetManagedNotificationChildEventRequest.Builder> getManagedNotificationChildEventRequest) {
        return getManagedNotificationChildEvent(GetManagedNotificationChildEventRequest.builder()
                .applyMutation(getManagedNotificationChildEventRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>ManagedNotificationConfiguration</code>.
     * </p>
     *
     * @param getManagedNotificationConfigurationRequest
     * @return A Java Future containing the result of the GetManagedNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetManagedNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedNotificationConfigurationResponse> getManagedNotificationConfiguration(
            GetManagedNotificationConfigurationRequest getManagedNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param getManagedNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetManagedNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetManagedNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetManagedNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedNotificationConfigurationResponse> getManagedNotificationConfiguration(
            Consumer<GetManagedNotificationConfigurationRequest.Builder> getManagedNotificationConfigurationRequest) {
        return getManagedNotificationConfiguration(GetManagedNotificationConfigurationRequest.builder()
                .applyMutation(getManagedNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>ManagedNotificationEvent</code>.
     * </p>
     *
     * @param getManagedNotificationEventRequest
     * @return A Java Future containing the result of the GetManagedNotificationEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetManagedNotificationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedNotificationEventResponse> getManagedNotificationEvent(
            GetManagedNotificationEventRequest getManagedNotificationEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>ManagedNotificationEvent</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedNotificationEventRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedNotificationEventRequest#builder()}
     * </p>
     *
     * @param getManagedNotificationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetManagedNotificationEventRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetManagedNotificationEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetManagedNotificationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedNotificationEventResponse> getManagedNotificationEvent(
            Consumer<GetManagedNotificationEventRequest.Builder> getManagedNotificationEventRequest) {
        return getManagedNotificationEvent(GetManagedNotificationEventRequest.builder()
                .applyMutation(getManagedNotificationEventRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param getNotificationConfigurationRequest
     * @return A Java Future containing the result of the GetNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNotificationConfigurationResponse> getNotificationConfiguration(
            GetNotificationConfigurationRequest getNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param getNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetNotificationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNotificationConfigurationResponse> getNotificationConfiguration(
            Consumer<GetNotificationConfigurationRequest.Builder> getNotificationConfigurationRequest) {
        return getNotificationConfiguration(GetNotificationConfigurationRequest.builder()
                .applyMutation(getNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>NotificationEvent</code>.
     * </p>
     * <important>
     * <p>
     * User Notifications stores notifications in the individual Regions you register as notification hubs and the
     * Region of the source event rule. <code>GetNotificationEvent</code> only returns notifications stored in the same
     * Region in which the action is called. User Notifications doesn't backfill notifications to new Regions selected
     * as notification hubs. For this reason, we recommend that you make calls in your oldest registered notification
     * hub. For more information, see <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">Notification hubs</a> in
     * the <i>Amazon Web Services User Notifications User Guide</i>.
     * </p>
     * </important>
     *
     * @param getNotificationEventRequest
     * @return A Java Future containing the result of the GetNotificationEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetNotificationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNotificationEventResponse> getNotificationEvent(
            GetNotificationEventRequest getNotificationEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>NotificationEvent</code>.
     * </p>
     * <important>
     * <p>
     * User Notifications stores notifications in the individual Regions you register as notification hubs and the
     * Region of the source event rule. <code>GetNotificationEvent</code> only returns notifications stored in the same
     * Region in which the action is called. User Notifications doesn't backfill notifications to new Regions selected
     * as notification hubs. For this reason, we recommend that you make calls in your oldest registered notification
     * hub. For more information, see <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">Notification hubs</a> in
     * the <i>Amazon Web Services User Notifications User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationEventRequest.Builder} avoiding the
     * need to create one manually via {@link GetNotificationEventRequest#builder()}
     * </p>
     *
     * @param getNotificationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetNotificationEventRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetNotificationEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetNotificationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNotificationEventResponse> getNotificationEvent(
            Consumer<GetNotificationEventRequest.Builder> getNotificationEventRequest) {
        return getNotificationEvent(GetNotificationEventRequest.builder().applyMutation(getNotificationEventRequest).build());
    }

    /**
     * <p>
     * Returns the AccessStatus of Service Trust Enablement for User Notifications and Amazon Web Services
     * Organizations.
     * </p>
     *
     * @param getNotificationsAccessForOrganizationRequest
     * @return A Java Future containing the result of the GetNotificationsAccessForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNotificationsAccessForOrganizationResponse> getNotificationsAccessForOrganization(
            GetNotificationsAccessForOrganizationRequest getNotificationsAccessForOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the AccessStatus of Service Trust Enablement for User Notifications and Amazon Web Services
     * Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetNotificationsAccessForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link GetNotificationsAccessForOrganizationRequest#builder()}
     * </p>
     *
     * @param getNotificationsAccessForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetNotificationsAccessForOrganizationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetNotificationsAccessForOrganization operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.GetNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNotificationsAccessForOrganizationResponse> getNotificationsAccessForOrganization(
            Consumer<GetNotificationsAccessForOrganizationRequest.Builder> getNotificationsAccessForOrganizationRequest) {
        return getNotificationsAccessForOrganization(GetNotificationsAccessForOrganizationRequest.builder()
                .applyMutation(getNotificationsAccessForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns a list of Channels for a <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param listChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Channels for a <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.notifications.model.ListChannelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.notifications.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        return new ListChannelsPublisher(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.notifications.model.ListChannelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.notifications.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>EventRules</code> according to specified filters, in reverse chronological order (newest
     * first).
     * </p>
     *
     * @param listEventRulesRequest
     * @return A Java Future containing the result of the ListEventRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListEventRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListEventRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventRulesResponse> listEventRules(ListEventRulesRequest listEventRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>EventRules</code> according to specified filters, in reverse chronological order (newest
     * first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventRulesRequest#builder()}
     * </p>
     *
     * @param listEventRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListEventRulesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListEventRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListEventRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventRulesResponse> listEventRules(Consumer<ListEventRulesRequest.Builder> listEventRulesRequest) {
        return listEventRules(ListEventRulesRequest.builder().applyMutation(listEventRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventRules(software.amazon.awssdk.services.notifications.model.ListEventRulesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListEventRulesPublisher publisher = client.listEventRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListEventRulesPublisher publisher = client.listEventRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListEventRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListEventRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventRules(software.amazon.awssdk.services.notifications.model.ListEventRulesRequest)} operation.</b>
     * </p>
     *
     * @param listEventRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListEventRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListEventRules" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventRulesPublisher listEventRulesPaginator(ListEventRulesRequest listEventRulesRequest) {
        return new ListEventRulesPublisher(this, listEventRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventRules(software.amazon.awssdk.services.notifications.model.ListEventRulesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListEventRulesPublisher publisher = client.listEventRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListEventRulesPublisher publisher = client.listEventRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListEventRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListEventRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventRules(software.amazon.awssdk.services.notifications.model.ListEventRulesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventRulesRequest#builder()}
     * </p>
     *
     * @param listEventRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListEventRulesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListEventRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListEventRules" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventRulesPublisher listEventRulesPaginator(Consumer<ListEventRulesRequest.Builder> listEventRulesRequest) {
        return listEventRulesPaginator(ListEventRulesRequest.builder().applyMutation(listEventRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of Account contacts and Channels associated with a <code>ManagedNotificationConfiguration</code>,
     * in paginated format.
     * </p>
     *
     * @param listManagedNotificationChannelAssociationsRequest
     * @return A Java Future containing the result of the ListManagedNotificationChannelAssociations operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationChannelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedNotificationChannelAssociationsResponse> listManagedNotificationChannelAssociations(
            ListManagedNotificationChannelAssociationsRequest listManagedNotificationChannelAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Account contacts and Channels associated with a <code>ManagedNotificationConfiguration</code>,
     * in paginated format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListManagedNotificationChannelAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListManagedNotificationChannelAssociationsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationChannelAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListManagedNotificationChannelAssociations operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationChannelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedNotificationChannelAssociationsResponse> listManagedNotificationChannelAssociations(
            Consumer<ListManagedNotificationChannelAssociationsRequest.Builder> listManagedNotificationChannelAssociationsRequest) {
        return listManagedNotificationChannelAssociations(ListManagedNotificationChannelAssociationsRequest.builder()
                .applyMutation(listManagedNotificationChannelAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationChannelAssociations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsPublisher publisher = client.listManagedNotificationChannelAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsPublisher publisher = client.listManagedNotificationChannelAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationChannelAssociations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedNotificationChannelAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationChannelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChannelAssociationsPublisher listManagedNotificationChannelAssociationsPaginator(
            ListManagedNotificationChannelAssociationsRequest listManagedNotificationChannelAssociationsRequest) {
        return new ListManagedNotificationChannelAssociationsPublisher(this, listManagedNotificationChannelAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationChannelAssociations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsPublisher publisher = client.listManagedNotificationChannelAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsPublisher publisher = client.listManagedNotificationChannelAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationChannelAssociations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListManagedNotificationChannelAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListManagedNotificationChannelAssociationsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationChannelAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationChannelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChannelAssociationsPublisher listManagedNotificationChannelAssociationsPaginator(
            Consumer<ListManagedNotificationChannelAssociationsRequest.Builder> listManagedNotificationChannelAssociationsRequest) {
        return listManagedNotificationChannelAssociationsPaginator(ListManagedNotificationChannelAssociationsRequest.builder()
                .applyMutation(listManagedNotificationChannelAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>ManagedNotificationChildEvents</code> for a specified aggregate
     * <code>ManagedNotificationEvent</code>, ordered by creation time in reverse chronological order (newest first).
     * </p>
     *
     * @param listManagedNotificationChildEventsRequest
     * @return A Java Future containing the result of the ListManagedNotificationChildEvents operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationChildEvents
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChildEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedNotificationChildEventsResponse> listManagedNotificationChildEvents(
            ListManagedNotificationChildEventsRequest listManagedNotificationChildEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>ManagedNotificationChildEvents</code> for a specified aggregate
     * <code>ManagedNotificationEvent</code>, ordered by creation time in reverse chronological order (newest first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedNotificationChildEventsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedNotificationChildEventsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationChildEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListManagedNotificationChildEvents operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationChildEvents
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChildEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedNotificationChildEventsResponse> listManagedNotificationChildEvents(
            Consumer<ListManagedNotificationChildEventsRequest.Builder> listManagedNotificationChildEventsRequest) {
        return listManagedNotificationChildEvents(ListManagedNotificationChildEventsRequest.builder()
                .applyMutation(listManagedNotificationChildEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationChildEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsPublisher publisher = client.listManagedNotificationChildEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsPublisher publisher = client.listManagedNotificationChildEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationChildEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedNotificationChildEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationChildEvents
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChildEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChildEventsPublisher listManagedNotificationChildEventsPaginator(
            ListManagedNotificationChildEventsRequest listManagedNotificationChildEventsRequest) {
        return new ListManagedNotificationChildEventsPublisher(this, listManagedNotificationChildEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationChildEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsPublisher publisher = client.listManagedNotificationChildEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsPublisher publisher = client.listManagedNotificationChildEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationChildEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedNotificationChildEventsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedNotificationChildEventsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationChildEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationChildEvents
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChildEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChildEventsPublisher listManagedNotificationChildEventsPaginator(
            Consumer<ListManagedNotificationChildEventsRequest.Builder> listManagedNotificationChildEventsRequest) {
        return listManagedNotificationChildEventsPaginator(ListManagedNotificationChildEventsRequest.builder()
                .applyMutation(listManagedNotificationChildEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Managed Notification Configurations according to specified filters, ordered by creation time in
     * reverse chronological order (newest first).
     * </p>
     *
     * @param listManagedNotificationConfigurationsRequest
     * @return A Java Future containing the result of the ListManagedNotificationConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedNotificationConfigurationsResponse> listManagedNotificationConfigurations(
            ListManagedNotificationConfigurationsRequest listManagedNotificationConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Managed Notification Configurations according to specified filters, ordered by creation time in
     * reverse chronological order (newest first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListManagedNotificationConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListManagedNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListManagedNotificationConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedNotificationConfigurationsResponse> listManagedNotificationConfigurations(
            Consumer<ListManagedNotificationConfigurationsRequest.Builder> listManagedNotificationConfigurationsRequest) {
        return listManagedNotificationConfigurations(ListManagedNotificationConfigurationsRequest.builder()
                .applyMutation(listManagedNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsPublisher publisher = client.listManagedNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsPublisher publisher = client.listManagedNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedNotificationConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationConfigurationsPublisher listManagedNotificationConfigurationsPaginator(
            ListManagedNotificationConfigurationsRequest listManagedNotificationConfigurationsRequest) {
        return new ListManagedNotificationConfigurationsPublisher(this, listManagedNotificationConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsPublisher publisher = client.listManagedNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsPublisher publisher = client.listManagedNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListManagedNotificationConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListManagedNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationConfigurationsPublisher listManagedNotificationConfigurationsPaginator(
            Consumer<ListManagedNotificationConfigurationsRequest.Builder> listManagedNotificationConfigurationsRequest) {
        return listManagedNotificationConfigurationsPaginator(ListManagedNotificationConfigurationsRequest.builder()
                .applyMutation(listManagedNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Managed Notification Events according to specified filters, ordered by creation time in reverse
     * chronological order (newest first).
     * </p>
     *
     * @param listManagedNotificationEventsRequest
     * @return A Java Future containing the result of the ListManagedNotificationEvents operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedNotificationEventsResponse> listManagedNotificationEvents(
            ListManagedNotificationEventsRequest listManagedNotificationEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Managed Notification Events according to specified filters, ordered by creation time in reverse
     * chronological order (newest first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedNotificationEventsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedNotificationEventsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListManagedNotificationEvents operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedNotificationEventsResponse> listManagedNotificationEvents(
            Consumer<ListManagedNotificationEventsRequest.Builder> listManagedNotificationEventsRequest) {
        return listManagedNotificationEvents(ListManagedNotificationEventsRequest.builder()
                .applyMutation(listManagedNotificationEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsPublisher publisher = client.listManagedNotificationEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsPublisher publisher = client.listManagedNotificationEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedNotificationEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationEventsPublisher listManagedNotificationEventsPaginator(
            ListManagedNotificationEventsRequest listManagedNotificationEventsRequest) {
        return new ListManagedNotificationEventsPublisher(this, listManagedNotificationEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsPublisher publisher = client.listManagedNotificationEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsPublisher publisher = client.listManagedNotificationEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedNotificationEventsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedNotificationEventsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListManagedNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationEventsPublisher listManagedNotificationEventsPaginator(
            Consumer<ListManagedNotificationEventsRequest.Builder> listManagedNotificationEventsRequest) {
        return listManagedNotificationEventsPaginator(ListManagedNotificationEventsRequest.builder()
                .applyMutation(listManagedNotificationEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of member accounts associated with a notification configuration.
     * </p>
     *
     * @param listMemberAccountsRequest
     * @return A Java Future containing the result of the ListMemberAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListMemberAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListMemberAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMemberAccountsResponse> listMemberAccounts(ListMemberAccountsRequest listMemberAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of member accounts associated with a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemberAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMemberAccountsRequest#builder()}
     * </p>
     *
     * @param listMemberAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListMemberAccountsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMemberAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListMemberAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListMemberAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMemberAccountsResponse> listMemberAccounts(
            Consumer<ListMemberAccountsRequest.Builder> listMemberAccountsRequest) {
        return listMemberAccounts(ListMemberAccountsRequest.builder().applyMutation(listMemberAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemberAccounts(software.amazon.awssdk.services.notifications.model.ListMemberAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListMemberAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListMemberAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberAccounts(software.amazon.awssdk.services.notifications.model.ListMemberAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMemberAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListMemberAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListMemberAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemberAccountsPublisher listMemberAccountsPaginator(ListMemberAccountsRequest listMemberAccountsRequest) {
        return new ListMemberAccountsPublisher(this, listMemberAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemberAccounts(software.amazon.awssdk.services.notifications.model.ListMemberAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListMemberAccountsPublisher publisher = client.listMemberAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListMemberAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListMemberAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberAccounts(software.amazon.awssdk.services.notifications.model.ListMemberAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemberAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMemberAccountsRequest#builder()}
     * </p>
     *
     * @param listMemberAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListMemberAccountsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListMemberAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListMemberAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemberAccountsPublisher listMemberAccountsPaginator(
            Consumer<ListMemberAccountsRequest.Builder> listMemberAccountsRequest) {
        return listMemberAccountsPaginator(ListMemberAccountsRequest.builder().applyMutation(listMemberAccountsRequest).build());
    }

    /**
     * <p>
     * Returns a list of abbreviated <code>NotificationConfigurations</code> according to specified filters, in reverse
     * chronological order (newest first).
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return A Java Future containing the result of the ListNotificationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationConfigurationsResponse> listNotificationConfigurations(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of abbreviated <code>NotificationConfigurations</code> according to specified filters, in reverse
     * chronological order (newest first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListNotificationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationConfigurationsResponse> listNotificationConfigurations(
            Consumer<ListNotificationConfigurationsRequest.Builder> listNotificationConfigurationsRequest) {
        return listNotificationConfigurations(ListNotificationConfigurationsRequest.builder()
                .applyMutation(listNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsPublisher publisher = client.listNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsPublisher publisher = client.listNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsPublisher listNotificationConfigurationsPaginator(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) {
        return new ListNotificationConfigurationsPublisher(this, listNotificationConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsPublisher publisher = client.listNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsPublisher publisher = client.listNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsPublisher listNotificationConfigurationsPaginator(
            Consumer<ListNotificationConfigurationsRequest.Builder> listNotificationConfigurationsRequest) {
        return listNotificationConfigurationsPaginator(ListNotificationConfigurationsRequest.builder()
                .applyMutation(listNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>NotificationEvents</code> according to specified filters, in reverse chronological order
     * (newest first).
     * </p>
     * <important>
     * <p>
     * User Notifications stores notifications in the individual Regions you register as notification hubs and the
     * Region of the source event rule. ListNotificationEvents only returns notifications stored in the same Region in
     * which the action is called. User Notifications doesn't backfill notifications to new Regions selected as
     * notification hubs. For this reason, we recommend that you make calls in your oldest registered notification hub.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">Notification hubs</a> in
     * the <i>Amazon Web Services User Notifications User Guide</i>.
     * </p>
     * </important>
     *
     * @param listNotificationEventsRequest
     * @return A Java Future containing the result of the ListNotificationEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationEventsResponse> listNotificationEvents(
            ListNotificationEventsRequest listNotificationEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>NotificationEvents</code> according to specified filters, in reverse chronological order
     * (newest first).
     * </p>
     * <important>
     * <p>
     * User Notifications stores notifications in the individual Regions you register as notification hubs and the
     * Region of the source event rule. ListNotificationEvents only returns notifications stored in the same Region in
     * which the action is called. User Notifications doesn't backfill notifications to new Regions selected as
     * notification hubs. For this reason, we recommend that you make calls in your oldest registered notification hub.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">Notification hubs</a> in
     * the <i>Amazon Web Services User Notifications User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationEventsRequest#builder()}
     * </p>
     *
     * @param listNotificationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListNotificationEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationEventsResponse> listNotificationEvents(
            Consumer<ListNotificationEventsRequest.Builder> listNotificationEventsRequest) {
        return listNotificationEvents(ListNotificationEventsRequest.builder().applyMutation(listNotificationEventsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationEvents(software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsPublisher publisher = client.listNotificationEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsPublisher publisher = client.listNotificationEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationEvents(software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationEventsPublisher listNotificationEventsPaginator(
            ListNotificationEventsRequest listNotificationEventsRequest) {
        return new ListNotificationEventsPublisher(this, listNotificationEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationEvents(software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsPublisher publisher = client.listNotificationEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsPublisher publisher = client.listNotificationEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationEvents(software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationEventsRequest#builder()}
     * </p>
     *
     * @param listNotificationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationEventsPublisher listNotificationEventsPaginator(
            Consumer<ListNotificationEventsRequest.Builder> listNotificationEventsRequest) {
        return listNotificationEventsPaginator(ListNotificationEventsRequest.builder()
                .applyMutation(listNotificationEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>NotificationHubs</code>.
     * </p>
     *
     * @param listNotificationHubsRequest
     * @return A Java Future containing the result of the ListNotificationHubs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationHubs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationHubs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationHubsResponse> listNotificationHubs(
            ListNotificationHubsRequest listNotificationHubsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>NotificationHubs</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationHubsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationHubsRequest#builder()}
     * </p>
     *
     * @param listNotificationHubsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListNotificationHubs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationHubs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationHubs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationHubsResponse> listNotificationHubs(
            Consumer<ListNotificationHubsRequest.Builder> listNotificationHubsRequest) {
        return listNotificationHubs(ListNotificationHubsRequest.builder().applyMutation(listNotificationHubsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationHubs(software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsPublisher publisher = client.listNotificationHubsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsPublisher publisher = client.listNotificationHubsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationHubs(software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationHubsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationHubs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationHubs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationHubsPublisher listNotificationHubsPaginator(ListNotificationHubsRequest listNotificationHubsRequest) {
        return new ListNotificationHubsPublisher(this, listNotificationHubsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationHubs(software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsPublisher publisher = client.listNotificationHubsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsPublisher publisher = client.listNotificationHubsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationHubs(software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationHubsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationHubsRequest#builder()}
     * </p>
     *
     * @param listNotificationHubsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListNotificationHubs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationHubs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationHubsPublisher listNotificationHubsPaginator(
            Consumer<ListNotificationHubsRequest.Builder> listNotificationHubsRequest) {
        return listNotificationHubsPaginator(ListNotificationHubsRequest.builder().applyMutation(listNotificationHubsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of organizational units associated with a notification configuration.
     * </p>
     *
     * @param listOrganizationalUnitsRequest
     * @return A Java Future containing the result of the ListOrganizationalUnits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListOrganizationalUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListOrganizationalUnits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationalUnitsResponse> listOrganizationalUnits(
            ListOrganizationalUnitsRequest listOrganizationalUnitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of organizational units associated with a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationalUnitsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOrganizationalUnitsRequest#builder()}
     * </p>
     *
     * @param listOrganizationalUnitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListOrganizationalUnits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListOrganizationalUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListOrganizationalUnits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationalUnitsResponse> listOrganizationalUnits(
            Consumer<ListOrganizationalUnitsRequest.Builder> listOrganizationalUnitsRequest) {
        return listOrganizationalUnits(ListOrganizationalUnitsRequest.builder().applyMutation(listOrganizationalUnitsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationalUnits(software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListOrganizationalUnitsPublisher publisher = client.listOrganizationalUnitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListOrganizationalUnitsPublisher publisher = client.listOrganizationalUnitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationalUnits(software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationalUnitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListOrganizationalUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListOrganizationalUnits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationalUnitsPublisher listOrganizationalUnitsPaginator(
            ListOrganizationalUnitsRequest listOrganizationalUnitsRequest) {
        return new ListOrganizationalUnitsPublisher(this, listOrganizationalUnitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationalUnits(software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListOrganizationalUnitsPublisher publisher = client.listOrganizationalUnitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListOrganizationalUnitsPublisher publisher = client.listOrganizationalUnitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationalUnits(software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationalUnitsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOrganizationalUnitsRequest#builder()}
     * </p>
     *
     * @param listOrganizationalUnitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListOrganizationalUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListOrganizationalUnits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationalUnitsPublisher listOrganizationalUnitsPaginator(
            Consumer<ListOrganizationalUnitsRequest.Builder> listOrganizationalUnitsRequest) {
        return listOrganizationalUnitsPaginator(ListOrganizationalUnitsRequest.builder()
                .applyMutation(listOrganizationalUnitsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is only supported for <code>NotificationConfigurations</code>.
     * </p>
     * </note>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is only supported for <code>NotificationConfigurations</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Registers a <code>NotificationConfiguration</code> in the specified Region.
     * </p>
     * <p>
     * There is a maximum of one <code>NotificationConfiguration</code> per Region. You can have a maximum of 3
     * <code>NotificationHub</code> resources at a time.
     * </p>
     *
     * @param registerNotificationHubRequest
     * @return A Java Future containing the result of the RegisterNotificationHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.RegisterNotificationHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/RegisterNotificationHub"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterNotificationHubResponse> registerNotificationHub(
            RegisterNotificationHubRequest registerNotificationHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a <code>NotificationConfiguration</code> in the specified Region.
     * </p>
     * <p>
     * There is a maximum of one <code>NotificationConfiguration</code> per Region. You can have a maximum of 3
     * <code>NotificationHub</code> resources at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterNotificationHubRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterNotificationHubRequest#builder()}
     * </p>
     *
     * @param registerNotificationHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.RegisterNotificationHubRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RegisterNotificationHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.RegisterNotificationHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/RegisterNotificationHub"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterNotificationHubResponse> registerNotificationHub(
            Consumer<RegisterNotificationHubRequest.Builder> registerNotificationHubRequest) {
        return registerNotificationHub(RegisterNotificationHubRequest.builder().applyMutation(registerNotificationHubRequest)
                .build());
    }

    /**
     * <p>
     * Tags the resource with a tag key and value.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is only supported for <code>NotificationConfigurations</code>.
     * </p>
     * </note>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags the resource with a tag key and value.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is only supported for <code>NotificationConfigurations</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource with a specified Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags a resource with a specified Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing <code>EventRule</code>.
     * </p>
     *
     * @param updateEventRuleRequest
     * @return A Java Future containing the result of the UpdateEventRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.UpdateEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UpdateEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEventRuleResponse> updateEventRule(UpdateEventRuleRequest updateEventRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <code>EventRule</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEventRuleRequest#builder()}
     * </p>
     *
     * @param updateEventRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.UpdateEventRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEventRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.UpdateEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UpdateEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEventRuleResponse> updateEventRule(
            Consumer<UpdateEventRuleRequest.Builder> updateEventRuleRequest) {
        return updateEventRule(UpdateEventRuleRequest.builder().applyMutation(updateEventRuleRequest).build());
    }

    /**
     * <p>
     * Updates a <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     * @return A Java Future containing the result of the UpdateNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.UpdateNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNotificationConfigurationResponse> updateNotificationConfiguration(
            UpdateNotificationConfigurationRequest updateNotificationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.UpdateNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException This exception is thrown when the notification event fails validation.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NotificationsAsyncClient.UpdateNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNotificationConfigurationResponse> updateNotificationConfiguration(
            Consumer<UpdateNotificationConfigurationRequest.Builder> updateNotificationConfigurationRequest) {
        return updateNotificationConfiguration(UpdateNotificationConfigurationRequest.builder()
                .applyMutation(updateNotificationConfigurationRequest).build());
    }

    @Override
    default NotificationsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link NotificationsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NotificationsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NotificationsAsyncClient}.
     */
    static NotificationsAsyncClientBuilder builder() {
        return new DefaultNotificationsAsyncClientBuilder();
    }
}
