/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventRuleResponse extends NotificationsResponse implements
        ToCopyableBuilder<CreateEventRuleResponse.Builder, CreateEventRuleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateEventRuleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("notificationConfigurationArn")
            .getter(getter(CreateEventRuleResponse::notificationConfigurationArn))
            .setter(setter(Builder::notificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn")
                    .build()).build();

    private static final SdkField<Map<String, EventRuleStatusSummary>> STATUS_SUMMARY_BY_REGION_FIELD = SdkField
            .<Map<String, EventRuleStatusSummary>> builder(MarshallingType.MAP)
            .memberName("statusSummaryByRegion")
            .getter(getter(CreateEventRuleResponse::statusSummaryByRegion))
            .setter(setter(Builder::statusSummaryByRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummaryByRegion").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EventRuleStatusSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventRuleStatusSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            NOTIFICATION_CONFIGURATION_ARN_FIELD, STATUS_SUMMARY_BY_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String notificationConfigurationArn;

    private final Map<String, EventRuleStatusSummary> statusSummaryByRegion;

    private CreateEventRuleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.statusSummaryByRegion = builder.statusSummaryByRegion;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of a <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The ARN of a <code>NotificationConfiguration</code>.
     */
    public final String notificationConfigurationArn() {
        return notificationConfigurationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusSummaryByRegion property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatusSummaryByRegion() {
        return statusSummaryByRegion != null && !(statusSummaryByRegion instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of an <code>EventRule</code>'s status by Region. Regions are mapped to <code>EventRuleStatusSummary</code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusSummaryByRegion} method.
     * </p>
     * 
     * @return A list of an <code>EventRule</code>'s status by Region. Regions are mapped to
     *         <code>EventRuleStatusSummary</code>.
     */
    public final Map<String, EventRuleStatusSummary> statusSummaryByRegion() {
        return statusSummaryByRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusSummaryByRegion() ? statusSummaryByRegion() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventRuleResponse)) {
            return false;
        }
        CreateEventRuleResponse other = (CreateEventRuleResponse) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(notificationConfigurationArn(), other.notificationConfigurationArn())
                && hasStatusSummaryByRegion() == other.hasStatusSummaryByRegion()
                && Objects.equals(statusSummaryByRegion(), other.statusSummaryByRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventRuleResponse").add("Arn", arn())
                .add("NotificationConfigurationArn", notificationConfigurationArn())
                .add("StatusSummaryByRegion", hasStatusSummaryByRegion() ? statusSummaryByRegion() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "notificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(notificationConfigurationArn()));
        case "statusSummaryByRegion":
            return Optional.ofNullable(clazz.cast(statusSummaryByRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("statusSummaryByRegion", STATUS_SUMMARY_BY_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEventRuleResponse, T> g) {
        return obj -> g.apply((CreateEventRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventRuleResponse> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of a <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param notificationConfigurationArn
         *        The ARN of a <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurationArn(String notificationConfigurationArn);

        /**
         * <p>
         * A list of an <code>EventRule</code>'s status by Region. Regions are mapped to
         * <code>EventRuleStatusSummary</code>.
         * </p>
         * 
         * @param statusSummaryByRegion
         *        A list of an <code>EventRule</code>'s status by Region. Regions are mapped to
         *        <code>EventRuleStatusSummary</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummaryByRegion(Map<String, EventRuleStatusSummary> statusSummaryByRegion);
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String notificationConfigurationArn;

        private Map<String, EventRuleStatusSummary> statusSummaryByRegion = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventRuleResponse model) {
            super(model);
            arn(model.arn);
            notificationConfigurationArn(model.notificationConfigurationArn);
            statusSummaryByRegion(model.statusSummaryByRegion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNotificationConfigurationArn() {
            return notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final Map<String, EventRuleStatusSummary.Builder> getStatusSummaryByRegion() {
            Map<String, EventRuleStatusSummary.Builder> result = StatusSummaryByRegionCopier
                    .copyToBuilder(this.statusSummaryByRegion);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaryByRegion(Map<String, EventRuleStatusSummary.BuilderImpl> statusSummaryByRegion) {
            this.statusSummaryByRegion = StatusSummaryByRegionCopier.copyFromBuilder(statusSummaryByRegion);
        }

        @Override
        public final Builder statusSummaryByRegion(Map<String, EventRuleStatusSummary> statusSummaryByRegion) {
            this.statusSummaryByRegion = StatusSummaryByRegionCopier.copy(statusSummaryByRegion);
            return this;
        }

        @Override
        public CreateEventRuleResponse build() {
            return new CreateEventRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
