/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNotificationConfigurationResponse extends NotificationsResponse implements
        ToCopyableBuilder<GetNotificationConfigurationResponse.Builder, GetNotificationConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetNotificationConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetNotificationConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetNotificationConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetNotificationConfigurationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetNotificationConfigurationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> AGGREGATION_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationDuration").getter(getter(GetNotificationConfigurationResponse::aggregationDurationAsString))
            .setter(setter(Builder::aggregationDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDuration").build())
            .build();

    private static final SdkField<String> SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subtype")
            .getter(getter(GetNotificationConfigurationResponse::subtypeAsString)).setter(setter(Builder::subtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtype").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, AGGREGATION_DURATION_FIELD, SUBTYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String description;

    private final String status;

    private final Instant creationTime;

    private final String aggregationDuration;

    private final String subtype;

    private GetNotificationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.aggregationDuration = builder.aggregationDuration;
        this.subtype = builder.subtype;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The name of the <code>NotificationConfiguration</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The description of the <code>NotificationConfiguration</code>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of this <code>NotificationConfiguration</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this <code>NotificationConfiguration</code>.
     * @see NotificationConfigurationStatus
     */
    public final NotificationConfigurationStatus status() {
        return NotificationConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this <code>NotificationConfiguration</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this <code>NotificationConfiguration</code>.
     * @see NotificationConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time of the <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The creation time of the <code>NotificationConfiguration</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The aggregation preference of the <code>NotificationConfiguration</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LONG</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aggregate notifications for long periods of time (12 hours).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>SHORT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aggregate notifications for short periods of time (5 minutes).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Don't aggregate notifications.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationDuration} will return {@link AggregationDuration#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationDurationAsString}.
     * </p>
     * 
     * @return The aggregation preference of the <code>NotificationConfiguration</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LONG</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aggregate notifications for long periods of time (12 hours).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHORT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aggregate notifications for short periods of time (5 minutes).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Don't aggregate notifications.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see AggregationDuration
     */
    public final AggregationDuration aggregationDuration() {
        return AggregationDuration.fromValue(aggregationDuration);
    }

    /**
     * <p>
     * The aggregation preference of the <code>NotificationConfiguration</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LONG</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aggregate notifications for long periods of time (12 hours).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>SHORT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Aggregate notifications for short periods of time (5 minutes).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Don't aggregate notifications.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationDuration} will return {@link AggregationDuration#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationDurationAsString}.
     * </p>
     * 
     * @return The aggregation preference of the <code>NotificationConfiguration</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LONG</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aggregate notifications for long periods of time (12 hours).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHORT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Aggregate notifications for short periods of time (5 minutes).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Don't aggregate notifications.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see AggregationDuration
     */
    public final String aggregationDurationAsString() {
        return aggregationDuration;
    }

    /**
     * <p>
     * The subtype of the notification configuration returned in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subtype} will
     * return {@link NotificationConfigurationSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #subtypeAsString}.
     * </p>
     * 
     * @return The subtype of the notification configuration returned in the response.
     * @see NotificationConfigurationSubtype
     */
    public final NotificationConfigurationSubtype subtype() {
        return NotificationConfigurationSubtype.fromValue(subtype);
    }

    /**
     * <p>
     * The subtype of the notification configuration returned in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subtype} will
     * return {@link NotificationConfigurationSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #subtypeAsString}.
     * </p>
     * 
     * @return The subtype of the notification configuration returned in the response.
     * @see NotificationConfigurationSubtype
     */
    public final String subtypeAsString() {
        return subtype;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subtypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNotificationConfigurationResponse)) {
            return false;
        }
        GetNotificationConfigurationResponse other = (GetNotificationConfigurationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(aggregationDurationAsString(), other.aggregationDurationAsString())
                && Objects.equals(subtypeAsString(), other.subtypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNotificationConfigurationResponse").add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("AggregationDuration", aggregationDurationAsString()).add("Subtype", subtypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "aggregationDuration":
            return Optional.ofNullable(clazz.cast(aggregationDurationAsString()));
        case "subtype":
            return Optional.ofNullable(clazz.cast(subtypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("aggregationDuration", AGGREGATION_DURATION_FIELD);
        map.put("subtype", SUBTYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNotificationConfigurationResponse, T> g) {
        return obj -> g.apply((GetNotificationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNotificationConfigurationResponse> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param description
         *        The description of the <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of this <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param status
         *        The status of this <code>NotificationConfiguration</code>.
         * @see NotificationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param status
         *        The status of this <code>NotificationConfiguration</code>.
         * @see NotificationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationConfigurationStatus
         */
        Builder status(NotificationConfigurationStatus status);

        /**
         * <p>
         * The creation time of the <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The aggregation preference of the <code>NotificationConfiguration</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LONG</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aggregate notifications for long periods of time (12 hours).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>SHORT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aggregate notifications for short periods of time (5 minutes).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Don't aggregate notifications.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param aggregationDuration
         *        The aggregation preference of the <code>NotificationConfiguration</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LONG</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aggregate notifications for long periods of time (12 hours).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHORT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aggregate notifications for short periods of time (5 minutes).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Don't aggregate notifications.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see AggregationDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationDuration
         */
        Builder aggregationDuration(String aggregationDuration);

        /**
         * <p>
         * The aggregation preference of the <code>NotificationConfiguration</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LONG</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aggregate notifications for long periods of time (12 hours).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>SHORT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Aggregate notifications for short periods of time (5 minutes).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Don't aggregate notifications.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param aggregationDuration
         *        The aggregation preference of the <code>NotificationConfiguration</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LONG</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aggregate notifications for long periods of time (12 hours).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHORT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Aggregate notifications for short periods of time (5 minutes).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Don't aggregate notifications.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see AggregationDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationDuration
         */
        Builder aggregationDuration(AggregationDuration aggregationDuration);

        /**
         * <p>
         * The subtype of the notification configuration returned in the response.
         * </p>
         * 
         * @param subtype
         *        The subtype of the notification configuration returned in the response.
         * @see NotificationConfigurationSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationConfigurationSubtype
         */
        Builder subtype(String subtype);

        /**
         * <p>
         * The subtype of the notification configuration returned in the response.
         * </p>
         * 
         * @param subtype
         *        The subtype of the notification configuration returned in the response.
         * @see NotificationConfigurationSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationConfigurationSubtype
         */
        Builder subtype(NotificationConfigurationSubtype subtype);
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String status;

        private Instant creationTime;

        private String aggregationDuration;

        private String subtype;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNotificationConfigurationResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            status(model.status);
            creationTime(model.creationTime);
            aggregationDuration(model.aggregationDuration);
            subtype(model.subtype);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAggregationDuration() {
            return aggregationDuration;
        }

        public final void setAggregationDuration(String aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
        }

        @Override
        public final Builder aggregationDuration(String aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
            return this;
        }

        @Override
        public final Builder aggregationDuration(AggregationDuration aggregationDuration) {
            this.aggregationDuration(aggregationDuration == null ? null : aggregationDuration.toString());
            return this;
        }

        public final String getSubtype() {
            return subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        public final Builder subtype(NotificationConfigurationSubtype subtype) {
            this.subtype(subtype == null ? null : subtype.toString());
            return this;
        }

        @Override
        public GetNotificationConfigurationResponse build() {
            return new GetNotificationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
