/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNotificationEventRequest extends NotificationsRequest implements
        ToCopyableBuilder<GetNotificationEventRequest.Builder, GetNotificationEventRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetNotificationEventRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("arn").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(GetNotificationEventRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, LOCALE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String locale;

    private GetNotificationEventRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.locale = builder.locale;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>NotificationEvent</code> to return.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>NotificationEvent</code> to return.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
     * English <code>en_US</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale
     *         is English <code>en_US</code>.
     * @see LocaleCode
     */
    public final LocaleCode locale() {
        return LocaleCode.fromValue(locale);
    }

    /**
     * <p>
     * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
     * English <code>en_US</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale
     *         is English <code>en_US</code>.
     * @see LocaleCode
     */
    public final String localeAsString() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNotificationEventRequest)) {
            return false;
        }
        GetNotificationEventRequest other = (GetNotificationEventRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(localeAsString(), other.localeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNotificationEventRequest").add("Arn", arn()).add("Locale", localeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("locale", LOCALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNotificationEventRequest, T> g) {
        return obj -> g.apply((GetNotificationEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetNotificationEventRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>NotificationEvent</code> to return.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the <code>NotificationEvent</code> to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
         * English <code>en_US</code>.
         * </p>
         * 
         * @param locale
         *        The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default
         *        locale is English <code>en_US</code>.
         * @see LocaleCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleCode
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
         * English <code>en_US</code>.
         * </p>
         * 
         * @param locale
         *        The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default
         *        locale is English <code>en_US</code>.
         * @see LocaleCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleCode
         */
        Builder locale(LocaleCode locale);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NotificationsRequest.BuilderImpl implements Builder {
        private String arn;

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNotificationEventRequest model) {
            super(model);
            arn(model.arn);
            locale(model.locale);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleCode locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetNotificationEventRequest build() {
            return new GetNotificationEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
