/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedNotificationChildEventsResponse extends NotificationsResponse implements
        ToCopyableBuilder<ListManagedNotificationChildEventsResponse.Builder, ListManagedNotificationChildEventsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListManagedNotificationChildEventsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ManagedNotificationChildEventOverview>> MANAGED_NOTIFICATION_CHILD_EVENTS_FIELD = SdkField
            .<List<ManagedNotificationChildEventOverview>> builder(MarshallingType.LIST)
            .memberName("managedNotificationChildEvents")
            .getter(getter(ListManagedNotificationChildEventsResponse::managedNotificationChildEvents))
            .setter(setter(Builder::managedNotificationChildEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedNotificationChildEvents")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedNotificationChildEventOverview> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedNotificationChildEventOverview::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MANAGED_NOTIFICATION_CHILD_EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ManagedNotificationChildEventOverview> managedNotificationChildEvents;

    private ListManagedNotificationChildEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.managedNotificationChildEvents = builder.managedNotificationChildEvents;
    }

    /**
     * <p>
     * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to
     * retrieve more entries.
     * </p>
     * 
     * @return A pagination token. If a non-null pagination token is returned in a result, pass its value in another
     *         request to retrieve more entries.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedNotificationChildEvents property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasManagedNotificationChildEvents() {
        return managedNotificationChildEvents != null && !(managedNotificationChildEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to
     * retrieve more entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedNotificationChildEvents} method.
     * </p>
     * 
     * @return A pagination token. If a non-null pagination token is returned in a result, pass its value in another
     *         request to retrieve more entries.
     */
    public final List<ManagedNotificationChildEventOverview> managedNotificationChildEvents() {
        return managedNotificationChildEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasManagedNotificationChildEvents() ? managedNotificationChildEvents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedNotificationChildEventsResponse)) {
            return false;
        }
        ListManagedNotificationChildEventsResponse other = (ListManagedNotificationChildEventsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasManagedNotificationChildEvents() == other.hasManagedNotificationChildEvents()
                && Objects.equals(managedNotificationChildEvents(), other.managedNotificationChildEvents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListManagedNotificationChildEventsResponse")
                .add("NextToken", nextToken())
                .add("ManagedNotificationChildEvents",
                        hasManagedNotificationChildEvents() ? managedNotificationChildEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "managedNotificationChildEvents":
            return Optional.ofNullable(clazz.cast(managedNotificationChildEvents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("managedNotificationChildEvents", MANAGED_NOTIFICATION_CHILD_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedNotificationChildEventsResponse, T> g) {
        return obj -> g.apply((ListManagedNotificationChildEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedNotificationChildEventsResponse> {
        /**
         * <p>
         * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request
         * to retrieve more entries.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. If a non-null pagination token is returned in a result, pass its value in another
         *        request to retrieve more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request
         * to retrieve more entries.
         * </p>
         * 
         * @param managedNotificationChildEvents
         *        A pagination token. If a non-null pagination token is returned in a result, pass its value in another
         *        request to retrieve more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedNotificationChildEvents(Collection<ManagedNotificationChildEventOverview> managedNotificationChildEvents);

        /**
         * <p>
         * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request
         * to retrieve more entries.
         * </p>
         * 
         * @param managedNotificationChildEvents
         *        A pagination token. If a non-null pagination token is returned in a result, pass its value in another
         *        request to retrieve more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedNotificationChildEvents(ManagedNotificationChildEventOverview... managedNotificationChildEvents);

        /**
         * <p>
         * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request
         * to retrieve more entries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventOverview.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventOverview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventOverview.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #managedNotificationChildEvents(List<ManagedNotificationChildEventOverview>)}.
         * 
         * @param managedNotificationChildEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedNotificationChildEvents(java.util.Collection<ManagedNotificationChildEventOverview>)
         */
        Builder managedNotificationChildEvents(
                Consumer<ManagedNotificationChildEventOverview.Builder>... managedNotificationChildEvents);
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ManagedNotificationChildEventOverview> managedNotificationChildEvents = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedNotificationChildEventsResponse model) {
            super(model);
            nextToken(model.nextToken);
            managedNotificationChildEvents(model.managedNotificationChildEvents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ManagedNotificationChildEventOverview.Builder> getManagedNotificationChildEvents() {
            List<ManagedNotificationChildEventOverview.Builder> result = ManagedNotificationChildEventsCopier
                    .copyToBuilder(this.managedNotificationChildEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedNotificationChildEvents(
                Collection<ManagedNotificationChildEventOverview.BuilderImpl> managedNotificationChildEvents) {
            this.managedNotificationChildEvents = ManagedNotificationChildEventsCopier
                    .copyFromBuilder(managedNotificationChildEvents);
        }

        @Override
        public final Builder managedNotificationChildEvents(
                Collection<ManagedNotificationChildEventOverview> managedNotificationChildEvents) {
            this.managedNotificationChildEvents = ManagedNotificationChildEventsCopier.copy(managedNotificationChildEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedNotificationChildEvents(
                ManagedNotificationChildEventOverview... managedNotificationChildEvents) {
            managedNotificationChildEvents(Arrays.asList(managedNotificationChildEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedNotificationChildEvents(
                Consumer<ManagedNotificationChildEventOverview.Builder>... managedNotificationChildEvents) {
            managedNotificationChildEvents(Stream.of(managedNotificationChildEvents)
                    .map(c -> ManagedNotificationChildEventOverview.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListManagedNotificationChildEventsResponse build() {
            return new ListManagedNotificationChildEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
