/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMemberAccountsRequest extends NotificationsRequest implements
        ToCopyableBuilder<ListMemberAccountsRequest.Builder, ListMemberAccountsRequest> {
    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("notificationConfigurationArn")
            .getter(getter(ListMemberAccountsRequest::notificationConfigurationArn))
            .setter(setter(Builder::notificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("notificationConfigurationArn")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListMemberAccountsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMemberAccountsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> MEMBER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberAccount").getter(getter(ListMemberAccountsRequest::memberAccount))
            .setter(setter(Builder::memberAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("memberAccount").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListMemberAccountsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitId").getter(getter(ListMemberAccountsRequest::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("organizationalUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NOTIFICATION_CONFIGURATION_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, MEMBER_ACCOUNT_FIELD, STATUS_FIELD,
            ORGANIZATIONAL_UNIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String notificationConfigurationArn;

    private final Integer maxResults;

    private final String nextToken;

    private final String memberAccount;

    private final String status;

    private final String organizationalUnitId;

    private ListMemberAccountsRequest(BuilderImpl builder) {
        super(builder);
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.memberAccount = builder.memberAccount;
        this.status = builder.status;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notification configuration used to filter the member accounts.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notification configuration used to filter the member accounts.
     */
    public final String notificationConfigurationArn() {
        return notificationConfigurationArn;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. Valid values are 1-100.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. Valid values are 1-100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results. Use the value returned in the previous response.
     * </p>
     * 
     * @return The token for the next page of results. Use the value returned in the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The member account identifier used to filter the results.
     * </p>
     * 
     * @return The member account identifier used to filter the results.
     */
    public final String memberAccount() {
        return memberAccount;
    }

    /**
     * <p>
     * The status used to filter the member accounts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberAccountNotificationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status used to filter the member accounts.
     * @see MemberAccountNotificationConfigurationStatus
     */
    public final MemberAccountNotificationConfigurationStatus status() {
        return MemberAccountNotificationConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status used to filter the member accounts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberAccountNotificationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status used to filter the member accounts.
     * @see MemberAccountNotificationConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The organizational unit ID used to filter the member accounts.
     * </p>
     * 
     * @return The organizational unit ID used to filter the member accounts.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMemberAccountsRequest)) {
            return false;
        }
        ListMemberAccountsRequest other = (ListMemberAccountsRequest) obj;
        return Objects.equals(notificationConfigurationArn(), other.notificationConfigurationArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(memberAccount(), other.memberAccount())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMemberAccountsRequest").add("NotificationConfigurationArn", notificationConfigurationArn())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("MemberAccount", memberAccount())
                .add("Status", statusAsString()).add("OrganizationalUnitId", organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(notificationConfigurationArn()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "memberAccount":
            return Optional.ofNullable(clazz.cast(memberAccount()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "organizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("memberAccount", MEMBER_ACCOUNT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMemberAccountsRequest, T> g) {
        return obj -> g.apply((ListMemberAccountsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMemberAccountsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notification configuration used to filter the member accounts.
         * </p>
         * 
         * @param notificationConfigurationArn
         *        The Amazon Resource Name (ARN) of the notification configuration used to filter the member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurationArn(String notificationConfigurationArn);

        /**
         * <p>
         * The maximum number of results to return in a single call. Valid values are 1-100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. Valid values are 1-100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results. Use the value returned in the previous response.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results. Use the value returned in the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The member account identifier used to filter the results.
         * </p>
         * 
         * @param memberAccount
         *        The member account identifier used to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccount(String memberAccount);

        /**
         * <p>
         * The status used to filter the member accounts.
         * </p>
         * 
         * @param status
         *        The status used to filter the member accounts.
         * @see MemberAccountNotificationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountNotificationConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status used to filter the member accounts.
         * </p>
         * 
         * @param status
         *        The status used to filter the member accounts.
         * @see MemberAccountNotificationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountNotificationConfigurationStatus
         */
        Builder status(MemberAccountNotificationConfigurationStatus status);

        /**
         * <p>
         * The organizational unit ID used to filter the member accounts.
         * </p>
         * 
         * @param organizationalUnitId
         *        The organizational unit ID used to filter the member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NotificationsRequest.BuilderImpl implements Builder {
        private String notificationConfigurationArn;

        private Integer maxResults;

        private String nextToken;

        private String memberAccount;

        private String status;

        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMemberAccountsRequest model) {
            super(model);
            notificationConfigurationArn(model.notificationConfigurationArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            memberAccount(model.memberAccount);
            status(model.status);
            organizationalUnitId(model.organizationalUnitId);
        }

        public final String getNotificationConfigurationArn() {
            return notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getMemberAccount() {
            return memberAccount;
        }

        public final void setMemberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
        }

        @Override
        public final Builder memberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberAccountNotificationConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMemberAccountsRequest build() {
            return new ListMemberAccountsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
