/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationEventsRequest extends NotificationsRequest implements
        ToCopyableBuilder<ListNotificationEventsRequest.Builder, ListNotificationEventsRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(ListNotificationEventsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ListNotificationEventsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(ListNotificationEventsRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locale").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(ListNotificationEventsRequest::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("source").build()).build();

    private static final SdkField<Boolean> INCLUDE_CHILD_EVENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeChildEvents").getter(getter(ListNotificationEventsRequest::includeChildEvents))
            .setter(setter(Builder::includeChildEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeChildEvents").build())
            .build();

    private static final SdkField<String> AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("aggregateNotificationEventArn")
            .getter(getter(ListNotificationEventsRequest::aggregateNotificationEventArn))
            .setter(setter(Builder::aggregateNotificationEventArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("aggregateNotificationEventArn")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListNotificationEventsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListNotificationEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitId").getter(getter(ListNotificationEventsRequest::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("organizationalUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, LOCALE_FIELD, SOURCE_FIELD, INCLUDE_CHILD_EVENTS_FIELD, AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startTime;

    private final Instant endTime;

    private final String locale;

    private final String source;

    private final Boolean includeChildEvents;

    private final String aggregateNotificationEventArn;

    private final Integer maxResults;

    private final String nextToken;

    private final String organizationalUnitId;

    private ListNotificationEventsRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.locale = builder.locale;
        this.source = builder.source;
        this.includeChildEvents = builder.includeChildEvents;
        this.aggregateNotificationEventArn = builder.aggregateNotificationEventArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    /**
     * <p>
     * The earliest time of events to return from this call.
     * </p>
     * 
     * @return The earliest time of events to return from this call.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Latest time of events to return from this call.
     * </p>
     * 
     * @return Latest time of events to return from this call.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
     * English <code>(en_US)</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale
     *         is English <code>(en_US)</code>.
     * @see LocaleCode
     */
    public final LocaleCode locale() {
        return LocaleCode.fromValue(locale);
    }

    /**
     * <p>
     * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
     * English <code>(en_US)</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale
     *         is English <code>(en_US)</code>.
     * @see LocaleCode
     */
    public final String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * The matched event source.
     * </p>
     * <p>
     * Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are supported.
     * For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The matched event source.</p>
     *         <p>
     *         Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
     *         supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     *         >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * Include aggregated child events in the result.
     * </p>
     * 
     * @return Include aggregated child events in the result.
     */
    public final Boolean includeChildEvents() {
        return includeChildEvents;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>aggregatedNotificationEventArn</code> to match.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>aggregatedNotificationEventArn</code> to match.
     */
    public final String aggregateNotificationEventArn() {
        return aggregateNotificationEventArn;
    }

    /**
     * <p>
     * The maximum number of results to be returned in this call. Defaults to 20.
     * </p>
     * 
     * @return The maximum number of results to be returned in this call. Defaults to 20.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The start token for paginated calls. Retrieved from the response of a previous <code>ListEventRules</code> call.
     * Next token uses Base64 encoding.
     * </p>
     * 
     * @return The start token for paginated calls. Retrieved from the response of a previous
     *         <code>ListEventRules</code> call. Next token uses Base64 encoding.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The unique identifier of the organizational unit used to filter notification events.
     * </p>
     * 
     * @return The unique identifier of the organizational unit used to filter notification events.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(includeChildEvents());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateNotificationEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationEventsRequest)) {
            return false;
        }
        ListNotificationEventsRequest other = (ListNotificationEventsRequest) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(localeAsString(), other.localeAsString()) && Objects.equals(source(), other.source())
                && Objects.equals(includeChildEvents(), other.includeChildEvents())
                && Objects.equals(aggregateNotificationEventArn(), other.aggregateNotificationEventArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotificationEventsRequest").add("StartTime", startTime()).add("EndTime", endTime())
                .add("Locale", localeAsString()).add("Source", source()).add("IncludeChildEvents", includeChildEvents())
                .add("AggregateNotificationEventArn", aggregateNotificationEventArn()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("OrganizationalUnitId", organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "includeChildEvents":
            return Optional.ofNullable(clazz.cast(includeChildEvents()));
        case "aggregateNotificationEventArn":
            return Optional.ofNullable(clazz.cast(aggregateNotificationEventArn()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "organizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("includeChildEvents", INCLUDE_CHILD_EVENTS_FIELD);
        map.put("aggregateNotificationEventArn", AGGREGATE_NOTIFICATION_EVENT_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationEventsRequest, T> g) {
        return obj -> g.apply((ListNotificationEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotificationEventsRequest> {
        /**
         * <p>
         * The earliest time of events to return from this call.
         * </p>
         * 
         * @param startTime
         *        The earliest time of events to return from this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Latest time of events to return from this call.
         * </p>
         * 
         * @param endTime
         *        Latest time of events to return from this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
         * English <code>(en_US)</code>.
         * </p>
         * 
         * @param locale
         *        The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default
         *        locale is English <code>(en_US)</code>.
         * @see LocaleCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleCode
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
         * English <code>(en_US)</code>.
         * </p>
         * 
         * @param locale
         *        The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default
         *        locale is English <code>(en_US)</code>.
         * @see LocaleCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleCode
         */
        Builder locale(LocaleCode locale);

        /**
         * <p>
         * The matched event source.
         * </p>
         * <p>
         * Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
         * supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param source
         *        The matched event source.</p>
         *        <p>
         *        Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
         *        supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         *        >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * Include aggregated child events in the result.
         * </p>
         * 
         * @param includeChildEvents
         *        Include aggregated child events in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildEvents(Boolean includeChildEvents);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>aggregatedNotificationEventArn</code> to match.
         * </p>
         * 
         * @param aggregateNotificationEventArn
         *        The Amazon Resource Name (ARN) of the <code>aggregatedNotificationEventArn</code> to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateNotificationEventArn(String aggregateNotificationEventArn);

        /**
         * <p>
         * The maximum number of results to be returned in this call. Defaults to 20.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned in this call. Defaults to 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The start token for paginated calls. Retrieved from the response of a previous <code>ListEventRules</code>
         * call. Next token uses Base64 encoding.
         * </p>
         * 
         * @param nextToken
         *        The start token for paginated calls. Retrieved from the response of a previous
         *        <code>ListEventRules</code> call. Next token uses Base64 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The unique identifier of the organizational unit used to filter notification events.
         * </p>
         * 
         * @param organizationalUnitId
         *        The unique identifier of the organizational unit used to filter notification events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NotificationsRequest.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private String locale;

        private String source;

        private Boolean includeChildEvents;

        private String aggregateNotificationEventArn;

        private Integer maxResults;

        private String nextToken;

        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationEventsRequest model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            locale(model.locale);
            source(model.source);
            includeChildEvents(model.includeChildEvents);
            aggregateNotificationEventArn(model.aggregateNotificationEventArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            organizationalUnitId(model.organizationalUnitId);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleCode locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Boolean getIncludeChildEvents() {
            return includeChildEvents;
        }

        public final void setIncludeChildEvents(Boolean includeChildEvents) {
            this.includeChildEvents = includeChildEvents;
        }

        @Override
        public final Builder includeChildEvents(Boolean includeChildEvents) {
            this.includeChildEvents = includeChildEvents;
            return this;
        }

        public final String getAggregateNotificationEventArn() {
            return aggregateNotificationEventArn;
        }

        public final void setAggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
        }

        @Override
        public final Builder aggregateNotificationEventArn(String aggregateNotificationEventArn) {
            this.aggregateNotificationEventArn = aggregateNotificationEventArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotificationEventsRequest build() {
            return new ListNotificationEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
