/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of channel associations for a managed notification configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedNotificationChannelAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedNotificationChannelAssociationSummary.Builder, ManagedNotificationChannelAssociationSummary> {
    private static final SdkField<String> CHANNEL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelIdentifier").getter(getter(ManagedNotificationChannelAssociationSummary::channelIdentifier))
            .setter(setter(Builder::channelIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelIdentifier").build()).build();

    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelType").getter(getter(ManagedNotificationChannelAssociationSummary::channelTypeAsString))
            .setter(setter(Builder::channelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelType").build()).build();

    private static final SdkField<String> OVERRIDE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overrideOption").getter(getter(ManagedNotificationChannelAssociationSummary::overrideOptionAsString))
            .setter(setter(Builder::overrideOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_IDENTIFIER_FIELD,
            CHANNEL_TYPE_FIELD, OVERRIDE_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channelIdentifier;

    private final String channelType;

    private final String overrideOption;

    private ManagedNotificationChannelAssociationSummary(BuilderImpl builder) {
        this.channelIdentifier = builder.channelIdentifier;
        this.channelType = builder.channelType;
        this.overrideOption = builder.overrideOption;
    }

    /**
     * <p>
     * The unique identifier for the notification channel.
     * </p>
     * 
     * @return The unique identifier for the notification channel.
     */
    public final String channelIdentifier() {
        return channelIdentifier;
    }

    /**
     * <p>
     * The type of notification channel used for message delivery.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACCOUNT_CONTACT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delivers notifications to Account Managed contacts through the User Notification Service.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>MOBILE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delivers notifications through the Amazon Web Services Console Mobile Application to mobile devices.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CHATBOT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delivers notifications through Amazon Q Developer in chat applications to collaboration platforms (Slack, Chime).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>EMAIL</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delivers notifications to email addresses.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The type of notification channel used for message delivery.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCOUNT_CONTACT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Delivers notifications to Account Managed contacts through the User Notification Service.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MOBILE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Delivers notifications through the Amazon Web Services Console Mobile Application to mobile devices.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHATBOT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Delivers notifications through Amazon Q Developer in chat applications to collaboration platforms (Slack,
     *         Chime).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMAIL</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Delivers notifications to email addresses.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see ChannelType
     */
    public final ChannelType channelType() {
        return ChannelType.fromValue(channelType);
    }

    /**
     * <p>
     * The type of notification channel used for message delivery.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACCOUNT_CONTACT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delivers notifications to Account Managed contacts through the User Notification Service.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>MOBILE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delivers notifications through the Amazon Web Services Console Mobile Application to mobile devices.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CHATBOT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delivers notifications through Amazon Q Developer in chat applications to collaboration platforms (Slack, Chime).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>EMAIL</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Delivers notifications to email addresses.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The type of notification channel used for message delivery.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCOUNT_CONTACT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Delivers notifications to Account Managed contacts through the User Notification Service.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MOBILE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Delivers notifications through the Amazon Web Services Console Mobile Application to mobile devices.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHATBOT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Delivers notifications through Amazon Q Developer in chat applications to collaboration platforms (Slack,
     *         Chime).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMAIL</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Delivers notifications to email addresses.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see ChannelType
     */
    public final String channelTypeAsString() {
        return channelType;
    }

    /**
     * <p>
     * Controls whether users can modify channel associations for a notification configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users can associate or disassociate channels with the notification configuration.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users cannot associate or disassociate channels with the notification configuration.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overrideOption}
     * will return {@link ChannelAssociationOverrideOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #overrideOptionAsString}.
     * </p>
     * 
     * @return Controls whether users can modify channel associations for a notification configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Users can associate or disassociate channels with the notification configuration.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Users cannot associate or disassociate channels with the notification configuration.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see ChannelAssociationOverrideOption
     */
    public final ChannelAssociationOverrideOption overrideOption() {
        return ChannelAssociationOverrideOption.fromValue(overrideOption);
    }

    /**
     * <p>
     * Controls whether users can modify channel associations for a notification configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users can associate or disassociate channels with the notification configuration.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users cannot associate or disassociate channels with the notification configuration.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overrideOption}
     * will return {@link ChannelAssociationOverrideOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #overrideOptionAsString}.
     * </p>
     * 
     * @return Controls whether users can modify channel associations for a notification configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Users can associate or disassociate channels with the notification configuration.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Users cannot associate or disassociate channels with the notification configuration.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see ChannelAssociationOverrideOption
     */
    public final String overrideOptionAsString() {
        return overrideOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(overrideOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationChannelAssociationSummary)) {
            return false;
        }
        ManagedNotificationChannelAssociationSummary other = (ManagedNotificationChannelAssociationSummary) obj;
        return Objects.equals(channelIdentifier(), other.channelIdentifier())
                && Objects.equals(channelTypeAsString(), other.channelTypeAsString())
                && Objects.equals(overrideOptionAsString(), other.overrideOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedNotificationChannelAssociationSummary").add("ChannelIdentifier", channelIdentifier())
                .add("ChannelType", channelTypeAsString()).add("OverrideOption", overrideOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelIdentifier":
            return Optional.ofNullable(clazz.cast(channelIdentifier()));
        case "channelType":
            return Optional.ofNullable(clazz.cast(channelTypeAsString()));
        case "overrideOption":
            return Optional.ofNullable(clazz.cast(overrideOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelIdentifier", CHANNEL_IDENTIFIER_FIELD);
        map.put("channelType", CHANNEL_TYPE_FIELD);
        map.put("overrideOption", OVERRIDE_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationChannelAssociationSummary, T> g) {
        return obj -> g.apply((ManagedNotificationChannelAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedNotificationChannelAssociationSummary> {
        /**
         * <p>
         * The unique identifier for the notification channel.
         * </p>
         * 
         * @param channelIdentifier
         *        The unique identifier for the notification channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIdentifier(String channelIdentifier);

        /**
         * <p>
         * The type of notification channel used for message delivery.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCOUNT_CONTACT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Delivers notifications to Account Managed contacts through the User Notification Service.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>MOBILE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Delivers notifications through the Amazon Web Services Console Mobile Application to mobile devices.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CHATBOT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Delivers notifications through Amazon Q Developer in chat applications to collaboration platforms (Slack,
         * Chime).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>EMAIL</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Delivers notifications to email addresses.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param channelType
         *        The type of notification channel used for message delivery.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCOUNT_CONTACT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Delivers notifications to Account Managed contacts through the User Notification Service.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MOBILE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Delivers notifications through the Amazon Web Services Console Mobile Application to mobile devices.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHATBOT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Delivers notifications through Amazon Q Developer in chat applications to collaboration platforms
         *        (Slack, Chime).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMAIL</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Delivers notifications to email addresses.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(String channelType);

        /**
         * <p>
         * The type of notification channel used for message delivery.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCOUNT_CONTACT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Delivers notifications to Account Managed contacts through the User Notification Service.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>MOBILE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Delivers notifications through the Amazon Web Services Console Mobile Application to mobile devices.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CHATBOT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Delivers notifications through Amazon Q Developer in chat applications to collaboration platforms (Slack,
         * Chime).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>EMAIL</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Delivers notifications to email addresses.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param channelType
         *        The type of notification channel used for message delivery.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCOUNT_CONTACT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Delivers notifications to Account Managed contacts through the User Notification Service.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MOBILE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Delivers notifications through the Amazon Web Services Console Mobile Application to mobile devices.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHATBOT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Delivers notifications through Amazon Q Developer in chat applications to collaboration platforms
         *        (Slack, Chime).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMAIL</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Delivers notifications to email addresses.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(ChannelType channelType);

        /**
         * <p>
         * Controls whether users can modify channel associations for a notification configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Users can associate or disassociate channels with the notification configuration.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Users cannot associate or disassociate channels with the notification configuration.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param overrideOption
         *        Controls whether users can modify channel associations for a notification configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Users can associate or disassociate channels with the notification configuration.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Users cannot associate or disassociate channels with the notification configuration.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see ChannelAssociationOverrideOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelAssociationOverrideOption
         */
        Builder overrideOption(String overrideOption);

        /**
         * <p>
         * Controls whether users can modify channel associations for a notification configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Users can associate or disassociate channels with the notification configuration.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Users cannot associate or disassociate channels with the notification configuration.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param overrideOption
         *        Controls whether users can modify channel associations for a notification configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Users can associate or disassociate channels with the notification configuration.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Users cannot associate or disassociate channels with the notification configuration.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see ChannelAssociationOverrideOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelAssociationOverrideOption
         */
        Builder overrideOption(ChannelAssociationOverrideOption overrideOption);
    }

    static final class BuilderImpl implements Builder {
        private String channelIdentifier;

        private String channelType;

        private String overrideOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationChannelAssociationSummary model) {
            channelIdentifier(model.channelIdentifier);
            channelType(model.channelType);
            overrideOption(model.overrideOption);
        }

        public final String getChannelIdentifier() {
            return channelIdentifier;
        }

        public final void setChannelIdentifier(String channelIdentifier) {
            this.channelIdentifier = channelIdentifier;
        }

        @Override
        public final Builder channelIdentifier(String channelIdentifier) {
            this.channelIdentifier = channelIdentifier;
            return this;
        }

        public final String getChannelType() {
            return channelType;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final String getOverrideOption() {
            return overrideOption;
        }

        public final void setOverrideOption(String overrideOption) {
            this.overrideOption = overrideOption;
        }

        @Override
        public final Builder overrideOption(String overrideOption) {
            this.overrideOption = overrideOption;
            return this;
        }

        @Override
        public final Builder overrideOption(ChannelAssociationOverrideOption overrideOption) {
            this.overrideOption(overrideOption == null ? null : overrideOption.toString());
            return this;
        }

        @Override
        public ManagedNotificationChannelAssociationSummary build() {
            return new ManagedNotificationChannelAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
