/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterNotificationHubResponse extends NotificationsResponse implements
        ToCopyableBuilder<RegisterNotificationHubResponse.Builder, RegisterNotificationHubResponse> {
    private static final SdkField<String> NOTIFICATION_HUB_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationHubRegion").getter(getter(RegisterNotificationHubResponse::notificationHubRegion))
            .setter(setter(Builder::notificationHubRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationHubRegion").build())
            .build();

    private static final SdkField<NotificationHubStatusSummary> STATUS_SUMMARY_FIELD = SdkField
            .<NotificationHubStatusSummary> builder(MarshallingType.SDK_POJO).memberName("statusSummary")
            .getter(getter(RegisterNotificationHubResponse::statusSummary)).setter(setter(Builder::statusSummary))
            .constructor(NotificationHubStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(RegisterNotificationHubResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_ACTIVATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastActivationTime")
            .getter(getter(RegisterNotificationHubResponse::lastActivationTime))
            .setter(setter(Builder::lastActivationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActivationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_HUB_REGION_FIELD,
            STATUS_SUMMARY_FIELD, CREATION_TIME_FIELD, LAST_ACTIVATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String notificationHubRegion;

    private final NotificationHubStatusSummary statusSummary;

    private final Instant creationTime;

    private final Instant lastActivationTime;

    private RegisterNotificationHubResponse(BuilderImpl builder) {
        super(builder);
        this.notificationHubRegion = builder.notificationHubRegion;
        this.statusSummary = builder.statusSummary;
        this.creationTime = builder.creationTime;
        this.lastActivationTime = builder.lastActivationTime;
    }

    /**
     * <p>
     * The Region of the <code>NotificationHub</code>.
     * </p>
     * 
     * @return The Region of the <code>NotificationHub</code>.
     */
    public final String notificationHubRegion() {
        return notificationHubRegion;
    }

    /**
     * <p>
     * Provides additional information about the current <code>NotificationConfiguration</code> status information.
     * </p>
     * 
     * @return Provides additional information about the current <code>NotificationConfiguration</code> status
     *         information.
     */
    public final NotificationHubStatusSummary statusSummary() {
        return statusSummary;
    }

    /**
     * <p>
     * The date the resource was created.
     * </p>
     * 
     * @return The date the resource was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date the resource was last activated.
     * </p>
     * 
     * @return The date the resource was last activated.
     */
    public final Instant lastActivationTime() {
        return lastActivationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notificationHubRegion());
        hashCode = 31 * hashCode + Objects.hashCode(statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastActivationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterNotificationHubResponse)) {
            return false;
        }
        RegisterNotificationHubResponse other = (RegisterNotificationHubResponse) obj;
        return Objects.equals(notificationHubRegion(), other.notificationHubRegion())
                && Objects.equals(statusSummary(), other.statusSummary()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastActivationTime(), other.lastActivationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterNotificationHubResponse").add("NotificationHubRegion", notificationHubRegion())
                .add("StatusSummary", statusSummary()).add("CreationTime", creationTime())
                .add("LastActivationTime", lastActivationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationHubRegion":
            return Optional.ofNullable(clazz.cast(notificationHubRegion()));
        case "statusSummary":
            return Optional.ofNullable(clazz.cast(statusSummary()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastActivationTime":
            return Optional.ofNullable(clazz.cast(lastActivationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("notificationHubRegion", NOTIFICATION_HUB_REGION_FIELD);
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastActivationTime", LAST_ACTIVATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterNotificationHubResponse, T> g) {
        return obj -> g.apply((RegisterNotificationHubResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterNotificationHubResponse> {
        /**
         * <p>
         * The Region of the <code>NotificationHub</code>.
         * </p>
         * 
         * @param notificationHubRegion
         *        The Region of the <code>NotificationHub</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationHubRegion(String notificationHubRegion);

        /**
         * <p>
         * Provides additional information about the current <code>NotificationConfiguration</code> status information.
         * </p>
         * 
         * @param statusSummary
         *        Provides additional information about the current <code>NotificationConfiguration</code> status
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummary(NotificationHubStatusSummary statusSummary);

        /**
         * <p>
         * Provides additional information about the current <code>NotificationConfiguration</code> status information.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationHubStatusSummary.Builder}
         * avoiding the need to create one manually via {@link NotificationHubStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationHubStatusSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #statusSummary(NotificationHubStatusSummary)}.
         * 
         * @param statusSummary
         *        a consumer that will call methods on {@link NotificationHubStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummary(NotificationHubStatusSummary)
         */
        default Builder statusSummary(Consumer<NotificationHubStatusSummary.Builder> statusSummary) {
            return statusSummary(NotificationHubStatusSummary.builder().applyMutation(statusSummary).build());
        }

        /**
         * <p>
         * The date the resource was created.
         * </p>
         * 
         * @param creationTime
         *        The date the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date the resource was last activated.
         * </p>
         * 
         * @param lastActivationTime
         *        The date the resource was last activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastActivationTime(Instant lastActivationTime);
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String notificationHubRegion;

        private NotificationHubStatusSummary statusSummary;

        private Instant creationTime;

        private Instant lastActivationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterNotificationHubResponse model) {
            super(model);
            notificationHubRegion(model.notificationHubRegion);
            statusSummary(model.statusSummary);
            creationTime(model.creationTime);
            lastActivationTime(model.lastActivationTime);
        }

        public final String getNotificationHubRegion() {
            return notificationHubRegion;
        }

        public final void setNotificationHubRegion(String notificationHubRegion) {
            this.notificationHubRegion = notificationHubRegion;
        }

        @Override
        public final Builder notificationHubRegion(String notificationHubRegion) {
            this.notificationHubRegion = notificationHubRegion;
            return this;
        }

        public final NotificationHubStatusSummary.Builder getStatusSummary() {
            return statusSummary != null ? statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(NotificationHubStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(NotificationHubStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastActivationTime() {
            return lastActivationTime;
        }

        public final void setLastActivationTime(Instant lastActivationTime) {
            this.lastActivationTime = lastActivationTime;
        }

        @Override
        public final Builder lastActivationTime(Instant lastActivationTime) {
            this.lastActivationTime = lastActivationTime;
            return this;
        }

        @Override
        public RegisterNotificationHubResponse build() {
            return new RegisterNotificationHubResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
