/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about the event that caused the <code>NotificationEvent</code>. For other specific values, see
 * <code>sourceEventMetadata</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceEventMetadataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceEventMetadataSummary.Builder, SourceEventMetadataSummary> {
    private static final SdkField<String> EVENT_ORIGIN_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventOriginRegion").getter(getter(SourceEventMetadataSummary::eventOriginRegion))
            .setter(setter(Builder::eventOriginRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventOriginRegion").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(SourceEventMetadataSummary::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(SourceEventMetadataSummary::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ORIGIN_REGION_FIELD,
            SOURCE_FIELD, EVENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventOriginRegion;

    private final String source;

    private final String eventType;

    private SourceEventMetadataSummary(BuilderImpl builder) {
        this.eventOriginRegion = builder.eventOriginRegion;
        this.source = builder.source;
        this.eventType = builder.eventType;
    }

    /**
     * <p>
     * The Region where the notification originated.
     * </p>
     * <p>
     * Unavailable for aggregated notifications.
     * </p>
     * 
     * @return The Region where the notification originated.</p>
     *         <p>
     *         Unavailable for aggregated notifications.
     */
    public final String eventOriginRegion() {
        return eventOriginRegion;
    }

    /**
     * <p>
     * The matched event source.
     * </p>
     * <p>
     * Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are supported.
     * For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The matched event source.</p>
     *         <p>
     *         Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
     *         supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     *         >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The event type to match.
     * </p>
     * <p>
     * Must match one of the valid Amazon EventBridge event types. For example, EC2 Instance State-change Notification
     * and Amazon CloudWatch Alarm State Change. For more information, see <a href=
     * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The event type to match.</p>
     *         <p>
     *         Must match one of the valid Amazon EventBridge event types. For example, EC2 Instance State-change
     *         Notification and Amazon CloudWatch Alarm State Change. For more information, see <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     *         >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final String eventType() {
        return eventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventOriginRegion());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceEventMetadataSummary)) {
            return false;
        }
        SourceEventMetadataSummary other = (SourceEventMetadataSummary) obj;
        return Objects.equals(eventOriginRegion(), other.eventOriginRegion()) && Objects.equals(source(), other.source())
                && Objects.equals(eventType(), other.eventType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceEventMetadataSummary").add("EventOriginRegion", eventOriginRegion())
                .add("Source", source()).add("EventType", eventType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventOriginRegion":
            return Optional.ofNullable(clazz.cast(eventOriginRegion()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventOriginRegion", EVENT_ORIGIN_REGION_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceEventMetadataSummary, T> g) {
        return obj -> g.apply((SourceEventMetadataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceEventMetadataSummary> {
        /**
         * <p>
         * The Region where the notification originated.
         * </p>
         * <p>
         * Unavailable for aggregated notifications.
         * </p>
         * 
         * @param eventOriginRegion
         *        The Region where the notification originated.</p>
         *        <p>
         *        Unavailable for aggregated notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventOriginRegion(String eventOriginRegion);

        /**
         * <p>
         * The matched event source.
         * </p>
         * <p>
         * Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
         * supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param source
         *        The matched event source.</p>
         *        <p>
         *        Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
         *        supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         *        >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The event type to match.
         * </p>
         * <p>
         * Must match one of the valid Amazon EventBridge event types. For example, EC2 Instance State-change
         * Notification and Amazon CloudWatch Alarm State Change. For more information, see <a href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param eventType
         *        The event type to match.</p>
         *        <p>
         *        Must match one of the valid Amazon EventBridge event types. For example, EC2 Instance State-change
         *        Notification and Amazon CloudWatch Alarm State Change. For more information, see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         *        >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);
    }

    static final class BuilderImpl implements Builder {
        private String eventOriginRegion;

        private String source;

        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceEventMetadataSummary model) {
            eventOriginRegion(model.eventOriginRegion);
            source(model.source);
            eventType(model.eventType);
        }

        public final String getEventOriginRegion() {
            return eventOriginRegion;
        }

        public final void setEventOriginRegion(String eventOriginRegion) {
            this.eventOriginRegion = eventOriginRegion;
        }

        @Override
        public final Builder eventOriginRegion(String eventOriginRegion) {
            this.eventOriginRegion = eventOriginRegion;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public SourceEventMetadataSummary build() {
            return new SourceEventMetadataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
