/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsAsyncClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsRequest;
import software.amazon.awssdk.services.notifications.model.ListOrganizationalUnitsResponse;

public class ListOrganizationalUnitsPublisher
implements SdkPublisher<ListOrganizationalUnitsResponse> {
    private final NotificationsAsyncClient client;
    private final ListOrganizationalUnitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrganizationalUnitsPublisher(NotificationsAsyncClient client, ListOrganizationalUnitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrganizationalUnitsPublisher(NotificationsAsyncClient client, ListOrganizationalUnitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrganizationalUnitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrganizationalUnitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> organizationalUnits() {
        Function<ListOrganizationalUnitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationalUnits() != null) {
                return response.organizationalUnits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOrganizationalUnitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOrganizationalUnitsResponseFetcher
    implements AsyncPageFetcher<ListOrganizationalUnitsResponse> {
        private ListOrganizationalUnitsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationalUnitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrganizationalUnitsResponse> nextPage(ListOrganizationalUnitsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationalUnitsPublisher.this.client.listOrganizationalUnits(ListOrganizationalUnitsPublisher.this.firstRequest);
            }
            return ListOrganizationalUnitsPublisher.this.client.listOrganizationalUnits((ListOrganizationalUnitsRequest)((Object)ListOrganizationalUnitsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

