/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateChannelRequest extends NotificationsRequest implements
        ToCopyableBuilder<AssociateChannelRequest.Builder, AssociateChannelRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AssociateChannelRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("arn").build()).build();

    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("notificationConfigurationArn")
            .getter(getter(AssociateChannelRequest::notificationConfigurationArn))
            .setter(setter(Builder::notificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            NOTIFICATION_CONFIGURATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String notificationConfigurationArn;

    private AssociateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Channel to associate with the <code>NotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported ARNs include Amazon Q Developer in chat applications, the Console Mobile Application, and
     * notifications-contacts.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Channel to associate with the
     *         <code>NotificationConfiguration</code>.</p>
     *         <p>
     *         Supported ARNs include Amazon Q Developer in chat applications, the Console Mobile Application, and
     *         notifications-contacts.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the <code>NotificationConfiguration</code> to associate with the Channel.
     * </p>
     * 
     * @return The ARN of the <code>NotificationConfiguration</code> to associate with the Channel.
     */
    public final String notificationConfigurationArn() {
        return notificationConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateChannelRequest)) {
            return false;
        }
        AssociateChannelRequest other = (AssociateChannelRequest) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(notificationConfigurationArn(), other.notificationConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateChannelRequest").add("Arn", arn())
                .add("NotificationConfigurationArn", notificationConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "notificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(notificationConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateChannelRequest, T> g) {
        return obj -> g.apply((AssociateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateChannelRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Channel to associate with the <code>NotificationConfiguration</code>.
         * </p>
         * <p>
         * Supported ARNs include Amazon Q Developer in chat applications, the Console Mobile Application, and
         * notifications-contacts.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Channel to associate with the
         *        <code>NotificationConfiguration</code>.</p>
         *        <p>
         *        Supported ARNs include Amazon Q Developer in chat applications, the Console Mobile Application, and
         *        notifications-contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the <code>NotificationConfiguration</code> to associate with the Channel.
         * </p>
         * 
         * @param notificationConfigurationArn
         *        The ARN of the <code>NotificationConfiguration</code> to associate with the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurationArn(String notificationConfigurationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NotificationsRequest.BuilderImpl implements Builder {
        private String arn;

        private String notificationConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateChannelRequest model) {
            super(model);
            arn(model.arn);
            notificationConfigurationArn(model.notificationConfigurationArn);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNotificationConfigurationArn() {
            return notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateChannelRequest build() {
            return new AssociateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
