/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateManagedNotificationAccountContactRequest extends NotificationsRequest
        implements
        ToCopyableBuilder<AssociateManagedNotificationAccountContactRequest.Builder, AssociateManagedNotificationAccountContactRequest> {
    private static final SdkField<String> CONTACT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactIdentifier")
            .getter(getter(AssociateManagedNotificationAccountContactRequest::contactIdentifierAsString))
            .setter(setter(Builder::contactIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("contactIdentifier").build()).build();

    private static final SdkField<String> MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("managedNotificationConfigurationArn")
            .getter(getter(AssociateManagedNotificationAccountContactRequest::managedNotificationConfigurationArn))
            .setter(setter(Builder::managedNotificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("managedNotificationConfigurationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_IDENTIFIER_FIELD,
            MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contactIdentifier;

    private final String managedNotificationConfigurationArn;

    private AssociateManagedNotificationAccountContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactIdentifier = builder.contactIdentifier;
        this.managedNotificationConfigurationArn = builder.managedNotificationConfigurationArn;
    }

    /**
     * <p>
     * A unique value of an Account Contact Type to associate with the <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactIdentifier}
     * will return {@link AccountContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactIdentifierAsString}.
     * </p>
     * 
     * @return A unique value of an Account Contact Type to associate with the
     *         <code>ManagedNotificationConfiguration</code>.
     * @see AccountContactType
     */
    public final AccountContactType contactIdentifier() {
        return AccountContactType.fromValue(contactIdentifier);
    }

    /**
     * <p>
     * A unique value of an Account Contact Type to associate with the <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactIdentifier}
     * will return {@link AccountContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactIdentifierAsString}.
     * </p>
     * 
     * @return A unique value of an Account Contact Type to associate with the
     *         <code>ManagedNotificationConfiguration</code>.
     * @see AccountContactType
     */
    public final String contactIdentifierAsString() {
        return contactIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code> to associate with the Account
     * Contact.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code> to associate with the
     *         Account Contact.
     */
    public final String managedNotificationConfigurationArn() {
        return managedNotificationConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactIdentifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(managedNotificationConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateManagedNotificationAccountContactRequest)) {
            return false;
        }
        AssociateManagedNotificationAccountContactRequest other = (AssociateManagedNotificationAccountContactRequest) obj;
        return Objects.equals(contactIdentifierAsString(), other.contactIdentifierAsString())
                && Objects.equals(managedNotificationConfigurationArn(), other.managedNotificationConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateManagedNotificationAccountContactRequest")
                .add("ContactIdentifier", contactIdentifierAsString())
                .add("ManagedNotificationConfigurationArn", managedNotificationConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contactIdentifier":
            return Optional.ofNullable(clazz.cast(contactIdentifierAsString()));
        case "managedNotificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(managedNotificationConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contactIdentifier", CONTACT_IDENTIFIER_FIELD);
        map.put("managedNotificationConfigurationArn", MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateManagedNotificationAccountContactRequest, T> g) {
        return obj -> g.apply((AssociateManagedNotificationAccountContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateManagedNotificationAccountContactRequest> {
        /**
         * <p>
         * A unique value of an Account Contact Type to associate with the <code>ManagedNotificationConfiguration</code>
         * .
         * </p>
         * 
         * @param contactIdentifier
         *        A unique value of an Account Contact Type to associate with the
         *        <code>ManagedNotificationConfiguration</code>.
         * @see AccountContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountContactType
         */
        Builder contactIdentifier(String contactIdentifier);

        /**
         * <p>
         * A unique value of an Account Contact Type to associate with the <code>ManagedNotificationConfiguration</code>
         * .
         * </p>
         * 
         * @param contactIdentifier
         *        A unique value of an Account Contact Type to associate with the
         *        <code>ManagedNotificationConfiguration</code>.
         * @see AccountContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountContactType
         */
        Builder contactIdentifier(AccountContactType contactIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code> to associate with the
         * Account Contact.
         * </p>
         * 
         * @param managedNotificationConfigurationArn
         *        The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code> to associate with
         *        the Account Contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NotificationsRequest.BuilderImpl implements Builder {
        private String contactIdentifier;

        private String managedNotificationConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateManagedNotificationAccountContactRequest model) {
            super(model);
            contactIdentifier(model.contactIdentifier);
            managedNotificationConfigurationArn(model.managedNotificationConfigurationArn);
        }

        public final String getContactIdentifier() {
            return contactIdentifier;
        }

        public final void setContactIdentifier(String contactIdentifier) {
            this.contactIdentifier = contactIdentifier;
        }

        @Override
        public final Builder contactIdentifier(String contactIdentifier) {
            this.contactIdentifier = contactIdentifier;
            return this;
        }

        @Override
        public final Builder contactIdentifier(AccountContactType contactIdentifier) {
            this.contactIdentifier(contactIdentifier == null ? null : contactIdentifier.toString());
            return this;
        }

        public final String getManagedNotificationConfigurationArn() {
            return managedNotificationConfigurationArn;
        }

        public final void setManagedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
        }

        @Override
        public final Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateManagedNotificationAccountContactRequest build() {
            return new AssociateManagedNotificationAccountContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
