/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNotificationsAccessForOrganizationResponse extends NotificationsResponse implements
        ToCopyableBuilder<GetNotificationsAccessForOrganizationResponse.Builder, GetNotificationsAccessForOrganizationResponse> {
    private static final SdkField<NotificationsAccessForOrganization> NOTIFICATIONS_ACCESS_FOR_ORGANIZATION_FIELD = SdkField
            .<NotificationsAccessForOrganization> builder(MarshallingType.SDK_POJO)
            .memberName("notificationsAccessForOrganization")
            .getter(getter(GetNotificationsAccessForOrganizationResponse::notificationsAccessForOrganization))
            .setter(setter(Builder::notificationsAccessForOrganization))
            .constructor(NotificationsAccessForOrganization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationsAccessForOrganization")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NOTIFICATIONS_ACCESS_FOR_ORGANIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final NotificationsAccessForOrganization notificationsAccessForOrganization;

    private GetNotificationsAccessForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.notificationsAccessForOrganization = builder.notificationsAccessForOrganization;
    }

    /**
     * <p>
     * The <code>AccessStatus</code> of Service Trust Enablement for User Notifications to Amazon Web Services
     * Organizations.
     * </p>
     * 
     * @return The <code>AccessStatus</code> of Service Trust Enablement for User Notifications to Amazon Web Services
     *         Organizations.
     */
    public final NotificationsAccessForOrganization notificationsAccessForOrganization() {
        return notificationsAccessForOrganization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notificationsAccessForOrganization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNotificationsAccessForOrganizationResponse)) {
            return false;
        }
        GetNotificationsAccessForOrganizationResponse other = (GetNotificationsAccessForOrganizationResponse) obj;
        return Objects.equals(notificationsAccessForOrganization(), other.notificationsAccessForOrganization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNotificationsAccessForOrganizationResponse")
                .add("NotificationsAccessForOrganization", notificationsAccessForOrganization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationsAccessForOrganization":
            return Optional.ofNullable(clazz.cast(notificationsAccessForOrganization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("notificationsAccessForOrganization", NOTIFICATIONS_ACCESS_FOR_ORGANIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNotificationsAccessForOrganizationResponse, T> g) {
        return obj -> g.apply((GetNotificationsAccessForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNotificationsAccessForOrganizationResponse> {
        /**
         * <p>
         * The <code>AccessStatus</code> of Service Trust Enablement for User Notifications to Amazon Web Services
         * Organizations.
         * </p>
         * 
         * @param notificationsAccessForOrganization
         *        The <code>AccessStatus</code> of Service Trust Enablement for User Notifications to Amazon Web
         *        Services Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsAccessForOrganization(NotificationsAccessForOrganization notificationsAccessForOrganization);

        /**
         * <p>
         * The <code>AccessStatus</code> of Service Trust Enablement for User Notifications to Amazon Web Services
         * Organizations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link NotificationsAccessForOrganization.Builder} avoiding the need to create one manually via
         * {@link NotificationsAccessForOrganization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationsAccessForOrganization.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #notificationsAccessForOrganization(NotificationsAccessForOrganization)}.
         * 
         * @param notificationsAccessForOrganization
         *        a consumer that will call methods on {@link NotificationsAccessForOrganization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationsAccessForOrganization(NotificationsAccessForOrganization)
         */
        default Builder notificationsAccessForOrganization(
                Consumer<NotificationsAccessForOrganization.Builder> notificationsAccessForOrganization) {
            return notificationsAccessForOrganization(NotificationsAccessForOrganization.builder()
                    .applyMutation(notificationsAccessForOrganization).build());
        }
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private NotificationsAccessForOrganization notificationsAccessForOrganization;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNotificationsAccessForOrganizationResponse model) {
            super(model);
            notificationsAccessForOrganization(model.notificationsAccessForOrganization);
        }

        public final NotificationsAccessForOrganization.Builder getNotificationsAccessForOrganization() {
            return notificationsAccessForOrganization != null ? notificationsAccessForOrganization.toBuilder() : null;
        }

        public final void setNotificationsAccessForOrganization(
                NotificationsAccessForOrganization.BuilderImpl notificationsAccessForOrganization) {
            this.notificationsAccessForOrganization = notificationsAccessForOrganization != null ? notificationsAccessForOrganization
                    .build() : null;
        }

        @Override
        public final Builder notificationsAccessForOrganization(
                NotificationsAccessForOrganization notificationsAccessForOrganization) {
            this.notificationsAccessForOrganization = notificationsAccessForOrganization;
            return this;
        }

        @Override
        public GetNotificationsAccessForOrganizationResponse build() {
            return new GetNotificationsAccessForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
