/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationConfigurationsRequest extends NotificationsRequest implements
        ToCopyableBuilder<ListNotificationConfigurationsRequest.Builder, ListNotificationConfigurationsRequest> {
    private static final SdkField<String> EVENT_RULE_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventRuleSource").getter(getter(ListNotificationConfigurationsRequest::eventRuleSource))
            .setter(setter(Builder::eventRuleSource))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("eventRuleSource").build())
            .build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelArn").getter(getter(ListNotificationConfigurationsRequest::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("channelArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListNotificationConfigurationsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subtype")
            .getter(getter(ListNotificationConfigurationsRequest::subtypeAsString)).setter(setter(Builder::subtype))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subtype").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListNotificationConfigurationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListNotificationConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_RULE_SOURCE_FIELD,
            CHANNEL_ARN_FIELD, STATUS_FIELD, SUBTYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventRuleSource;

    private final String channelArn;

    private final String status;

    private final String subtype;

    private final Integer maxResults;

    private final String nextToken;

    private ListNotificationConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.eventRuleSource = builder.eventRuleSource;
        this.channelArn = builder.channelArn;
        this.status = builder.status;
        this.subtype = builder.subtype;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The matched event source.
     * </p>
     * <p>
     * Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are supported.
     * For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The matched event source.</p>
     *         <p>
     *         Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
     *         supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     *         >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final String eventRuleSource() {
        return eventRuleSource;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Channel to match.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Channel to match.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The <code>NotificationConfiguration</code> status to match.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All <code>EventRules</code> are <code>ACTIVE</code> and any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PARTIALLY_ACTIVE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All <code>EventRules</code> are <code>INACTIVE</code> and any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * This <code>NotificationConfiguration</code> is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Only <code>GET</code> and <code>LIST</code> calls can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The <code>NotificationConfiguration</code> status to match.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All <code>EventRules</code> are <code>ACTIVE</code> and any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARTIALLY_ACTIVE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be
     *         run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All <code>EventRules</code> are <code>INACTIVE</code> and any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This <code>NotificationConfiguration</code> is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Only <code>GET</code> and <code>LIST</code> calls can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationConfigurationStatus
     */
    public final NotificationConfigurationStatus status() {
        return NotificationConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The <code>NotificationConfiguration</code> status to match.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All <code>EventRules</code> are <code>ACTIVE</code> and any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PARTIALLY_ACTIVE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All <code>EventRules</code> are <code>INACTIVE</code> and any call can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * This <code>NotificationConfiguration</code> is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Only <code>GET</code> and <code>LIST</code> calls can be run.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The <code>NotificationConfiguration</code> status to match.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All <code>EventRules</code> are <code>ACTIVE</code> and any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARTIALLY_ACTIVE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be
     *         run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All <code>EventRules</code> are <code>INACTIVE</code> and any call can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This <code>NotificationConfiguration</code> is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Only <code>GET</code> and <code>LIST</code> calls can be run.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The subtype used to filter the notification configurations in the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subtype} will
     * return {@link NotificationConfigurationSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #subtypeAsString}.
     * </p>
     * 
     * @return The subtype used to filter the notification configurations in the request.
     * @see NotificationConfigurationSubtype
     */
    public final NotificationConfigurationSubtype subtype() {
        return NotificationConfigurationSubtype.fromValue(subtype);
    }

    /**
     * <p>
     * The subtype used to filter the notification configurations in the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subtype} will
     * return {@link NotificationConfigurationSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #subtypeAsString}.
     * </p>
     * 
     * @return The subtype used to filter the notification configurations in the request.
     * @see NotificationConfigurationSubtype
     */
    public final String subtypeAsString() {
        return subtype;
    }

    /**
     * <p>
     * The maximum number of results to be returned in this call. Defaults to 20.
     * </p>
     * 
     * @return The maximum number of results to be returned in this call. Defaults to 20.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The start token for paginated calls. Retrieved from the response of a previous <code>ListEventRules</code> call.
     * Next token uses Base64 encoding.
     * </p>
     * 
     * @return The start token for paginated calls. Retrieved from the response of a previous
     *         <code>ListEventRules</code> call. Next token uses Base64 encoding.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventRuleSource());
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationConfigurationsRequest)) {
            return false;
        }
        ListNotificationConfigurationsRequest other = (ListNotificationConfigurationsRequest) obj;
        return Objects.equals(eventRuleSource(), other.eventRuleSource()) && Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(subtypeAsString(), other.subtypeAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotificationConfigurationsRequest").add("EventRuleSource", eventRuleSource())
                .add("ChannelArn", channelArn()).add("Status", statusAsString()).add("Subtype", subtypeAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventRuleSource":
            return Optional.ofNullable(clazz.cast(eventRuleSource()));
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subtype":
            return Optional.ofNullable(clazz.cast(subtypeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventRuleSource", EVENT_RULE_SOURCE_FIELD);
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("subtype", SUBTYPE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationConfigurationsRequest, T> g) {
        return obj -> g.apply((ListNotificationConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotificationConfigurationsRequest> {
        /**
         * <p>
         * The matched event source.
         * </p>
         * <p>
         * Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
         * supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param eventRuleSource
         *        The matched event source.</p>
         *        <p>
         *        Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
         *        supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         *        >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventRuleSource(String eventRuleSource);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Channel to match.
         * </p>
         * 
         * @param channelArn
         *        The Amazon Resource Name (ARN) of the Channel to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The <code>NotificationConfiguration</code> status to match.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All <code>EventRules</code> are <code>ACTIVE</code> and any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PARTIALLY_ACTIVE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All <code>EventRules</code> are <code>INACTIVE</code> and any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * This <code>NotificationConfiguration</code> is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * Only <code>GET</code> and <code>LIST</code> calls can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param status
         *        The <code>NotificationConfiguration</code> status to match.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All <code>EventRules</code> are <code>ACTIVE</code> and any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARTIALLY_ACTIVE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can
         *        be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All <code>EventRules</code> are <code>INACTIVE</code> and any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This <code>NotificationConfiguration</code> is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Only <code>GET</code> and <code>LIST</code> calls can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The <code>NotificationConfiguration</code> status to match.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All <code>EventRules</code> are <code>ACTIVE</code> and any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PARTIALLY_ACTIVE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * Any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All <code>EventRules</code> are <code>INACTIVE</code> and any call can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * This <code>NotificationConfiguration</code> is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * Only <code>GET</code> and <code>LIST</code> calls can be run.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param status
         *        The <code>NotificationConfiguration</code> status to match.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All <code>EventRules</code> are <code>ACTIVE</code> and any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARTIALLY_ACTIVE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>. Any call can
         *        be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All <code>EventRules</code> are <code>INACTIVE</code> and any call can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This <code>NotificationConfiguration</code> is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Only <code>GET</code> and <code>LIST</code> calls can be run.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationConfigurationStatus
         */
        Builder status(NotificationConfigurationStatus status);

        /**
         * <p>
         * The subtype used to filter the notification configurations in the request.
         * </p>
         * 
         * @param subtype
         *        The subtype used to filter the notification configurations in the request.
         * @see NotificationConfigurationSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationConfigurationSubtype
         */
        Builder subtype(String subtype);

        /**
         * <p>
         * The subtype used to filter the notification configurations in the request.
         * </p>
         * 
         * @param subtype
         *        The subtype used to filter the notification configurations in the request.
         * @see NotificationConfigurationSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationConfigurationSubtype
         */
        Builder subtype(NotificationConfigurationSubtype subtype);

        /**
         * <p>
         * The maximum number of results to be returned in this call. Defaults to 20.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned in this call. Defaults to 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The start token for paginated calls. Retrieved from the response of a previous <code>ListEventRules</code>
         * call. Next token uses Base64 encoding.
         * </p>
         * 
         * @param nextToken
         *        The start token for paginated calls. Retrieved from the response of a previous
         *        <code>ListEventRules</code> call. Next token uses Base64 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NotificationsRequest.BuilderImpl implements Builder {
        private String eventRuleSource;

        private String channelArn;

        private String status;

        private String subtype;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationConfigurationsRequest model) {
            super(model);
            eventRuleSource(model.eventRuleSource);
            channelArn(model.channelArn);
            status(model.status);
            subtype(model.subtype);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getEventRuleSource() {
            return eventRuleSource;
        }

        public final void setEventRuleSource(String eventRuleSource) {
            this.eventRuleSource = eventRuleSource;
        }

        @Override
        public final Builder eventRuleSource(String eventRuleSource) {
            this.eventRuleSource = eventRuleSource;
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSubtype() {
            return subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        public final Builder subtype(NotificationConfigurationSubtype subtype) {
            this.subtype(subtype == null ? null : subtype.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotificationConfigurationsRequest build() {
            return new ListNotificationConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
