/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationConfigurationsResponse extends NotificationsResponse implements
        ToCopyableBuilder<ListNotificationConfigurationsResponse.Builder, ListNotificationConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListNotificationConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<NotificationConfigurationStructure>> NOTIFICATION_CONFIGURATIONS_FIELD = SdkField
            .<List<NotificationConfigurationStructure>> builder(MarshallingType.LIST)
            .memberName("notificationConfigurations")
            .getter(getter(ListNotificationConfigurationsResponse::notificationConfigurations))
            .setter(setter(Builder::notificationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationConfigurationStructure> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationConfigurationStructure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NOTIFICATION_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<NotificationConfigurationStructure> notificationConfigurations;

    private ListNotificationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notificationConfigurations = builder.notificationConfigurations;
    }

    /**
     * <p>
     * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to
     * retrieve more entries.
     * </p>
     * 
     * @return A pagination token. If a non-null pagination token is returned in a result, pass its value in another
     *         request to retrieve more entries.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNotificationConfigurations() {
        return notificationConfigurations != null && !(notificationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>NotificationConfigurations</code> in the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationConfigurations} method.
     * </p>
     * 
     * @return The <code>NotificationConfigurations</code> in the account.
     */
    public final List<NotificationConfigurationStructure> notificationConfigurations() {
        return notificationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationConfigurations() ? notificationConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationConfigurationsResponse)) {
            return false;
        }
        ListNotificationConfigurationsResponse other = (ListNotificationConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasNotificationConfigurations() == other.hasNotificationConfigurations()
                && Objects.equals(notificationConfigurations(), other.notificationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotificationConfigurationsResponse").add("NextToken", nextToken())
                .add("NotificationConfigurations", hasNotificationConfigurations() ? notificationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "notificationConfigurations":
            return Optional.ofNullable(clazz.cast(notificationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("notificationConfigurations", NOTIFICATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationConfigurationsResponse, T> g) {
        return obj -> g.apply((ListNotificationConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotificationConfigurationsResponse> {
        /**
         * <p>
         * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request
         * to retrieve more entries.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. If a non-null pagination token is returned in a result, pass its value in another
         *        request to retrieve more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The <code>NotificationConfigurations</code> in the account.
         * </p>
         * 
         * @param notificationConfigurations
         *        The <code>NotificationConfigurations</code> in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurations(Collection<NotificationConfigurationStructure> notificationConfigurations);

        /**
         * <p>
         * The <code>NotificationConfigurations</code> in the account.
         * </p>
         * 
         * @param notificationConfigurations
         *        The <code>NotificationConfigurations</code> in the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurations(NotificationConfigurationStructure... notificationConfigurations);

        /**
         * <p>
         * The <code>NotificationConfigurations</code> in the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.notifications.model.NotificationConfigurationStructure.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.notifications.model.NotificationConfigurationStructure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.notifications.model.NotificationConfigurationStructure.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #notificationConfigurations(List<NotificationConfigurationStructure>)}.
         * 
         * @param notificationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.notifications.model.NotificationConfigurationStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfigurations(java.util.Collection<NotificationConfigurationStructure>)
         */
        Builder notificationConfigurations(Consumer<NotificationConfigurationStructure.Builder>... notificationConfigurations);
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NotificationConfigurationStructure> notificationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            notificationConfigurations(model.notificationConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NotificationConfigurationStructure.Builder> getNotificationConfigurations() {
            List<NotificationConfigurationStructure.Builder> result = NotificationConfigurationsCopier
                    .copyToBuilder(this.notificationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationConfigurations(
                Collection<NotificationConfigurationStructure.BuilderImpl> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copyFromBuilder(notificationConfigurations);
        }

        @Override
        public final Builder notificationConfigurations(Collection<NotificationConfigurationStructure> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(NotificationConfigurationStructure... notificationConfigurations) {
            notificationConfigurations(Arrays.asList(notificationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(
                Consumer<NotificationConfigurationStructure.Builder>... notificationConfigurations) {
            notificationConfigurations(Stream.of(notificationConfigurations)
                    .map(c -> NotificationConfigurationStructure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNotificationConfigurationsResponse build() {
            return new ListNotificationConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
