/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A short summary of a <code>ManagedNotificationEvent</code>. This is only used when listing managed notification
 * events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedNotificationEventSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedNotificationEventSummary.Builder, ManagedNotificationEventSummary> {
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(ManagedNotificationEventSummary::schemaVersionAsString))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<ManagedSourceEventMetadataSummary> SOURCE_EVENT_METADATA_FIELD = SdkField
            .<ManagedSourceEventMetadataSummary> builder(MarshallingType.SDK_POJO).memberName("sourceEventMetadata")
            .getter(getter(ManagedNotificationEventSummary::sourceEventMetadata)).setter(setter(Builder::sourceEventMetadata))
            .constructor(ManagedSourceEventMetadataSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEventMetadata").build())
            .build();

    private static final SdkField<MessageComponentsSummary> MESSAGE_COMPONENTS_FIELD = SdkField
            .<MessageComponentsSummary> builder(MarshallingType.SDK_POJO).memberName("messageComponents")
            .getter(getter(ManagedNotificationEventSummary::messageComponents)).setter(setter(Builder::messageComponents))
            .constructor(MessageComponentsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageComponents").build()).build();

    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventStatus").getter(getter(ManagedNotificationEventSummary::eventStatusAsString))
            .setter(setter(Builder::eventStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatus").build()).build();

    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationType").getter(getter(ManagedNotificationEventSummary::notificationTypeAsString))
            .setter(setter(Builder::notificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD,
            SOURCE_EVENT_METADATA_FIELD, MESSAGE_COMPONENTS_FIELD, EVENT_STATUS_FIELD, NOTIFICATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schemaVersion;

    private final ManagedSourceEventMetadataSummary sourceEventMetadata;

    private final MessageComponentsSummary messageComponents;

    private final String eventStatus;

    private final String notificationType;

    private ManagedNotificationEventSummary(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.sourceEventMetadata = builder.sourceEventMetadata;
        this.messageComponents = builder.messageComponents;
        this.eventStatus = builder.eventStatus;
        this.notificationType = builder.notificationType;
    }

    /**
     * <p>
     * The schema version of the <code>ManagedNotificationEvent</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaVersion}
     * will return {@link SchemaVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaVersionAsString}.
     * </p>
     * 
     * @return The schema version of the <code>ManagedNotificationEvent</code>.
     * @see SchemaVersion
     */
    public final SchemaVersion schemaVersion() {
        return SchemaVersion.fromValue(schemaVersion);
    }

    /**
     * <p>
     * The schema version of the <code>ManagedNotificationEvent</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schemaVersion}
     * will return {@link SchemaVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemaVersionAsString}.
     * </p>
     * 
     * @return The schema version of the <code>ManagedNotificationEvent</code>.
     * @see SchemaVersion
     */
    public final String schemaVersionAsString() {
        return schemaVersion;
    }

    /**
     * <p>
     * Contains metadata about the event that caused the <code>ManagedNotificationEvent</code>.
     * </p>
     * 
     * @return Contains metadata about the event that caused the <code>ManagedNotificationEvent</code>.
     */
    public final ManagedSourceEventMetadataSummary sourceEventMetadata() {
        return sourceEventMetadata;
    }

    /**
     * Returns the value of the MessageComponents property for this object.
     * 
     * @return The value of the MessageComponents property for this object.
     */
    public final MessageComponentsSummary messageComponents() {
        return messageComponents;
    }

    /**
     * <p>
     * The managed notification event status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All <code>EventRules</code> are <code>ACTIVE</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link EventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The managed notification event status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All <code>EventRules</code> are <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see EventStatus
     */
    public final EventStatus eventStatus() {
        return EventStatus.fromValue(eventStatus);
    }

    /**
     * <p>
     * The managed notification event status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All <code>EventRules</code> are <code>ACTIVE</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link EventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The managed notification event status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All <code>EventRules</code> are <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see EventStatus
     */
    public final String eventStatusAsString() {
        return eventStatus;
    }

    /**
     * <p>
     * The Type of event causing the notification.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALERT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold was
     * breached.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where an issue is about to arise. For example, something is approaching a
     * threshold.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ANNOUNCEMENT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an important event. For example, a step in a workflow or escalation path or that a workflow
     * was updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about informational messages. For example, recommendations, service announcements, or reminders.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The Type of event causing the notification.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALERT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where something was triggered, initiated, reopened, deployed, or a
     *         threshold was breached.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where an issue is about to arise. For example, something is approaching a
     *         threshold.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANNOUNCEMENT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an important event. For example, a step in a workflow or escalation path or that a
     *         workflow was updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about informational messages. For example, recommendations, service announcements, or
     *         reminders.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationType
     */
    public final NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * <p>
     * The Type of event causing the notification.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALERT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold was
     * breached.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>WARNING</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an event where an issue is about to arise. For example, something is approaching a
     * threshold.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ANNOUNCEMENT</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about an important event. For example, a step in a workflow or escalation path or that a workflow
     * was updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>INFORMATIONAL</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A notification about informational messages. For example, recommendations, service announcements, or reminders.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The Type of event causing the notification.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALERT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where something was triggered, initiated, reopened, deployed, or a
     *         threshold was breached.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARNING</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an event where an issue is about to arise. For example, something is approaching a
     *         threshold.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANNOUNCEMENT</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about an important event. For example, a step in a workflow or escalation path or that a
     *         workflow was updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFORMATIONAL</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A notification about informational messages. For example, recommendations, service announcements, or
     *         reminders.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @see NotificationType
     */
    public final String notificationTypeAsString() {
        return notificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEventMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(messageComponents());
        hashCode = 31 * hashCode + Objects.hashCode(eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationEventSummary)) {
            return false;
        }
        ManagedNotificationEventSummary other = (ManagedNotificationEventSummary) obj;
        return Objects.equals(schemaVersionAsString(), other.schemaVersionAsString())
                && Objects.equals(sourceEventMetadata(), other.sourceEventMetadata())
                && Objects.equals(messageComponents(), other.messageComponents())
                && Objects.equals(eventStatusAsString(), other.eventStatusAsString())
                && Objects.equals(notificationTypeAsString(), other.notificationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedNotificationEventSummary").add("SchemaVersion", schemaVersionAsString())
                .add("SourceEventMetadata", sourceEventMetadata()).add("MessageComponents", messageComponents())
                .add("EventStatus", eventStatusAsString()).add("NotificationType", notificationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersionAsString()));
        case "sourceEventMetadata":
            return Optional.ofNullable(clazz.cast(sourceEventMetadata()));
        case "messageComponents":
            return Optional.ofNullable(clazz.cast(messageComponents()));
        case "eventStatus":
            return Optional.ofNullable(clazz.cast(eventStatusAsString()));
        case "notificationType":
            return Optional.ofNullable(clazz.cast(notificationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        map.put("sourceEventMetadata", SOURCE_EVENT_METADATA_FIELD);
        map.put("messageComponents", MESSAGE_COMPONENTS_FIELD);
        map.put("eventStatus", EVENT_STATUS_FIELD);
        map.put("notificationType", NOTIFICATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationEventSummary, T> g) {
        return obj -> g.apply((ManagedNotificationEventSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedNotificationEventSummary> {
        /**
         * <p>
         * The schema version of the <code>ManagedNotificationEvent</code>.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of the <code>ManagedNotificationEvent</code>.
         * @see SchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersion
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The schema version of the <code>ManagedNotificationEvent</code>.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of the <code>ManagedNotificationEvent</code>.
         * @see SchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersion
         */
        Builder schemaVersion(SchemaVersion schemaVersion);

        /**
         * <p>
         * Contains metadata about the event that caused the <code>ManagedNotificationEvent</code>.
         * </p>
         * 
         * @param sourceEventMetadata
         *        Contains metadata about the event that caused the <code>ManagedNotificationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEventMetadata(ManagedSourceEventMetadataSummary sourceEventMetadata);

        /**
         * <p>
         * Contains metadata about the event that caused the <code>ManagedNotificationEvent</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ManagedSourceEventMetadataSummary.Builder} avoiding the need to create one manually via
         * {@link ManagedSourceEventMetadataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedSourceEventMetadataSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceEventMetadata(ManagedSourceEventMetadataSummary)}.
         * 
         * @param sourceEventMetadata
         *        a consumer that will call methods on {@link ManagedSourceEventMetadataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEventMetadata(ManagedSourceEventMetadataSummary)
         */
        default Builder sourceEventMetadata(Consumer<ManagedSourceEventMetadataSummary.Builder> sourceEventMetadata) {
            return sourceEventMetadata(ManagedSourceEventMetadataSummary.builder().applyMutation(sourceEventMetadata).build());
        }

        /**
         * Sets the value of the MessageComponents property for this object.
         *
         * @param messageComponents
         *        The new value for the MessageComponents property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageComponents(MessageComponentsSummary messageComponents);

        /**
         * Sets the value of the MessageComponents property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MessageComponentsSummary.Builder}
         * avoiding the need to create one manually via {@link MessageComponentsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageComponentsSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #messageComponents(MessageComponentsSummary)}.
         * 
         * @param messageComponents
         *        a consumer that will call methods on {@link MessageComponentsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageComponents(MessageComponentsSummary)
         */
        default Builder messageComponents(Consumer<MessageComponentsSummary.Builder> messageComponents) {
            return messageComponents(MessageComponentsSummary.builder().applyMutation(messageComponents).build());
        }

        /**
         * <p>
         * The managed notification event status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All <code>EventRules</code> are <code>ACTIVE</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param eventStatus
         *        The managed notification event status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All <code>EventRules</code> are <code>ACTIVE</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see EventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStatus
         */
        Builder eventStatus(String eventStatus);

        /**
         * <p>
         * The managed notification event status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All <code>EventRules</code> are <code>ACTIVE</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param eventStatus
         *        The managed notification event status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All <code>EventRules</code> are <code>ACTIVE</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Some <code>EventRules</code> are <code>ACTIVE</code> and some are <code>INACTIVE</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see EventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStatus
         */
        Builder eventStatus(EventStatus eventStatus);

        /**
         * <p>
         * The Type of event causing the notification.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALERT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold
         * was breached.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where an issue is about to arise. For example, something is approaching a
         * threshold.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ANNOUNCEMENT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an important event. For example, a step in a workflow or escalation path or that a
         * workflow was updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about informational messages. For example, recommendations, service announcements, or
         * reminders.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        The Type of event causing the notification.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALERT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where something was triggered, initiated, reopened, deployed, or a
         *        threshold was breached.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where an issue is about to arise. For example, something is approaching
         *        a threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANNOUNCEMENT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an important event. For example, a step in a workflow or escalation path or that
         *        a workflow was updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about informational messages. For example, recommendations, service announcements, or
         *        reminders.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * <p>
         * The Type of event causing the notification.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALERT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where something was triggered, initiated, reopened, deployed, or a threshold
         * was breached.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>WARNING</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an event where an issue is about to arise. For example, something is approaching a
         * threshold.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ANNOUNCEMENT</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about an important event. For example, a step in a workflow or escalation path or that a
         * workflow was updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>INFORMATIONAL</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A notification about informational messages. For example, recommendations, service announcements, or
         * reminders.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        The Type of event causing the notification.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALERT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where something was triggered, initiated, reopened, deployed, or a
         *        threshold was breached.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARNING</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an event where an issue is about to arise. For example, something is approaching
         *        a threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANNOUNCEMENT</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about an important event. For example, a step in a workflow or escalation path or that
         *        a workflow was updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFORMATIONAL</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A notification about informational messages. For example, recommendations, service announcements, or
         *        reminders.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);
    }

    static final class BuilderImpl implements Builder {
        private String schemaVersion;

        private ManagedSourceEventMetadataSummary sourceEventMetadata;

        private MessageComponentsSummary messageComponents;

        private String eventStatus;

        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationEventSummary model) {
            schemaVersion(model.schemaVersion);
            sourceEventMetadata(model.sourceEventMetadata);
            messageComponents(model.messageComponents);
            eventStatus(model.eventStatus);
            notificationType(model.notificationType);
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public final Builder schemaVersion(SchemaVersion schemaVersion) {
            this.schemaVersion(schemaVersion == null ? null : schemaVersion.toString());
            return this;
        }

        public final ManagedSourceEventMetadataSummary.Builder getSourceEventMetadata() {
            return sourceEventMetadata != null ? sourceEventMetadata.toBuilder() : null;
        }

        public final void setSourceEventMetadata(ManagedSourceEventMetadataSummary.BuilderImpl sourceEventMetadata) {
            this.sourceEventMetadata = sourceEventMetadata != null ? sourceEventMetadata.build() : null;
        }

        @Override
        public final Builder sourceEventMetadata(ManagedSourceEventMetadataSummary sourceEventMetadata) {
            this.sourceEventMetadata = sourceEventMetadata;
            return this;
        }

        public final MessageComponentsSummary.Builder getMessageComponents() {
            return messageComponents != null ? messageComponents.toBuilder() : null;
        }

        public final void setMessageComponents(MessageComponentsSummary.BuilderImpl messageComponents) {
            this.messageComponents = messageComponents != null ? messageComponents.build() : null;
        }

        @Override
        public final Builder messageComponents(MessageComponentsSummary messageComponents) {
            this.messageComponents = messageComponents;
            return this;
        }

        public final String getEventStatus() {
            return eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(EventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        @Override
        public ManagedNotificationEventSummary build() {
            return new ManagedNotificationEventSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
