/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a media element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaElement implements SdkPojo, Serializable, ToCopyableBuilder<MediaElement.Builder, MediaElement> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaId").getter(getter(MediaElement::mediaId)).setter(setter(Builder::mediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(MediaElement::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(MediaElement::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> CAPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caption")
            .getter(getter(MediaElement::caption)).setter(setter(Builder::caption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_ID_FIELD, TYPE_FIELD,
            URL_FIELD, CAPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mediaId;

    private final String type;

    private final String url;

    private final String caption;

    private MediaElement(BuilderImpl builder) {
        this.mediaId = builder.mediaId;
        this.type = builder.type;
        this.url = builder.url;
        this.caption = builder.caption;
    }

    /**
     * <p>
     * The unique ID for the media.
     * </p>
     * 
     * @return The unique ID for the media.
     */
    public final String mediaId() {
        return mediaId;
    }

    /**
     * <p>
     * The type of media.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MediaElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of media.
     * @see MediaElementType
     */
    public final MediaElementType type() {
        return MediaElementType.fromValue(type);
    }

    /**
     * <p>
     * The type of media.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MediaElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of media.
     * @see MediaElementType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The URL of the media.
     * </p>
     * 
     * @return The URL of the media.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The caption of the media.
     * </p>
     * 
     * @return The caption of the media.
     */
    public final String caption() {
        return caption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(caption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaElement)) {
            return false;
        }
        MediaElement other = (MediaElement) obj;
        return Objects.equals(mediaId(), other.mediaId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(url(), other.url()) && Objects.equals(caption(), other.caption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaElement").add("MediaId", mediaId()).add("Type", typeAsString()).add("Url", url())
                .add("Caption", caption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mediaId":
            return Optional.ofNullable(clazz.cast(mediaId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "caption":
            return Optional.ofNullable(clazz.cast(caption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mediaId", MEDIA_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("url", URL_FIELD);
        map.put("caption", CAPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaElement, T> g) {
        return obj -> g.apply((MediaElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaElement> {
        /**
         * <p>
         * The unique ID for the media.
         * </p>
         * 
         * @param mediaId
         *        The unique ID for the media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaId(String mediaId);

        /**
         * <p>
         * The type of media.
         * </p>
         * 
         * @param type
         *        The type of media.
         * @see MediaElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaElementType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of media.
         * </p>
         * 
         * @param type
         *        The type of media.
         * @see MediaElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaElementType
         */
        Builder type(MediaElementType type);

        /**
         * <p>
         * The URL of the media.
         * </p>
         * 
         * @param url
         *        The URL of the media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The caption of the media.
         * </p>
         * 
         * @param caption
         *        The caption of the media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caption(String caption);
    }

    static final class BuilderImpl implements Builder {
        private String mediaId;

        private String type;

        private String url;

        private String caption;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaElement model) {
            mediaId(model.mediaId);
            type(model.type);
            url(model.url);
            caption(model.caption);
        }

        public final String getMediaId() {
            return mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MediaElementType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getCaption() {
            return caption;
        }

        public final void setCaption(String caption) {
            this.caption = caption;
        }

        @Override
        public final Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Override
        public MediaElement build() {
            return new MediaElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
