/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a member account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberAccount implements SdkPojo, Serializable, ToCopyableBuilder<MemberAccount.Builder, MemberAccount> {
    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("notificationConfigurationArn")
            .getter(getter(MemberAccount::notificationConfigurationArn))
            .setter(setter(Builder::notificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn")
                    .build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(MemberAccount::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MemberAccount::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(MemberAccount::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitId").getter(getter(MemberAccount::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NOTIFICATION_CONFIGURATION_ARN_FIELD, ACCOUNT_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            ORGANIZATIONAL_UNIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String notificationConfigurationArn;

    private final String accountId;

    private final String status;

    private final String statusReason;

    private final String organizationalUnitId;

    private MemberAccount(BuilderImpl builder) {
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.accountId = builder.accountId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notification configuration associated with the member account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notification configuration associated with the member account.
     */
    public final String notificationConfigurationArn() {
        return notificationConfigurationArn;
    }

    /**
     * <p>
     * The AWS account ID of the member account.
     * </p>
     * 
     * @return The AWS account ID of the member account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The current status of the member account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberAccountNotificationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the member account.
     * @see MemberAccountNotificationConfigurationStatus
     */
    public final MemberAccountNotificationConfigurationStatus status() {
        return MemberAccountNotificationConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the member account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberAccountNotificationConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the member account.
     * @see MemberAccountNotificationConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the member account.
     * </p>
     * 
     * @return The reason for the current status of the member account.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The unique identifier of the organizational unit containing the member account.
     * </p>
     * 
     * @return The unique identifier of the organizational unit containing the member account.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberAccount)) {
            return false;
        }
        MemberAccount other = (MemberAccount) obj;
        return Objects.equals(notificationConfigurationArn(), other.notificationConfigurationArn())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberAccount").add("NotificationConfigurationArn", notificationConfigurationArn())
                .add("AccountId", accountId()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("OrganizationalUnitId", organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "notificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(notificationConfigurationArn()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "organizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemberAccount, T> g) {
        return obj -> g.apply((MemberAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberAccount> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notification configuration associated with the member account.
         * </p>
         * 
         * @param notificationConfigurationArn
         *        The Amazon Resource Name (ARN) of the notification configuration associated with the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurationArn(String notificationConfigurationArn);

        /**
         * <p>
         * The AWS account ID of the member account.
         * </p>
         * 
         * @param accountId
         *        The AWS account ID of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The current status of the member account.
         * </p>
         * 
         * @param status
         *        The current status of the member account.
         * @see MemberAccountNotificationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountNotificationConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the member account.
         * </p>
         * 
         * @param status
         *        The current status of the member account.
         * @see MemberAccountNotificationConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountNotificationConfigurationStatus
         */
        Builder status(MemberAccountNotificationConfigurationStatus status);

        /**
         * <p>
         * The reason for the current status of the member account.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current status of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The unique identifier of the organizational unit containing the member account.
         * </p>
         * 
         * @param organizationalUnitId
         *        The unique identifier of the organizational unit containing the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);
    }

    static final class BuilderImpl implements Builder {
        private String notificationConfigurationArn;

        private String accountId;

        private String status;

        private String statusReason;

        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberAccount model) {
            notificationConfigurationArn(model.notificationConfigurationArn);
            accountId(model.accountId);
            status(model.status);
            statusReason(model.statusReason);
            organizationalUnitId(model.organizationalUnitId);
        }

        public final String getNotificationConfigurationArn() {
            return notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberAccountNotificationConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        @Override
        public MemberAccount build() {
            return new MemberAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
