/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource affected by or closely linked to an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Resource::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Resource::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DETAIL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detailUrl").getter(getter(Resource::detailUrl)).setter(setter(Builder::detailUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailUrl").build()).build();

    private static final SdkField<List<String>> TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(Resource::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            DETAIL_URL_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String detailUrl;

    private final List<String> tags;

    private Resource(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.detailUrl = builder.detailUrl;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier for the resource.
     * </p>
     * <p>
     * At least one id or ARN is required.
     * </p>
     * 
     * @return The unique identifier for the resource.</p>
     *         <p>
     *         At least one id or ARN is required.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource. At least one id or ARN is required.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource. At least one id or ARN is required.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The URL to the resource's detail page. If a detail page URL is unavailable, it is the URL to an informational
     * page that describes the resource's type.
     * </p>
     * 
     * @return The URL to the resource's detail page. If a detail page URL is unavailable, it is the URL to an
     *         informational page that describes the resource's type.
     */
    public final String detailUrl() {
        return detailUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.
     */
    public final List<String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(detailUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(detailUrl(), other.detailUrl()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("Id", id()).add("Arn", arn()).add("DetailUrl", detailUrl())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "detailUrl":
            return Optional.ofNullable(clazz.cast(detailUrl()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("detailUrl", DETAIL_URL_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The unique identifier for the resource.
         * </p>
         * <p>
         * At least one id or ARN is required.
         * </p>
         * 
         * @param id
         *        The unique identifier for the resource.</p>
         *        <p>
         *        At least one id or ARN is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource. At least one id or ARN is required.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource. At least one id or ARN is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The URL to the resource's detail page. If a detail page URL is unavailable, it is the URL to an informational
         * page that describes the resource's type.
         * </p>
         * 
         * @param detailUrl
         *        The URL to the resource's detail page. If a detail page URL is unavailable, it is the URL to an
         *        informational page that describes the resource's type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailUrl(String detailUrl);

        /**
         * <p>
         * A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.
         * </p>
         * 
         * @param tags
         *        A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<String> tags);

        /**
         * <p>
         * A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.
         * </p>
         * 
         * @param tags
         *        A map of tags assigned to a resource. A tag is a string-to-string map of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(String... tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String detailUrl;

        private List<String> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            id(model.id);
            arn(model.arn);
            detailUrl(model.detailUrl);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDetailUrl() {
            return detailUrl;
        }

        public final void setDetailUrl(String detailUrl) {
            this.detailUrl = detailUrl;
        }

        @Override
        public final Builder detailUrl(String detailUrl) {
            this.detailUrl = detailUrl;
            return this;
        }

        public final Collection<String> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags;
        }

        public final void setTags(Collection<String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Collection<String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(String... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
