/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * The <i>User Notifications API Reference</i> provides descriptions, API request parameters, and the JSON response for
 * each of the User Notifications API actions.
 * </p>
 * <p>
 * User Notification control plane APIs are currently available in US East (Virginia) - <code>us-east-1</code>.
 * </p>
 * <p>
 * <a href="https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetNotificationEvent.html">
 * GetNotificationEvent</a> and <a
 * href="https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListNotificationEvents.html"
 * >ListNotificationEvents</a> APIs are currently available in <a
 * href="https://docs.aws.amazon.com/notifications/latest/userguide/supported-regions.html">commercial partition
 * Regions</a> and only return notifications stored in the same Region in which they're called.
 * </p>
 * <p>
 * The User Notifications console can only be used in US East (Virginia). Your data however, is stored in each Region
 * chosen as a <a href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">notification
 * hub</a> in addition to US East (Virginia).
 * </p>
 * <note>
 * <p>
 * For information about descriptions, API request parameters, and the JSON response for email contact related API
 * actions, see the <a href="https://docs.aws.amazon.com/notificationscontacts/latest/APIReference/Welcome.html">User
 * Notifications Contacts API Reference Guide</a>.
 * </p>
 * </note>
 */
package software.amazon.awssdk.services.notifications;