/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notificationscontacts;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.notificationscontacts.model.ActivateEmailContactRequest;
import software.amazon.awssdk.services.notificationscontacts.model.ActivateEmailContactResponse;
import software.amazon.awssdk.services.notificationscontacts.model.CreateEmailContactRequest;
import software.amazon.awssdk.services.notificationscontacts.model.CreateEmailContactResponse;
import software.amazon.awssdk.services.notificationscontacts.model.DeleteEmailContactRequest;
import software.amazon.awssdk.services.notificationscontacts.model.DeleteEmailContactResponse;
import software.amazon.awssdk.services.notificationscontacts.model.GetEmailContactRequest;
import software.amazon.awssdk.services.notificationscontacts.model.GetEmailContactResponse;
import software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest;
import software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse;
import software.amazon.awssdk.services.notificationscontacts.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.notificationscontacts.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.notificationscontacts.model.SendActivationCodeRequest;
import software.amazon.awssdk.services.notificationscontacts.model.SendActivationCodeResponse;
import software.amazon.awssdk.services.notificationscontacts.model.TagResourceRequest;
import software.amazon.awssdk.services.notificationscontacts.model.TagResourceResponse;
import software.amazon.awssdk.services.notificationscontacts.model.UntagResourceRequest;
import software.amazon.awssdk.services.notificationscontacts.model.UntagResourceResponse;
import software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsPublisher;

/**
 * Service client for accessing AWS User Notifications Contacts asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * AWS User Notifications Contacts is a service that allows you to create and manage email contacts for AWS User
 * Notifications. The AWS User Notifications Contacts API Reference provides descriptions, API request parameters, and
 * the JSON response for all email contact related API actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NotificationsContactsAsyncClient extends AwsClient {
    String SERVICE_NAME = "notifications-contacts";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "notifications-contacts";

    /**
     * <p>
     * Activates an email contact using an activation code. This code is in the activation email sent to the email
     * address associated with this email contact.
     * </p>
     *
     * @param activateEmailContactRequest
     * @return A Java Future containing the result of the ActivateEmailContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.ActivateEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ActivateEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateEmailContactResponse> activateEmailContact(
            ActivateEmailContactRequest activateEmailContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an email contact using an activation code. This code is in the activation email sent to the email
     * address associated with this email contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateEmailContactRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateEmailContactRequest#builder()}
     * </p>
     *
     * @param activateEmailContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.ActivateEmailContactRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ActivateEmailContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.ActivateEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ActivateEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateEmailContactResponse> activateEmailContact(
            Consumer<ActivateEmailContactRequest.Builder> activateEmailContactRequest) {
        return activateEmailContact(ActivateEmailContactRequest.builder().applyMutation(activateEmailContactRequest).build());
    }

    /**
     * <p>
     * Creates an email contact for the provided email address.
     * </p>
     *
     * @param createEmailContactRequest
     * @return A Java Future containing the result of the CreateEmailContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.CreateEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/CreateEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEmailContactResponse> createEmailContact(CreateEmailContactRequest createEmailContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an email contact for the provided email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailContactRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailContactRequest#builder()}
     * </p>
     *
     * @param createEmailContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.CreateEmailContactRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEmailContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.CreateEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/CreateEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEmailContactResponse> createEmailContact(
            Consumer<CreateEmailContactRequest.Builder> createEmailContactRequest) {
        return createEmailContact(CreateEmailContactRequest.builder().applyMutation(createEmailContactRequest).build());
    }

    /**
     * <p>
     * Deletes an email contact.
     * </p>
     * <note>
     * <p>
     * Deleting an email contact removes it from all associated notification configurations.
     * </p>
     * </note>
     *
     * @param deleteEmailContactRequest
     * @return A Java Future containing the result of the DeleteEmailContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.DeleteEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/DeleteEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEmailContactResponse> deleteEmailContact(DeleteEmailContactRequest deleteEmailContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email contact.
     * </p>
     * <note>
     * <p>
     * Deleting an email contact removes it from all associated notification configurations.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailContactRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailContactRequest#builder()}
     * </p>
     *
     * @param deleteEmailContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.DeleteEmailContactRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEmailContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.DeleteEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/DeleteEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEmailContactResponse> deleteEmailContact(
            Consumer<DeleteEmailContactRequest.Builder> deleteEmailContactRequest) {
        return deleteEmailContact(DeleteEmailContactRequest.builder().applyMutation(deleteEmailContactRequest).build());
    }

    /**
     * <p>
     * Returns an email contact.
     * </p>
     *
     * @param getEmailContactRequest
     * @return A Java Future containing the result of the GetEmailContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.GetEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/GetEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEmailContactResponse> getEmailContact(GetEmailContactRequest getEmailContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an email contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailContactRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailContactRequest#builder()}
     * </p>
     *
     * @param getEmailContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.GetEmailContactRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEmailContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.GetEmailContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/GetEmailContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEmailContactResponse> getEmailContact(
            Consumer<GetEmailContactRequest.Builder> getEmailContactRequest) {
        return getEmailContact(GetEmailContactRequest.builder().applyMutation(getEmailContactRequest).build());
    }

    /**
     * <p>
     * Lists all email contacts created under the Account.
     * </p>
     *
     * @param listEmailContactsRequest
     * @return A Java Future containing the result of the ListEmailContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.ListEmailContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListEmailContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEmailContactsResponse> listEmailContacts(ListEmailContactsRequest listEmailContactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all email contacts created under the Account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailContactsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEmailContactsRequest#builder()}
     * </p>
     *
     * @param listEmailContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEmailContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.ListEmailContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListEmailContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEmailContactsResponse> listEmailContacts(
            Consumer<ListEmailContactsRequest.Builder> listEmailContactsRequest) {
        return listEmailContacts(ListEmailContactsRequest.builder().applyMutation(listEmailContactsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEmailContacts(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsPublisher publisher = client.listEmailContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsPublisher publisher = client.listEmailContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailContacts(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEmailContactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.ListEmailContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListEmailContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEmailContactsPublisher listEmailContactsPaginator(ListEmailContactsRequest listEmailContactsRequest) {
        return new ListEmailContactsPublisher(this, listEmailContactsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEmailContacts(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsPublisher publisher = client.listEmailContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notificationscontacts.paginators.ListEmailContactsPublisher publisher = client.listEmailContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailContacts(software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailContactsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEmailContactsRequest#builder()}
     * </p>
     *
     * @param listEmailContactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.ListEmailContactsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.ListEmailContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListEmailContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEmailContactsPublisher listEmailContactsPaginator(
            Consumer<ListEmailContactsRequest.Builder> listEmailContactsRequest) {
        return listEmailContactsPaginator(ListEmailContactsRequest.builder().applyMutation(listEmailContactsRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sends an activation email to the email address associated with the specified email contact.
     * </p>
     * <note>
     * <p>
     * It might take a few minutes for the activation email to arrive. If it doesn't arrive, check in your spam folder
     * or try sending another activation email.
     * </p>
     * </note>
     *
     * @param sendActivationCodeRequest
     * @return A Java Future containing the result of the SendActivationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.SendActivationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/SendActivationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendActivationCodeResponse> sendActivationCode(SendActivationCodeRequest sendActivationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an activation email to the email address associated with the specified email contact.
     * </p>
     * <note>
     * <p>
     * It might take a few minutes for the activation email to arrive. If it doesn't arrive, check in your spam folder
     * or try sending another activation email.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendActivationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link SendActivationCodeRequest#builder()}
     * </p>
     *
     * @param sendActivationCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.SendActivationCodeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SendActivationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.SendActivationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/SendActivationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendActivationCodeResponse> sendActivationCode(
            Consumer<SendActivationCodeRequest.Builder> sendActivationCodeRequest) {
        return sendActivationCode(SendActivationCodeRequest.builder().applyMutation(sendActivationCodeRequest).build());
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Taggable resources in
     * AWS User Notifications Contacts include email contacts.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Taggable resources in
     * AWS User Notifications Contacts include email contacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Taggable resources in
     * AWS User Notifications Contacts include email contacts..
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Taggable resources in
     * AWS User Notifications Contacts include email contacts..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notificationscontacts.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ResourceNotFoundException Your request references a resource which does not exist.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NotificationsContactsException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample NotificationsContactsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notificationscontacts-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default NotificationsContactsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link NotificationsContactsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NotificationsContactsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NotificationsContactsAsyncClient}.
     */
    static NotificationsContactsAsyncClientBuilder builder() {
        return new DefaultNotificationsContactsAsyncClientBuilder();
    }
}
