/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notificationscontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEmailContactsResponse extends NotificationsContactsResponse implements
        ToCopyableBuilder<ListEmailContactsResponse.Builder, ListEmailContactsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEmailContactsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<EmailContact>> EMAIL_CONTACTS_FIELD = SdkField
            .<List<EmailContact>> builder(MarshallingType.LIST)
            .memberName("emailContacts")
            .getter(getter(ListEmailContactsResponse::emailContacts))
            .setter(setter(Builder::emailContacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailContacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailContact> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailContact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            EMAIL_CONTACTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<EmailContact> emailContacts;

    private ListEmailContactsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.emailContacts = builder.emailContacts;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmailContacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEmailContacts() {
        return emailContacts != null && !(emailContacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of email contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmailContacts} method.
     * </p>
     * 
     * @return A list of email contacts.
     */
    public final List<EmailContact> emailContacts() {
        return emailContacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmailContacts() ? emailContacts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEmailContactsResponse)) {
            return false;
        }
        ListEmailContactsResponse other = (ListEmailContactsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEmailContacts() == other.hasEmailContacts()
                && Objects.equals(emailContacts(), other.emailContacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEmailContactsResponse").add("NextToken", nextToken())
                .add("EmailContacts", hasEmailContacts() ? emailContacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "emailContacts":
            return Optional.ofNullable(clazz.cast(emailContacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("emailContacts", EMAIL_CONTACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEmailContactsResponse, T> g) {
        return obj -> g.apply((ListEmailContactsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NotificationsContactsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEmailContactsResponse> {
        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of email contacts.
         * </p>
         * 
         * @param emailContacts
         *        A list of email contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailContacts(Collection<EmailContact> emailContacts);

        /**
         * <p>
         * A list of email contacts.
         * </p>
         * 
         * @param emailContacts
         *        A list of email contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailContacts(EmailContact... emailContacts);

        /**
         * <p>
         * A list of email contacts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.notificationscontacts.model.EmailContact.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.notificationscontacts.model.EmailContact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.notificationscontacts.model.EmailContact.Builder#build()} is called
         * immediately and its result is passed to {@link #emailContacts(List<EmailContact>)}.
         * 
         * @param emailContacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.notificationscontacts.model.EmailContact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailContacts(java.util.Collection<EmailContact>)
         */
        Builder emailContacts(Consumer<EmailContact.Builder>... emailContacts);
    }

    static final class BuilderImpl extends NotificationsContactsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<EmailContact> emailContacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEmailContactsResponse model) {
            super(model);
            nextToken(model.nextToken);
            emailContacts(model.emailContacts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EmailContact.Builder> getEmailContacts() {
            List<EmailContact.Builder> result = EmailContactsCopier.copyToBuilder(this.emailContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailContacts(Collection<EmailContact.BuilderImpl> emailContacts) {
            this.emailContacts = EmailContactsCopier.copyFromBuilder(emailContacts);
        }

        @Override
        public final Builder emailContacts(Collection<EmailContact> emailContacts) {
            this.emailContacts = EmailContactsCopier.copy(emailContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailContacts(EmailContact... emailContacts) {
            emailContacts(Arrays.asList(emailContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailContacts(Consumer<EmailContact.Builder>... emailContacts) {
            emailContacts(Stream.of(emailContacts).map(c -> EmailContact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEmailContactsResponse build() {
            return new ListEmailContactsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
