/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notificationscontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEmailContactResponse extends NotificationsContactsResponse implements
        ToCopyableBuilder<GetEmailContactResponse.Builder, GetEmailContactResponse> {
    private static final SdkField<EmailContact> EMAIL_CONTACT_FIELD = SdkField.<EmailContact> builder(MarshallingType.SDK_POJO)
            .memberName("emailContact").getter(getter(GetEmailContactResponse::emailContact))
            .setter(setter(Builder::emailContact)).constructor(EmailContact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailContact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_CONTACT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EmailContact emailContact;

    private GetEmailContactResponse(BuilderImpl builder) {
        super(builder);
        this.emailContact = builder.emailContact;
    }

    /**
     * <p>
     * The email contact for the provided email address.
     * </p>
     * 
     * @return The email contact for the provided email address.
     */
    public final EmailContact emailContact() {
        return emailContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailContact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEmailContactResponse)) {
            return false;
        }
        GetEmailContactResponse other = (GetEmailContactResponse) obj;
        return Objects.equals(emailContact(), other.emailContact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEmailContactResponse").add("EmailContact", emailContact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "emailContact":
            return Optional.ofNullable(clazz.cast(emailContact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("emailContact", EMAIL_CONTACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEmailContactResponse, T> g) {
        return obj -> g.apply((GetEmailContactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NotificationsContactsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEmailContactResponse> {
        /**
         * <p>
         * The email contact for the provided email address.
         * </p>
         * 
         * @param emailContact
         *        The email contact for the provided email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailContact(EmailContact emailContact);

        /**
         * <p>
         * The email contact for the provided email address.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailContact.Builder} avoiding the need
         * to create one manually via {@link EmailContact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailContact.Builder#build()} is called immediately and its
         * result is passed to {@link #emailContact(EmailContact)}.
         * 
         * @param emailContact
         *        a consumer that will call methods on {@link EmailContact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailContact(EmailContact)
         */
        default Builder emailContact(Consumer<EmailContact.Builder> emailContact) {
            return emailContact(EmailContact.builder().applyMutation(emailContact).build());
        }
    }

    static final class BuilderImpl extends NotificationsContactsResponse.BuilderImpl implements Builder {
        private EmailContact emailContact;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEmailContactResponse model) {
            super(model);
            emailContact(model.emailContact);
        }

        public final EmailContact.Builder getEmailContact() {
            return emailContact != null ? emailContact.toBuilder() : null;
        }

        public final void setEmailContact(EmailContact.BuilderImpl emailContact) {
            this.emailContact = emailContact != null ? emailContact.build() : null;
        }

        @Override
        public final Builder emailContact(EmailContact emailContact) {
            this.emailContact = emailContact;
            return this;
        }

        @Override
        public GetEmailContactResponse build() {
            return new GetEmailContactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
