/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLinkRequest extends OamRequest implements
        ToCopyableBuilder<CreateLinkRequest.Builder, CreateLinkRequest> {
    private static final SdkField<String> LABEL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelTemplate").getter(getter(CreateLinkRequest::labelTemplate)).setter(setter(Builder::labelTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelTemplate").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(CreateLinkRequest::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SINK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkIdentifier").getter(getter(CreateLinkRequest::sinkIdentifier))
            .setter(setter(Builder::sinkIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkIdentifier").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateLinkRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_TEMPLATE_FIELD,
            RESOURCE_TYPES_FIELD, SINK_IDENTIFIER_FIELD, TAGS_FIELD));

    private final String labelTemplate;

    private final List<String> resourceTypes;

    private final String sinkIdentifier;

    private final Map<String, String> tags;

    private CreateLinkRequest(BuilderImpl builder) {
        super(builder);
        this.labelTemplate = builder.labelTemplate;
        this.resourceTypes = builder.resourceTypes;
        this.sinkIdentifier = builder.sinkIdentifier;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specify a friendly human-readable name to use to identify this source account when you are viewing data from it
     * in the monitoring account.
     * </p>
     * <p>
     * You can use a custom label or use the following variables:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>$AccountName</code> is the name of the account
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>$AccountEmail</code> is the globally unique email address of the account
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>$AccountEmailNoDomain</code> is the email address of the account without the domain name
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify a friendly human-readable name to use to identify this source account when you are viewing data
     *         from it in the monitoring account.</p>
     *         <p>
     *         You can use a custom label or use the following variables:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>$AccountName</code> is the name of the account
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>$AccountEmail</code> is the globally unique email address of the account
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>$AccountEmailNoDomain</code> is the email address of the account without the domain name
     *         </p>
     *         </li>
     */
    public final String labelTemplate() {
        return labelTemplate;
    }

    /**
     * <p>
     * An array of strings that define which types of data that the source account shares with the monitoring account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return An array of strings that define which types of data that the source account shares with the monitoring
     *         account.
     */
    public final List<ResourceType> resourceTypes() {
        return ResourceTypesInputCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that define which types of data that the source account shares with the monitoring account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return An array of strings that define which types of data that the source account shares with the monitoring
     *         account.
     */
    public final List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    /**
     * <p>
     * The ARN of the sink to use to create this link. You can use <a
     * href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html">ListSinks</a> to find the ARNs of
     * sinks.
     * </p>
     * <p>
     * For more information about sinks, see <a
     * href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html">CreateSink</a>.
     * </p>
     * 
     * @return The ARN of the sink to use to create this link. You can use <a
     *         href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html">ListSinks</a> to find the
     *         ARNs of sinks.</p>
     *         <p>
     *         For more information about sinks, see <a
     *         href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html">CreateSink</a>.
     */
    public final String sinkIdentifier() {
        return sinkIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the link.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * For more information about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Assigns one or more tags (key-value pairs) to the link. </p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user permissions
     *         by granting a user permission to access or change only resources with certain tag values.
     *         </p>
     *         <p>
     *         For more information about using tags to control access, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     *         Services resources using tags</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sinkIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLinkRequest)) {
            return false;
        }
        CreateLinkRequest other = (CreateLinkRequest) obj;
        return Objects.equals(labelTemplate(), other.labelTemplate()) && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings())
                && Objects.equals(sinkIdentifier(), other.sinkIdentifier()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLinkRequest").add("LabelTemplate", labelTemplate())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypesAsStrings() : null)
                .add("SinkIdentifier", sinkIdentifier()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelTemplate":
            return Optional.ofNullable(clazz.cast(labelTemplate()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        case "SinkIdentifier":
            return Optional.ofNullable(clazz.cast(sinkIdentifier()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLinkRequest, T> g) {
        return obj -> g.apply((CreateLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLinkRequest> {
        /**
         * <p>
         * Specify a friendly human-readable name to use to identify this source account when you are viewing data from
         * it in the monitoring account.
         * </p>
         * <p>
         * You can use a custom label or use the following variables:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>$AccountName</code> is the name of the account
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>$AccountEmail</code> is the globally unique email address of the account
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>$AccountEmailNoDomain</code> is the email address of the account without the domain name
         * </p>
         * </li>
         * </ul>
         * 
         * @param labelTemplate
         *        Specify a friendly human-readable name to use to identify this source account when you are viewing
         *        data from it in the monitoring account.</p>
         *        <p>
         *        You can use a custom label or use the following variables:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>$AccountName</code> is the name of the account
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>$AccountEmail</code> is the globally unique email address of the account
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>$AccountEmailNoDomain</code> is the email address of the account without the domain name
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelTemplate(String labelTemplate);

        /**
         * <p>
         * An array of strings that define which types of data that the source account shares with the monitoring
         * account.
         * </p>
         * 
         * @param resourceTypes
         *        An array of strings that define which types of data that the source account shares with the monitoring
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * An array of strings that define which types of data that the source account shares with the monitoring
         * account.
         * </p>
         * 
         * @param resourceTypes
         *        An array of strings that define which types of data that the source account shares with the monitoring
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * An array of strings that define which types of data that the source account shares with the monitoring
         * account.
         * </p>
         * 
         * @param resourceTypes
         *        An array of strings that define which types of data that the source account shares with the monitoring
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ResourceType> resourceTypes);

        /**
         * <p>
         * An array of strings that define which types of data that the source account shares with the monitoring
         * account.
         * </p>
         * 
         * @param resourceTypes
         *        An array of strings that define which types of data that the source account shares with the monitoring
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ResourceType... resourceTypes);

        /**
         * <p>
         * The ARN of the sink to use to create this link. You can use <a
         * href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html">ListSinks</a> to find the ARNs
         * of sinks.
         * </p>
         * <p>
         * For more information about sinks, see <a
         * href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html">CreateSink</a>.
         * </p>
         * 
         * @param sinkIdentifier
         *        The ARN of the sink to use to create this link. You can use <a
         *        href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html">ListSinks</a> to find
         *        the ARNs of sinks.</p>
         *        <p>
         *        For more information about sinks, see <a
         *        href="https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html">CreateSink</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkIdentifier(String sinkIdentifier);

        /**
         * <p>
         * Assigns one or more tags (key-value pairs) to the link.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * <p>
         * For more information about using tags to control access, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
         * Services resources using tags</a>.
         * </p>
         * 
         * @param tags
         *        Assigns one or more tags (key-value pairs) to the link. </p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions by granting a user permission to access or change only resources with certain tag values.
         *        </p>
         *        <p>
         *        For more information about using tags to control access, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon
         *        Web Services resources using tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OamRequest.BuilderImpl implements Builder {
        private String labelTemplate;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String sinkIdentifier;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLinkRequest model) {
            super(model);
            labelTemplate(model.labelTemplate);
            resourceTypesWithStrings(model.resourceTypes);
            sinkIdentifier(model.sinkIdentifier);
            tags(model.tags);
        }

        public final String getLabelTemplate() {
            return labelTemplate;
        }

        public final void setLabelTemplate(String labelTemplate) {
            this.labelTemplate = labelTemplate;
        }

        @Override
        public final Builder labelTemplate(String labelTemplate) {
            this.labelTemplate = labelTemplate;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getSinkIdentifier() {
            return sinkIdentifier;
        }

        public final void setSinkIdentifier(String sinkIdentifier) {
            this.sinkIdentifier = sinkIdentifier;
        }

        @Override
        public final Builder sinkIdentifier(String sinkIdentifier) {
            this.sinkIdentifier = sinkIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapInputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapInputCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLinkRequest build() {
            return new CreateLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
