/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.oam.DefaultOamClientBuilder;
import software.amazon.awssdk.services.oam.OamClientBuilder;
import software.amazon.awssdk.services.oam.OamServiceClientConfiguration;
import software.amazon.awssdk.services.oam.model.ConflictException;
import software.amazon.awssdk.services.oam.model.CreateLinkRequest;
import software.amazon.awssdk.services.oam.model.CreateLinkResponse;
import software.amazon.awssdk.services.oam.model.CreateSinkRequest;
import software.amazon.awssdk.services.oam.model.CreateSinkResponse;
import software.amazon.awssdk.services.oam.model.DeleteLinkRequest;
import software.amazon.awssdk.services.oam.model.DeleteLinkResponse;
import software.amazon.awssdk.services.oam.model.DeleteSinkRequest;
import software.amazon.awssdk.services.oam.model.DeleteSinkResponse;
import software.amazon.awssdk.services.oam.model.GetLinkRequest;
import software.amazon.awssdk.services.oam.model.GetLinkResponse;
import software.amazon.awssdk.services.oam.model.GetSinkPolicyRequest;
import software.amazon.awssdk.services.oam.model.GetSinkPolicyResponse;
import software.amazon.awssdk.services.oam.model.GetSinkRequest;
import software.amazon.awssdk.services.oam.model.GetSinkResponse;
import software.amazon.awssdk.services.oam.model.InternalServiceException;
import software.amazon.awssdk.services.oam.model.InvalidParameterException;
import software.amazon.awssdk.services.oam.model.ListAttachedLinksRequest;
import software.amazon.awssdk.services.oam.model.ListAttachedLinksResponse;
import software.amazon.awssdk.services.oam.model.ListLinksRequest;
import software.amazon.awssdk.services.oam.model.ListLinksResponse;
import software.amazon.awssdk.services.oam.model.ListSinksRequest;
import software.amazon.awssdk.services.oam.model.ListSinksResponse;
import software.amazon.awssdk.services.oam.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.oam.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.oam.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.oam.model.OamException;
import software.amazon.awssdk.services.oam.model.PutSinkPolicyRequest;
import software.amazon.awssdk.services.oam.model.PutSinkPolicyResponse;
import software.amazon.awssdk.services.oam.model.ResourceNotFoundException;
import software.amazon.awssdk.services.oam.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.oam.model.TagResourceRequest;
import software.amazon.awssdk.services.oam.model.TagResourceResponse;
import software.amazon.awssdk.services.oam.model.TooManyTagsException;
import software.amazon.awssdk.services.oam.model.UntagResourceRequest;
import software.amazon.awssdk.services.oam.model.UntagResourceResponse;
import software.amazon.awssdk.services.oam.model.UpdateLinkRequest;
import software.amazon.awssdk.services.oam.model.UpdateLinkResponse;
import software.amazon.awssdk.services.oam.model.ValidationException;
import software.amazon.awssdk.services.oam.paginators.ListAttachedLinksIterable;
import software.amazon.awssdk.services.oam.paginators.ListLinksIterable;
import software.amazon.awssdk.services.oam.paginators.ListSinksIterable;

@SdkPublicApi
@ThreadSafe
public interface OamClient
extends AwsClient {
    public static final String SERVICE_NAME = "oam";
    public static final String SERVICE_METADATA_ID = "oam";

    default public CreateLinkResponse createLink(CreateLinkRequest createLinkRequest) throws InternalServiceException, ConflictException, MissingRequiredParameterException, ServiceQuotaExceededException, InvalidParameterException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public CreateLinkResponse createLink(Consumer<CreateLinkRequest.Builder> createLinkRequest) throws InternalServiceException, ConflictException, MissingRequiredParameterException, ServiceQuotaExceededException, InvalidParameterException, AwsServiceException, SdkClientException, OamException {
        return this.createLink((CreateLinkRequest)((Object)((CreateLinkRequest.Builder)CreateLinkRequest.builder().applyMutation(createLinkRequest)).build()));
    }

    default public CreateSinkResponse createSink(CreateSinkRequest createSinkRequest) throws InternalServiceException, ConflictException, MissingRequiredParameterException, ServiceQuotaExceededException, InvalidParameterException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public CreateSinkResponse createSink(Consumer<CreateSinkRequest.Builder> createSinkRequest) throws InternalServiceException, ConflictException, MissingRequiredParameterException, ServiceQuotaExceededException, InvalidParameterException, AwsServiceException, SdkClientException, OamException {
        return this.createSink((CreateSinkRequest)((Object)((CreateSinkRequest.Builder)CreateSinkRequest.builder().applyMutation(createSinkRequest)).build()));
    }

    default public DeleteLinkResponse deleteLink(DeleteLinkRequest deleteLinkRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public DeleteLinkResponse deleteLink(Consumer<DeleteLinkRequest.Builder> deleteLinkRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.deleteLink((DeleteLinkRequest)((Object)((DeleteLinkRequest.Builder)DeleteLinkRequest.builder().applyMutation(deleteLinkRequest)).build()));
    }

    default public DeleteSinkResponse deleteSink(DeleteSinkRequest deleteSinkRequest) throws InternalServiceException, ConflictException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public DeleteSinkResponse deleteSink(Consumer<DeleteSinkRequest.Builder> deleteSinkRequest) throws InternalServiceException, ConflictException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.deleteSink((DeleteSinkRequest)((Object)((DeleteSinkRequest.Builder)DeleteSinkRequest.builder().applyMutation(deleteSinkRequest)).build()));
    }

    default public GetLinkResponse getLink(GetLinkRequest getLinkRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public GetLinkResponse getLink(Consumer<GetLinkRequest.Builder> getLinkRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.getLink((GetLinkRequest)((Object)((GetLinkRequest.Builder)GetLinkRequest.builder().applyMutation(getLinkRequest)).build()));
    }

    default public GetSinkResponse getSink(GetSinkRequest getSinkRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public GetSinkResponse getSink(Consumer<GetSinkRequest.Builder> getSinkRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.getSink((GetSinkRequest)((Object)((GetSinkRequest.Builder)GetSinkRequest.builder().applyMutation(getSinkRequest)).build()));
    }

    default public GetSinkPolicyResponse getSinkPolicy(GetSinkPolicyRequest getSinkPolicyRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public GetSinkPolicyResponse getSinkPolicy(Consumer<GetSinkPolicyRequest.Builder> getSinkPolicyRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.getSinkPolicy((GetSinkPolicyRequest)((Object)((GetSinkPolicyRequest.Builder)GetSinkPolicyRequest.builder().applyMutation(getSinkPolicyRequest)).build()));
    }

    default public ListAttachedLinksResponse listAttachedLinks(ListAttachedLinksRequest listAttachedLinksRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public ListAttachedLinksResponse listAttachedLinks(Consumer<ListAttachedLinksRequest.Builder> listAttachedLinksRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.listAttachedLinks((ListAttachedLinksRequest)((Object)((ListAttachedLinksRequest.Builder)ListAttachedLinksRequest.builder().applyMutation(listAttachedLinksRequest)).build()));
    }

    default public ListAttachedLinksIterable listAttachedLinksPaginator(ListAttachedLinksRequest listAttachedLinksRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public ListAttachedLinksIterable listAttachedLinksPaginator(Consumer<ListAttachedLinksRequest.Builder> listAttachedLinksRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.listAttachedLinksPaginator((ListAttachedLinksRequest)((Object)((ListAttachedLinksRequest.Builder)ListAttachedLinksRequest.builder().applyMutation(listAttachedLinksRequest)).build()));
    }

    default public ListLinksResponse listLinks(ListLinksRequest listLinksRequest) throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public ListLinksResponse listLinks(Consumer<ListLinksRequest.Builder> listLinksRequest) throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.listLinks((ListLinksRequest)((Object)((ListLinksRequest.Builder)ListLinksRequest.builder().applyMutation(listLinksRequest)).build()));
    }

    default public ListLinksIterable listLinksPaginator(ListLinksRequest listLinksRequest) throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public ListLinksIterable listLinksPaginator(Consumer<ListLinksRequest.Builder> listLinksRequest) throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.listLinksPaginator((ListLinksRequest)((Object)((ListLinksRequest.Builder)ListLinksRequest.builder().applyMutation(listLinksRequest)).build()));
    }

    default public ListSinksResponse listSinks(ListSinksRequest listSinksRequest) throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public ListSinksResponse listSinks(Consumer<ListSinksRequest.Builder> listSinksRequest) throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.listSinks((ListSinksRequest)((Object)((ListSinksRequest.Builder)ListSinksRequest.builder().applyMutation(listSinksRequest)).build()));
    }

    default public ListSinksIterable listSinksPaginator(ListSinksRequest listSinksRequest) throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public ListSinksIterable listSinksPaginator(Consumer<ListSinksRequest.Builder> listSinksRequest) throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.listSinksPaginator((ListSinksRequest)((Object)((ListSinksRequest.Builder)ListSinksRequest.builder().applyMutation(listSinksRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public PutSinkPolicyResponse putSinkPolicy(PutSinkPolicyRequest putSinkPolicyRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public PutSinkPolicyResponse putSinkPolicy(Consumer<PutSinkPolicyRequest.Builder> putSinkPolicyRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.putSinkPolicy((PutSinkPolicyRequest)((Object)((PutSinkPolicyRequest.Builder)PutSinkPolicyRequest.builder().applyMutation(putSinkPolicyRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, TooManyTagsException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException, TooManyTagsException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateLinkResponse updateLink(UpdateLinkRequest updateLinkRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        throw new UnsupportedOperationException();
    }

    default public UpdateLinkResponse updateLink(Consumer<UpdateLinkRequest.Builder> updateLinkRequest) throws InternalServiceException, MissingRequiredParameterException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, OamException {
        return this.updateLink((UpdateLinkRequest)((Object)((UpdateLinkRequest.Builder)UpdateLinkRequest.builder().applyMutation(updateLinkRequest)).build()));
    }

    public static OamClient create() {
        return (OamClient)OamClient.builder().build();
    }

    public static OamClientBuilder builder() {
        return new DefaultOamClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"oam");
    }

    default public OamServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

