/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.oam.model.LinkConfiguration;
import software.amazon.awssdk.services.oam.model.OamResponse;
import software.amazon.awssdk.services.oam.model.ResourceTypesOutputCopier;
import software.amazon.awssdk.services.oam.model.TagMapOutputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLinkResponse
extends OamResponse
implements ToCopyableBuilder<Builder, CreateLinkResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateLinkResponse.getter(CreateLinkResponse::arn)).setter(CreateLinkResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateLinkResponse.getter(CreateLinkResponse::id)).setter(CreateLinkResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(CreateLinkResponse.getter(CreateLinkResponse::label)).setter(CreateLinkResponse.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<String> LABEL_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelTemplate").getter(CreateLinkResponse.getter(CreateLinkResponse::labelTemplate)).setter(CreateLinkResponse.setter(Builder::labelTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelTemplate").build()}).build();
    private static final SdkField<LinkConfiguration> LINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinkConfiguration").getter(CreateLinkResponse.getter(CreateLinkResponse::linkConfiguration)).setter(CreateLinkResponse.setter(Builder::linkConfiguration)).constructor(LinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkConfiguration").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(CreateLinkResponse.getter(CreateLinkResponse::resourceTypes)).setter(CreateLinkResponse.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkArn").getter(CreateLinkResponse.getter(CreateLinkResponse::sinkArn)).setter(CreateLinkResponse.setter(Builder::sinkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateLinkResponse.getter(CreateLinkResponse::tags)).setter(CreateLinkResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, LABEL_FIELD, LABEL_TEMPLATE_FIELD, LINK_CONFIGURATION_FIELD, RESOURCE_TYPES_FIELD, SINK_ARN_FIELD, TAGS_FIELD));
    private final String arn;
    private final String id;
    private final String label;
    private final String labelTemplate;
    private final LinkConfiguration linkConfiguration;
    private final List<String> resourceTypes;
    private final String sinkArn;
    private final Map<String, String> tags;

    private CreateLinkResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.label = builder.label;
        this.labelTemplate = builder.labelTemplate;
        this.linkConfiguration = builder.linkConfiguration;
        this.resourceTypes = builder.resourceTypes;
        this.sinkArn = builder.sinkArn;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String label() {
        return this.label;
    }

    public final String labelTemplate() {
        return this.labelTemplate;
    }

    public final LinkConfiguration linkConfiguration() {
        return this.linkConfiguration;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public final String sinkArn() {
        return this.sinkArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLinkResponse)) {
            return false;
        }
        CreateLinkResponse other = (CreateLinkResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.labelTemplate(), other.labelTemplate()) && Objects.equals(this.linkConfiguration(), other.linkConfiguration()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.sinkArn(), other.sinkArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLinkResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Label", (Object)this.label()).add("LabelTemplate", (Object)this.labelTemplate()).add("LinkConfiguration", (Object)this.linkConfiguration()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("SinkArn", (Object)this.sinkArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "LabelTemplate": {
                return Optional.ofNullable(clazz.cast(this.labelTemplate()));
            }
            case "LinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.linkConfiguration()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "SinkArn": {
                return Optional.ofNullable(clazz.cast(this.sinkArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLinkResponse, T> g) {
        return obj -> g.apply((CreateLinkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OamResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String label;
        private String labelTemplate;
        private LinkConfiguration linkConfiguration;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String sinkArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLinkResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.label(model.label);
            this.labelTemplate(model.labelTemplate);
            this.linkConfiguration(model.linkConfiguration);
            this.resourceTypes(model.resourceTypes);
            this.sinkArn(model.sinkArn);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getLabelTemplate() {
            return this.labelTemplate;
        }

        public final void setLabelTemplate(String labelTemplate) {
            this.labelTemplate = labelTemplate;
        }

        @Override
        public final Builder labelTemplate(String labelTemplate) {
            this.labelTemplate = labelTemplate;
            return this;
        }

        public final LinkConfiguration.Builder getLinkConfiguration() {
            return this.linkConfiguration != null ? this.linkConfiguration.toBuilder() : null;
        }

        public final void setLinkConfiguration(LinkConfiguration.BuilderImpl linkConfiguration) {
            this.linkConfiguration = linkConfiguration != null ? linkConfiguration.build() : null;
        }

        @Override
        public final Builder linkConfiguration(LinkConfiguration linkConfiguration) {
            this.linkConfiguration = linkConfiguration;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getSinkArn() {
            return this.sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
            return this;
        }

        @Override
        public CreateLinkResponse build() {
            return new CreateLinkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLinkResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder label(String var1);

        public Builder labelTemplate(String var1);

        public Builder linkConfiguration(LinkConfiguration var1);

        default public Builder linkConfiguration(Consumer<LinkConfiguration.Builder> linkConfiguration) {
            return this.linkConfiguration((LinkConfiguration)((LinkConfiguration.Builder)LinkConfiguration.builder().applyMutation(linkConfiguration)).build());
        }

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder sinkArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

