/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLinkResponse extends OamResponse implements ToCopyableBuilder<GetLinkResponse.Builder, GetLinkResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetLinkResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetLinkResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(GetLinkResponse::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> LABEL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelTemplate").getter(getter(GetLinkResponse::labelTemplate)).setter(setter(Builder::labelTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelTemplate").build()).build();

    private static final SdkField<LinkConfiguration> LINK_CONFIGURATION_FIELD = SdkField
            .<LinkConfiguration> builder(MarshallingType.SDK_POJO).memberName("LinkConfiguration")
            .getter(getter(GetLinkResponse::linkConfiguration)).setter(setter(Builder::linkConfiguration))
            .constructor(LinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkConfiguration").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(GetLinkResponse::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SINK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkArn").getter(getter(GetLinkResponse::sinkArn)).setter(setter(Builder::sinkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetLinkResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            LABEL_FIELD, LABEL_TEMPLATE_FIELD, LINK_CONFIGURATION_FIELD, RESOURCE_TYPES_FIELD, SINK_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Arn", ARN_FIELD);
                    put("Id", ID_FIELD);
                    put("Label", LABEL_FIELD);
                    put("LabelTemplate", LABEL_TEMPLATE_FIELD);
                    put("LinkConfiguration", LINK_CONFIGURATION_FIELD);
                    put("ResourceTypes", RESOURCE_TYPES_FIELD);
                    put("SinkArn", SINK_ARN_FIELD);
                    put("Tags", TAGS_FIELD);
                }
            });

    private final String arn;

    private final String id;

    private final String label;

    private final String labelTemplate;

    private final LinkConfiguration linkConfiguration;

    private final List<String> resourceTypes;

    private final String sinkArn;

    private final Map<String, String> tags;

    private GetLinkResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.label = builder.label;
        this.labelTemplate = builder.labelTemplate;
        this.linkConfiguration = builder.linkConfiguration;
        this.resourceTypes = builder.resourceTypes;
        this.sinkArn = builder.sinkArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the link.
     * </p>
     * 
     * @return The ARN of the link.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The random ID string that Amazon Web Services generated as part of the link ARN.
     * </p>
     * 
     * @return The random ID string that Amazon Web Services generated as part of the link ARN.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The label that you assigned to this link, with the variables resolved to their actual values.
     * </p>
     * 
     * @return The label that you assigned to this link, with the variables resolved to their actual values.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * The exact label template that was specified when the link was created, with the template variables not resolved.
     * </p>
     * 
     * @return The exact label template that was specified when the link was created, with the template variables not
     *         resolved.
     */
    public final String labelTemplate() {
        return labelTemplate;
    }

    /**
     * <p>
     * This structure includes filters that specify which metric namespaces and which log groups are shared from the
     * source account to the monitoring account.
     * </p>
     * 
     * @return This structure includes filters that specify which metric namespaces and which log groups are shared from
     *         the source account to the monitoring account.
     */
    public final LinkConfiguration linkConfiguration() {
        return linkConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource types supported by this link.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The resource types supported by this link.
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The ARN of the sink that is used for this link.
     * </p>
     * 
     * @return The ARN of the sink that is used for this link.
     */
    public final String sinkArn() {
        return sinkArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the link.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the link.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(labelTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(linkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinkResponse)) {
            return false;
        }
        GetLinkResponse other = (GetLinkResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(label(), other.label())
                && Objects.equals(labelTemplate(), other.labelTemplate())
                && Objects.equals(linkConfiguration(), other.linkConfiguration())
                && hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && Objects.equals(sinkArn(), other.sinkArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLinkResponse").add("Arn", arn()).add("Id", id()).add("Label", label())
                .add("LabelTemplate", labelTemplate()).add("LinkConfiguration", linkConfiguration())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).add("SinkArn", sinkArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "LabelTemplate":
            return Optional.ofNullable(clazz.cast(labelTemplate()));
        case "LinkConfiguration":
            return Optional.ofNullable(clazz.cast(linkConfiguration()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "SinkArn":
            return Optional.ofNullable(clazz.cast(sinkArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLinkResponse, T> g) {
        return obj -> g.apply((GetLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLinkResponse> {
        /**
         * <p>
         * The ARN of the link.
         * </p>
         * 
         * @param arn
         *        The ARN of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The random ID string that Amazon Web Services generated as part of the link ARN.
         * </p>
         * 
         * @param id
         *        The random ID string that Amazon Web Services generated as part of the link ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The label that you assigned to this link, with the variables resolved to their actual values.
         * </p>
         * 
         * @param label
         *        The label that you assigned to this link, with the variables resolved to their actual values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The exact label template that was specified when the link was created, with the template variables not
         * resolved.
         * </p>
         * 
         * @param labelTemplate
         *        The exact label template that was specified when the link was created, with the template variables not
         *        resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelTemplate(String labelTemplate);

        /**
         * <p>
         * This structure includes filters that specify which metric namespaces and which log groups are shared from the
         * source account to the monitoring account.
         * </p>
         * 
         * @param linkConfiguration
         *        This structure includes filters that specify which metric namespaces and which log groups are shared
         *        from the source account to the monitoring account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkConfiguration(LinkConfiguration linkConfiguration);

        /**
         * <p>
         * This structure includes filters that specify which metric namespaces and which log groups are shared from the
         * source account to the monitoring account.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkConfiguration.Builder} avoiding the
         * need to create one manually via {@link LinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #linkConfiguration(LinkConfiguration)}.
         * 
         * @param linkConfiguration
         *        a consumer that will call methods on {@link LinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkConfiguration(LinkConfiguration)
         */
        default Builder linkConfiguration(Consumer<LinkConfiguration.Builder> linkConfiguration) {
            return linkConfiguration(LinkConfiguration.builder().applyMutation(linkConfiguration).build());
        }

        /**
         * <p>
         * The resource types supported by this link.
         * </p>
         * 
         * @param resourceTypes
         *        The resource types supported by this link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The resource types supported by this link.
         * </p>
         * 
         * @param resourceTypes
         *        The resource types supported by this link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The ARN of the sink that is used for this link.
         * </p>
         * 
         * @param sinkArn
         *        The ARN of the sink that is used for this link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkArn(String sinkArn);

        /**
         * <p>
         * The tags assigned to the link.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends OamResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String label;

        private String labelTemplate;

        private LinkConfiguration linkConfiguration;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String sinkArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinkResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            label(model.label);
            labelTemplate(model.labelTemplate);
            linkConfiguration(model.linkConfiguration);
            resourceTypes(model.resourceTypes);
            sinkArn(model.sinkArn);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getLabelTemplate() {
            return labelTemplate;
        }

        public final void setLabelTemplate(String labelTemplate) {
            this.labelTemplate = labelTemplate;
        }

        @Override
        public final Builder labelTemplate(String labelTemplate) {
            this.labelTemplate = labelTemplate;
            return this;
        }

        public final LinkConfiguration.Builder getLinkConfiguration() {
            return linkConfiguration != null ? linkConfiguration.toBuilder() : null;
        }

        public final void setLinkConfiguration(LinkConfiguration.BuilderImpl linkConfiguration) {
            this.linkConfiguration = linkConfiguration != null ? linkConfiguration.build() : null;
        }

        @Override
        public final Builder linkConfiguration(LinkConfiguration linkConfiguration) {
            this.linkConfiguration = linkConfiguration;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getSinkArn() {
            return sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
            return this;
        }

        @Override
        public GetLinkResponse build() {
            return new GetLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
