/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSinkPolicyResponse extends OamResponse implements
        ToCopyableBuilder<PutSinkPolicyResponse.Builder, PutSinkPolicyResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(PutSinkPolicyResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<String> SINK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkArn").getter(getter(PutSinkPolicyResponse::sinkArn)).setter(setter(Builder::sinkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()).build();

    private static final SdkField<String> SINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SinkId")
            .getter(getter(PutSinkPolicyResponse::sinkId)).setter(setter(Builder::sinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, SINK_ARN_FIELD,
            SINK_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Policy", POLICY_FIELD);
                    put("SinkArn", SINK_ARN_FIELD);
                    put("SinkId", SINK_ID_FIELD);
                }
            });

    private final String policy;

    private final String sinkArn;

    private final String sinkId;

    private PutSinkPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.sinkArn = builder.sinkArn;
        this.sinkId = builder.sinkId;
    }

    /**
     * <p>
     * The policy that you specified.
     * </p>
     * 
     * @return The policy that you specified.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * The ARN of the sink.
     * </p>
     * 
     * @return The ARN of the sink.
     */
    public final String sinkArn() {
        return sinkArn;
    }

    /**
     * <p>
     * The random ID string that Amazon Web Services generated as part of the sink ARN.
     * </p>
     * 
     * @return The random ID string that Amazon Web Services generated as part of the sink ARN.
     */
    public final String sinkId() {
        return sinkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(sinkId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSinkPolicyResponse)) {
            return false;
        }
        PutSinkPolicyResponse other = (PutSinkPolicyResponse) obj;
        return Objects.equals(policy(), other.policy()) && Objects.equals(sinkArn(), other.sinkArn())
                && Objects.equals(sinkId(), other.sinkId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSinkPolicyResponse").add("Policy", policy()).add("SinkArn", sinkArn())
                .add("SinkId", sinkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "SinkArn":
            return Optional.ofNullable(clazz.cast(sinkArn()));
        case "SinkId":
            return Optional.ofNullable(clazz.cast(sinkId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutSinkPolicyResponse, T> g) {
        return obj -> g.apply((PutSinkPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OamResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSinkPolicyResponse> {
        /**
         * <p>
         * The policy that you specified.
         * </p>
         * 
         * @param policy
         *        The policy that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The ARN of the sink.
         * </p>
         * 
         * @param sinkArn
         *        The ARN of the sink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkArn(String sinkArn);

        /**
         * <p>
         * The random ID string that Amazon Web Services generated as part of the sink ARN.
         * </p>
         * 
         * @param sinkId
         *        The random ID string that Amazon Web Services generated as part of the sink ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkId(String sinkId);
    }

    static final class BuilderImpl extends OamResponse.BuilderImpl implements Builder {
        private String policy;

        private String sinkArn;

        private String sinkId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSinkPolicyResponse model) {
            super(model);
            policy(model.policy);
            sinkArn(model.sinkArn);
            sinkId(model.sinkId);
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getSinkArn() {
            return sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final String getSinkId() {
            return sinkId;
        }

        public final void setSinkId(String sinkId) {
            this.sinkId = sinkId;
        }

        @Override
        public final Builder sinkId(String sinkId) {
            this.sinkId = sinkId;
            return this;
        }

        @Override
        public PutSinkPolicyResponse build() {
            return new PutSinkPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
