/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLinkRequest extends OamRequest implements
        ToCopyableBuilder<UpdateLinkRequest.Builder, UpdateLinkRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateLinkRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<LinkConfiguration> LINK_CONFIGURATION_FIELD = SdkField
            .<LinkConfiguration> builder(MarshallingType.SDK_POJO).memberName("LinkConfiguration")
            .getter(getter(UpdateLinkRequest::linkConfiguration)).setter(setter(Builder::linkConfiguration))
            .constructor(LinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkConfiguration").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(UpdateLinkRequest::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            LINK_CONFIGURATION_FIELD, RESOURCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final LinkConfiguration linkConfiguration;

    private final List<String> resourceTypes;

    private UpdateLinkRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.linkConfiguration = builder.linkConfiguration;
        this.resourceTypes = builder.resourceTypes;
    }

    /**
     * <p>
     * The ARN of the link that you want to update.
     * </p>
     * 
     * @return The ARN of the link that you want to update.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Use this structure to filter which metric namespaces and which log groups are to be shared from the source
     * account to the monitoring account.
     * </p>
     * 
     * @return Use this structure to filter which metric namespaces and which log groups are to be shared from the
     *         source account to the monitoring account.
     */
    public final LinkConfiguration linkConfiguration() {
        return linkConfiguration;
    }

    /**
     * <p>
     * An array of strings that define which types of data that the source account will send to the monitoring account.
     * </p>
     * <p>
     * Your input here replaces the current set of data types that are shared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return An array of strings that define which types of data that the source account will send to the monitoring
     *         account.</p>
     *         <p>
     *         Your input here replaces the current set of data types that are shared.
     */
    public final List<ResourceType> resourceTypes() {
        return ResourceTypesInputCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that define which types of data that the source account will send to the monitoring account.
     * </p>
     * <p>
     * Your input here replaces the current set of data types that are shared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return An array of strings that define which types of data that the source account will send to the monitoring
     *         account.</p>
     *         <p>
     *         Your input here replaces the current set of data types that are shared.
     */
    public final List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(linkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkRequest)) {
            return false;
        }
        UpdateLinkRequest other = (UpdateLinkRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(linkConfiguration(), other.linkConfiguration())
                && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLinkRequest").add("Identifier", identifier())
                .add("LinkConfiguration", linkConfiguration())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "LinkConfiguration":
            return Optional.ofNullable(clazz.cast(linkConfiguration()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("LinkConfiguration", LINK_CONFIGURATION_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLinkRequest, T> g) {
        return obj -> g.apply((UpdateLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLinkRequest> {
        /**
         * <p>
         * The ARN of the link that you want to update.
         * </p>
         * 
         * @param identifier
         *        The ARN of the link that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Use this structure to filter which metric namespaces and which log groups are to be shared from the source
         * account to the monitoring account.
         * </p>
         * 
         * @param linkConfiguration
         *        Use this structure to filter which metric namespaces and which log groups are to be shared from the
         *        source account to the monitoring account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkConfiguration(LinkConfiguration linkConfiguration);

        /**
         * <p>
         * Use this structure to filter which metric namespaces and which log groups are to be shared from the source
         * account to the monitoring account.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkConfiguration.Builder} avoiding the
         * need to create one manually via {@link LinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #linkConfiguration(LinkConfiguration)}.
         * 
         * @param linkConfiguration
         *        a consumer that will call methods on {@link LinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkConfiguration(LinkConfiguration)
         */
        default Builder linkConfiguration(Consumer<LinkConfiguration.Builder> linkConfiguration) {
            return linkConfiguration(LinkConfiguration.builder().applyMutation(linkConfiguration).build());
        }

        /**
         * <p>
         * An array of strings that define which types of data that the source account will send to the monitoring
         * account.
         * </p>
         * <p>
         * Your input here replaces the current set of data types that are shared.
         * </p>
         * 
         * @param resourceTypes
         *        An array of strings that define which types of data that the source account will send to the
         *        monitoring account.</p>
         *        <p>
         *        Your input here replaces the current set of data types that are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * An array of strings that define which types of data that the source account will send to the monitoring
         * account.
         * </p>
         * <p>
         * Your input here replaces the current set of data types that are shared.
         * </p>
         * 
         * @param resourceTypes
         *        An array of strings that define which types of data that the source account will send to the
         *        monitoring account.</p>
         *        <p>
         *        Your input here replaces the current set of data types that are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * An array of strings that define which types of data that the source account will send to the monitoring
         * account.
         * </p>
         * <p>
         * Your input here replaces the current set of data types that are shared.
         * </p>
         * 
         * @param resourceTypes
         *        An array of strings that define which types of data that the source account will send to the
         *        monitoring account.</p>
         *        <p>
         *        Your input here replaces the current set of data types that are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ResourceType> resourceTypes);

        /**
         * <p>
         * An array of strings that define which types of data that the source account will send to the monitoring
         * account.
         * </p>
         * <p>
         * Your input here replaces the current set of data types that are shared.
         * </p>
         * 
         * @param resourceTypes
         *        An array of strings that define which types of data that the source account will send to the
         *        monitoring account.</p>
         *        <p>
         *        Your input here replaces the current set of data types that are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ResourceType... resourceTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OamRequest.BuilderImpl implements Builder {
        private String identifier;

        private LinkConfiguration linkConfiguration;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLinkRequest model) {
            super(model);
            identifier(model.identifier);
            linkConfiguration(model.linkConfiguration);
            resourceTypesWithStrings(model.resourceTypes);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final LinkConfiguration.Builder getLinkConfiguration() {
            return linkConfiguration != null ? linkConfiguration.toBuilder() : null;
        }

        public final void setLinkConfiguration(LinkConfiguration.BuilderImpl linkConfiguration) {
            this.linkConfiguration = linkConfiguration != null ? linkConfiguration.build() : null;
        }

        @Override
        public final Builder linkConfiguration(LinkConfiguration linkConfiguration) {
            this.linkConfiguration = linkConfiguration;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypesInputCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLinkRequest build() {
            return new UpdateLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
