/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.oam.model.OamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSinkPolicyRequest
extends OamRequest
implements ToCopyableBuilder<Builder, PutSinkPolicyRequest> {
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(PutSinkPolicyRequest.getter(PutSinkPolicyRequest::policy)).setter(PutSinkPolicyRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<String> SINK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkIdentifier").getter(PutSinkPolicyRequest.getter(PutSinkPolicyRequest::sinkIdentifier)).setter(PutSinkPolicyRequest.setter(Builder::sinkIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, SINK_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutSinkPolicyRequest.memberNameToFieldInitializer();
    private final String policy;
    private final String sinkIdentifier;

    private PutSinkPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.sinkIdentifier = builder.sinkIdentifier;
    }

    public final String policy() {
        return this.policy;
    }

    public final String sinkIdentifier() {
        return this.sinkIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSinkPolicyRequest)) {
            return false;
        }
        PutSinkPolicyRequest other = (PutSinkPolicyRequest)((Object)obj);
        return Objects.equals(this.policy(), other.policy()) && Objects.equals(this.sinkIdentifier(), other.sinkIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"PutSinkPolicyRequest").add("Policy", (Object)this.policy()).add("SinkIdentifier", (Object)this.sinkIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "SinkIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sinkIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Policy", POLICY_FIELD);
        map.put("SinkIdentifier", SINK_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSinkPolicyRequest, T> g) {
        return obj -> g.apply((PutSinkPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OamRequest.BuilderImpl
    implements Builder {
        private String policy;
        private String sinkIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSinkPolicyRequest model) {
            super(model);
            this.policy(model.policy);
            this.sinkIdentifier(model.sinkIdentifier);
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getSinkIdentifier() {
            return this.sinkIdentifier;
        }

        public final void setSinkIdentifier(String sinkIdentifier) {
            this.sinkIdentifier = sinkIdentifier;
        }

        @Override
        public final Builder sinkIdentifier(String sinkIdentifier) {
            this.sinkIdentifier = sinkIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSinkPolicyRequest build() {
            return new PutSinkPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSinkPolicyRequest> {
        public Builder policy(String var1);

        public Builder sinkIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

