/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about one of this source account's links to a monitoring account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLinksItem implements SdkPojo, Serializable, ToCopyableBuilder<ListLinksItem.Builder, ListLinksItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListLinksItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ListLinksItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(ListLinksItem::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(ListLinksItem::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SINK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkArn").getter(getter(ListLinksItem::sinkArn)).setter(setter(Builder::sinkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            LABEL_FIELD, RESOURCE_TYPES_FIELD, SINK_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String label;

    private final List<String> resourceTypes;

    private final String sinkArn;

    private ListLinksItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.label = builder.label;
        this.resourceTypes = builder.resourceTypes;
        this.sinkArn = builder.sinkArn;
    }

    /**
     * <p>
     * The ARN of the link.
     * </p>
     * 
     * @return The ARN of the link.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The random ID string that Amazon Web Services generated as part of the link ARN.
     * </p>
     * 
     * @return The random ID string that Amazon Web Services generated as part of the link ARN.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The label that was assigned to this link at creation, with the variables resolved to their actual values.
     * </p>
     * 
     * @return The label that was assigned to this link at creation, with the variables resolved to their actual values.
     */
    public final String label() {
        return label;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource types supported by this link.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The resource types supported by this link.
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The ARN of the sink that this link is attached to.
     * </p>
     * 
     * @return The ARN of the sink that this link is attached to.
     */
    public final String sinkArn() {
        return sinkArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sinkArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLinksItem)) {
            return false;
        }
        ListLinksItem other = (ListLinksItem) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(label(), other.label())
                && hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes())
                && Objects.equals(sinkArn(), other.sinkArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLinksItem").add("Arn", arn()).add("Id", id()).add("Label", label())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).add("SinkArn", sinkArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "SinkArn":
            return Optional.ofNullable(clazz.cast(sinkArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("SinkArn", SINK_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLinksItem, T> g) {
        return obj -> g.apply((ListLinksItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListLinksItem> {
        /**
         * <p>
         * The ARN of the link.
         * </p>
         * 
         * @param arn
         *        The ARN of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The random ID string that Amazon Web Services generated as part of the link ARN.
         * </p>
         * 
         * @param id
         *        The random ID string that Amazon Web Services generated as part of the link ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The label that was assigned to this link at creation, with the variables resolved to their actual values.
         * </p>
         * 
         * @param label
         *        The label that was assigned to this link at creation, with the variables resolved to their actual
         *        values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The resource types supported by this link.
         * </p>
         * 
         * @param resourceTypes
         *        The resource types supported by this link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The resource types supported by this link.
         * </p>
         * 
         * @param resourceTypes
         *        The resource types supported by this link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The ARN of the sink that this link is attached to.
         * </p>
         * 
         * @param sinkArn
         *        The ARN of the sink that this link is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkArn(String sinkArn);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String label;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String sinkArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLinksItem model) {
            arn(model.arn);
            id(model.id);
            label(model.label);
            resourceTypes(model.resourceTypes);
            sinkArn(model.sinkArn);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getSinkArn() {
            return sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        @Override
        public ListLinksItem build() {
            return new ListLinksItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
