/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the <code>Filter</code> parameter which you can use to specify which log groups are to share
 * log events from this source account to the monitoring account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogGroupConfiguration.Builder, LogGroupConfiguration> {
    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Filter")
            .getter(getter(LogGroupConfiguration::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filter;

    private LogGroupConfiguration(BuilderImpl builder) {
        this.filter = builder.filter;
    }

    /**
     * <p>
     * Use this field to specify which log groups are to share their log events with the monitoring account. Use the
     * term <code>LogGroupName</code> and one or more of the following operands. Use single quotation marks (') around
     * log group names. The matching of log group names is case sensitive. Each filter has a limit of five conditional
     * operands. Conditional operands are <code>AND</code> and <code>OR</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>=</code> and <code>!=</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AND</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LIKE</code> and <code>NOT LIKE</code>. These can be used only as prefix searches. Include a <code>%</code>
     * at the end of the string that you want to search for and include.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN</code> and <code>NOT IN</code>, using parentheses <code>( )</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LogGroupName IN ('This-Log-Group', 'Other-Log-Group')</code> includes only the log groups with names
     * <code>This-Log-Group</code> and <code>Other-Log-Group</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2')</code> includes all log groups except the
     * log groups with names <code>Private-Log-Group</code> and <code>Private-Log-Group-2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'</code> includes all log groups that have
     * names that start with <code>aws/lambda/</code> or <code>AWSLogs</code>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you are updating a link that uses filters, you can specify <code>*</code> as the only value for the
     * <code>filter</code> parameter to delete the filter and share all log groups with the monitoring account.
     * </p>
     * </note>
     * 
     * @return Use this field to specify which log groups are to share their log events with the monitoring account. Use
     *         the term <code>LogGroupName</code> and one or more of the following operands. Use single quotation marks
     *         (') around log group names. The matching of log group names is case sensitive. Each filter has a limit of
     *         five conditional operands. Conditional operands are <code>AND</code> and <code>OR</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>=</code> and <code>!=</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AND</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LIKE</code> and <code>NOT LIKE</code>. These can be used only as prefix searches. Include a
     *         <code>%</code> at the end of the string that you want to search for and include.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN</code> and <code>NOT IN</code>, using parentheses <code>( )</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LogGroupName IN ('This-Log-Group', 'Other-Log-Group')</code> includes only the log groups with
     *         names <code>This-Log-Group</code> and <code>Other-Log-Group</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2')</code> includes all log groups
     *         except the log groups with names <code>Private-Log-Group</code> and <code>Private-Log-Group-2</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'</code> includes all log groups
     *         that have names that start with <code>aws/lambda/</code> or <code>AWSLogs</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you are updating a link that uses filters, you can specify <code>*</code> as the only value for the
     *         <code>filter</code> parameter to delete the filter and share all log groups with the monitoring account.
     *         </p>
     */
    public final String filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroupConfiguration)) {
            return false;
        }
        LogGroupConfiguration other = (LogGroupConfiguration) obj;
        return Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogGroupConfiguration").add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogGroupConfiguration, T> g) {
        return obj -> g.apply((LogGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogGroupConfiguration> {
        /**
         * <p>
         * Use this field to specify which log groups are to share their log events with the monitoring account. Use the
         * term <code>LogGroupName</code> and one or more of the following operands. Use single quotation marks (')
         * around log group names. The matching of log group names is case sensitive. Each filter has a limit of five
         * conditional operands. Conditional operands are <code>AND</code> and <code>OR</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>=</code> and <code>!=</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AND</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LIKE</code> and <code>NOT LIKE</code>. These can be used only as prefix searches. Include a
         * <code>%</code> at the end of the string that you want to search for and include.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN</code> and <code>NOT IN</code>, using parentheses <code>( )</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LogGroupName IN ('This-Log-Group', 'Other-Log-Group')</code> includes only the log groups with names
         * <code>This-Log-Group</code> and <code>Other-Log-Group</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2')</code> includes all log groups except
         * the log groups with names <code>Private-Log-Group</code> and <code>Private-Log-Group-2</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'</code> includes all log groups that
         * have names that start with <code>aws/lambda/</code> or <code>AWSLogs</code>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you are updating a link that uses filters, you can specify <code>*</code> as the only value for the
         * <code>filter</code> parameter to delete the filter and share all log groups with the monitoring account.
         * </p>
         * </note>
         * 
         * @param filter
         *        Use this field to specify which log groups are to share their log events with the monitoring account.
         *        Use the term <code>LogGroupName</code> and one or more of the following operands. Use single quotation
         *        marks (') around log group names. The matching of log group names is case sensitive. Each filter has a
         *        limit of five conditional operands. Conditional operands are <code>AND</code> and <code>OR</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>=</code> and <code>!=</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AND</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LIKE</code> and <code>NOT LIKE</code>. These can be used only as prefix searches. Include a
         *        <code>%</code> at the end of the string that you want to search for and include.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN</code> and <code>NOT IN</code>, using parentheses <code>( )</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LogGroupName IN ('This-Log-Group', 'Other-Log-Group')</code> includes only the log groups with
         *        names <code>This-Log-Group</code> and <code>Other-Log-Group</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2')</code> includes all log groups
         *        except the log groups with names <code>Private-Log-Group</code> and <code>Private-Log-Group-2</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'</code> includes all log groups
         *        that have names that start with <code>aws/lambda/</code> or <code>AWSLogs</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you are updating a link that uses filters, you can specify <code>*</code> as the only value for the
         *        <code>filter</code> parameter to delete the filter and share all log groups with the monitoring
         *        account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);
    }

    static final class BuilderImpl implements Builder {
        private String filter;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroupConfiguration model) {
            filter(model.filter);
        }

        public final String getFilter() {
            return filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public LogGroupConfiguration build() {
            return new LogGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
