/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSinkRequest extends OamRequest implements ToCopyableBuilder<GetSinkRequest.Builder, GetSinkRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetSinkRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<Boolean> INCLUDE_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeTags").getter(getter(GetSinkRequest::includeTags)).setter(setter(Builder::includeTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            INCLUDE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final Boolean includeTags;

    private GetSinkRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.includeTags = builder.includeTags;
    }

    /**
     * <p>
     * The ARN of the sink to retrieve information for.
     * </p>
     * 
     * @return The ARN of the sink to retrieve information for.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Specifies whether to include the tags associated with the sink in the response. When <code>IncludeTags</code> is
     * set to <code>true</code> and the caller has the required permission, <code>oam:ListTagsForResource</code>, the
     * API will return the tags for the specified resource. If the caller doesn't have the required permission,
     * <code>oam:ListTagsForResource</code>, the API will raise an exception.
     * </p>
     * <p>
     * The default value is <code>false</code>.
     * </p>
     * 
     * @return Specifies whether to include the tags associated with the sink in the response. When
     *         <code>IncludeTags</code> is set to <code>true</code> and the caller has the required permission,
     *         <code>oam:ListTagsForResource</code>, the API will return the tags for the specified resource. If the
     *         caller doesn't have the required permission, <code>oam:ListTagsForResource</code>, the API will raise an
     *         exception.</p>
     *         <p>
     *         The default value is <code>false</code>.
     */
    public final Boolean includeTags() {
        return includeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(includeTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSinkRequest)) {
            return false;
        }
        GetSinkRequest other = (GetSinkRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(includeTags(), other.includeTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSinkRequest").add("Identifier", identifier()).add("IncludeTags", includeTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "IncludeTags":
            return Optional.ofNullable(clazz.cast(includeTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("IncludeTags", INCLUDE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSinkRequest, T> g) {
        return obj -> g.apply((GetSinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSinkRequest> {
        /**
         * <p>
         * The ARN of the sink to retrieve information for.
         * </p>
         * 
         * @param identifier
         *        The ARN of the sink to retrieve information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Specifies whether to include the tags associated with the sink in the response. When <code>IncludeTags</code>
         * is set to <code>true</code> and the caller has the required permission, <code>oam:ListTagsForResource</code>,
         * the API will return the tags for the specified resource. If the caller doesn't have the required permission,
         * <code>oam:ListTagsForResource</code>, the API will raise an exception.
         * </p>
         * <p>
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param includeTags
         *        Specifies whether to include the tags associated with the sink in the response. When
         *        <code>IncludeTags</code> is set to <code>true</code> and the caller has the required permission,
         *        <code>oam:ListTagsForResource</code>, the API will return the tags for the specified resource. If the
         *        caller doesn't have the required permission, <code>oam:ListTagsForResource</code>, the API will raise
         *        an exception.</p>
         *        <p>
         *        The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTags(Boolean includeTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OamRequest.BuilderImpl implements Builder {
        private String identifier;

        private Boolean includeTags;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSinkRequest model) {
            super(model);
            identifier(model.identifier);
            includeTags(model.includeTags);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Boolean getIncludeTags() {
            return includeTags;
        }

        public final void setIncludeTags(Boolean includeTags) {
            this.includeTags = includeTags;
        }

        @Override
        public final Builder includeTags(Boolean includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSinkRequest build() {
            return new GetSinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
