/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this structure to optionally create filters that specify that only some metric namespaces or log groups are to be
 * shared from the source account to the monitoring account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LinkConfiguration.Builder, LinkConfiguration> {
    private static final SdkField<LogGroupConfiguration> LOG_GROUP_CONFIGURATION_FIELD = SdkField
            .<LogGroupConfiguration> builder(MarshallingType.SDK_POJO).memberName("LogGroupConfiguration")
            .getter(getter(LinkConfiguration::logGroupConfiguration)).setter(setter(Builder::logGroupConfiguration))
            .constructor(LogGroupConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupConfiguration").build())
            .build();

    private static final SdkField<MetricConfiguration> METRIC_CONFIGURATION_FIELD = SdkField
            .<MetricConfiguration> builder(MarshallingType.SDK_POJO).memberName("MetricConfiguration")
            .getter(getter(LinkConfiguration::metricConfiguration)).setter(setter(Builder::metricConfiguration))
            .constructor(MetricConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_CONFIGURATION_FIELD,
            METRIC_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LogGroupConfiguration logGroupConfiguration;

    private final MetricConfiguration metricConfiguration;

    private LinkConfiguration(BuilderImpl builder) {
        this.logGroupConfiguration = builder.logGroupConfiguration;
        this.metricConfiguration = builder.metricConfiguration;
    }

    /**
     * <p>
     * Use this structure to filter which log groups are to send log events from the source account to the monitoring
     * account.
     * </p>
     * 
     * @return Use this structure to filter which log groups are to send log events from the source account to the
     *         monitoring account.
     */
    public final LogGroupConfiguration logGroupConfiguration() {
        return logGroupConfiguration;
    }

    /**
     * <p>
     * Use this structure to filter which metric namespaces are to be shared from the source account to the monitoring
     * account.
     * </p>
     * 
     * @return Use this structure to filter which metric namespaces are to be shared from the source account to the
     *         monitoring account.
     */
    public final MetricConfiguration metricConfiguration() {
        return metricConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(metricConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkConfiguration)) {
            return false;
        }
        LinkConfiguration other = (LinkConfiguration) obj;
        return Objects.equals(logGroupConfiguration(), other.logGroupConfiguration())
                && Objects.equals(metricConfiguration(), other.metricConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinkConfiguration").add("LogGroupConfiguration", logGroupConfiguration())
                .add("MetricConfiguration", metricConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogGroupConfiguration":
            return Optional.ofNullable(clazz.cast(logGroupConfiguration()));
        case "MetricConfiguration":
            return Optional.ofNullable(clazz.cast(metricConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogGroupConfiguration", LOG_GROUP_CONFIGURATION_FIELD);
        map.put("MetricConfiguration", METRIC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkConfiguration, T> g) {
        return obj -> g.apply((LinkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkConfiguration> {
        /**
         * <p>
         * Use this structure to filter which log groups are to send log events from the source account to the
         * monitoring account.
         * </p>
         * 
         * @param logGroupConfiguration
         *        Use this structure to filter which log groups are to send log events from the source account to the
         *        monitoring account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupConfiguration(LogGroupConfiguration logGroupConfiguration);

        /**
         * <p>
         * Use this structure to filter which log groups are to send log events from the source account to the
         * monitoring account.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogGroupConfiguration.Builder} avoiding
         * the need to create one manually via {@link LogGroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogGroupConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #logGroupConfiguration(LogGroupConfiguration)}.
         * 
         * @param logGroupConfiguration
         *        a consumer that will call methods on {@link LogGroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logGroupConfiguration(LogGroupConfiguration)
         */
        default Builder logGroupConfiguration(Consumer<LogGroupConfiguration.Builder> logGroupConfiguration) {
            return logGroupConfiguration(LogGroupConfiguration.builder().applyMutation(logGroupConfiguration).build());
        }

        /**
         * <p>
         * Use this structure to filter which metric namespaces are to be shared from the source account to the
         * monitoring account.
         * </p>
         * 
         * @param metricConfiguration
         *        Use this structure to filter which metric namespaces are to be shared from the source account to the
         *        monitoring account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricConfiguration(MetricConfiguration metricConfiguration);

        /**
         * <p>
         * Use this structure to filter which metric namespaces are to be shared from the source account to the
         * monitoring account.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricConfiguration.Builder} avoiding the
         * need to create one manually via {@link MetricConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #metricConfiguration(MetricConfiguration)}.
         * 
         * @param metricConfiguration
         *        a consumer that will call methods on {@link MetricConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricConfiguration(MetricConfiguration)
         */
        default Builder metricConfiguration(Consumer<MetricConfiguration.Builder> metricConfiguration) {
            return metricConfiguration(MetricConfiguration.builder().applyMutation(metricConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LogGroupConfiguration logGroupConfiguration;

        private MetricConfiguration metricConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkConfiguration model) {
            logGroupConfiguration(model.logGroupConfiguration);
            metricConfiguration(model.metricConfiguration);
        }

        public final LogGroupConfiguration.Builder getLogGroupConfiguration() {
            return logGroupConfiguration != null ? logGroupConfiguration.toBuilder() : null;
        }

        public final void setLogGroupConfiguration(LogGroupConfiguration.BuilderImpl logGroupConfiguration) {
            this.logGroupConfiguration = logGroupConfiguration != null ? logGroupConfiguration.build() : null;
        }

        @Override
        public final Builder logGroupConfiguration(LogGroupConfiguration logGroupConfiguration) {
            this.logGroupConfiguration = logGroupConfiguration;
            return this;
        }

        public final MetricConfiguration.Builder getMetricConfiguration() {
            return metricConfiguration != null ? metricConfiguration.toBuilder() : null;
        }

        public final void setMetricConfiguration(MetricConfiguration.BuilderImpl metricConfiguration) {
            this.metricConfiguration = metricConfiguration != null ? metricConfiguration.build() : null;
        }

        @Override
        public final Builder metricConfiguration(MetricConfiguration metricConfiguration) {
            this.metricConfiguration = metricConfiguration;
            return this;
        }

        @Override
        public LinkConfiguration build() {
            return new LinkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
