/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.oam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttachedLinksResponse extends OamResponse implements
        ToCopyableBuilder<ListAttachedLinksResponse.Builder, ListAttachedLinksResponse> {
    private static final SdkField<List<ListAttachedLinksItem>> ITEMS_FIELD = SdkField
            .<List<ListAttachedLinksItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(ListAttachedLinksResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListAttachedLinksItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListAttachedLinksItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAttachedLinksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ListAttachedLinksItem> items;

    private final String nextToken;

    private ListAttachedLinksResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contain the information about the attached links.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return An array of structures that contain the information about the attached links.
     */
    public final List<ListAttachedLinksItem> items() {
        return items;
    }

    /**
     * <p>
     * The token to use when requesting the next set of links.
     * </p>
     * 
     * @return The token to use when requesting the next set of links.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedLinksResponse)) {
            return false;
        }
        ListAttachedLinksResponse other = (ListAttachedLinksResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAttachedLinksResponse").add("Items", hasItems() ? items() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Items", ITEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAttachedLinksResponse, T> g) {
        return obj -> g.apply((ListAttachedLinksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAttachedLinksResponse> {
        /**
         * <p>
         * An array of structures that contain the information about the attached links.
         * </p>
         * 
         * @param items
         *        An array of structures that contain the information about the attached links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ListAttachedLinksItem> items);

        /**
         * <p>
         * An array of structures that contain the information about the attached links.
         * </p>
         * 
         * @param items
         *        An array of structures that contain the information about the attached links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ListAttachedLinksItem... items);

        /**
         * <p>
         * An array of structures that contain the information about the attached links.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.oam.model.ListAttachedLinksItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.oam.model.ListAttachedLinksItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.oam.model.ListAttachedLinksItem.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<ListAttachedLinksItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.oam.model.ListAttachedLinksItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<ListAttachedLinksItem>)
         */
        Builder items(Consumer<ListAttachedLinksItem.Builder>... items);

        /**
         * <p>
         * The token to use when requesting the next set of links.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OamResponse.BuilderImpl implements Builder {
        private List<ListAttachedLinksItem> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedLinksResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
        }

        public final List<ListAttachedLinksItem.Builder> getItems() {
            List<ListAttachedLinksItem.Builder> result = ListAttachedLinksItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ListAttachedLinksItem.BuilderImpl> items) {
            this.items = ListAttachedLinksItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ListAttachedLinksItem> items) {
            this.items = ListAttachedLinksItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ListAttachedLinksItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ListAttachedLinksItem.Builder>... items) {
            items(Stream.of(items).map(c -> ListAttachedLinksItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAttachedLinksResponse build() {
            return new ListAttachedLinksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
