/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scheduling details for the maintenance window. Patching and system updates take place during the maintenance
 * window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindow implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceWindow.Builder, MaintenanceWindow> {
    private static final SdkField<Integer> CUSTOM_ACTION_TIMEOUT_IN_MINS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("customActionTimeoutInMins")
            .getter(getter(MaintenanceWindow::customActionTimeoutInMins)).setter(setter(Builder::customActionTimeoutInMins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customActionTimeoutInMins").build())
            .build();

    private static final SdkField<List<DayOfWeek>> DAYS_OF_WEEK_FIELD = SdkField
            .<List<DayOfWeek>> builder(MarshallingType.LIST)
            .memberName("daysOfWeek")
            .getter(getter(MaintenanceWindow::daysOfWeek))
            .setter(setter(Builder::daysOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("daysOfWeek").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DayOfWeek> builder(MarshallingType.SDK_POJO)
                                            .constructor(DayOfWeek::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> HOURS_OF_DAY_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("hoursOfDay")
            .getter(getter(MaintenanceWindow::hoursOfDay))
            .setter(setter(Builder::hoursOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hoursOfDay").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_CUSTOM_ACTION_TIMEOUT_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isCustomActionTimeoutEnabled")
            .getter(getter(MaintenanceWindow::isCustomActionTimeoutEnabled))
            .setter(setter(Builder::isCustomActionTimeoutEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCustomActionTimeoutEnabled")
                    .build()).build();

    private static final SdkField<Integer> LEAD_TIME_IN_WEEKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("leadTimeInWeeks").getter(getter(MaintenanceWindow::leadTimeInWeeks))
            .setter(setter(Builder::leadTimeInWeeks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("leadTimeInWeeks").build()).build();

    private static final SdkField<List<Month>> MONTHS_FIELD = SdkField
            .<List<Month>> builder(MarshallingType.LIST)
            .memberName("months")
            .getter(getter(MaintenanceWindow::months))
            .setter(setter(Builder::months))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("months").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Month> builder(MarshallingType.SDK_POJO)
                                            .constructor(Month::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PATCHING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patchingMode").getter(getter(MaintenanceWindow::patchingModeAsString))
            .setter(setter(Builder::patchingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchingMode").build()).build();

    private static final SdkField<String> PREFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preference").getter(getter(MaintenanceWindow::preferenceAsString)).setter(setter(Builder::preference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preference").build()).build();

    private static final SdkField<Boolean> SKIP_RU_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipRu").getter(getter(MaintenanceWindow::skipRu)).setter(setter(Builder::skipRu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipRu").build()).build();

    private static final SdkField<List<Integer>> WEEKS_OF_MONTH_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("weeksOfMonth")
            .getter(getter(MaintenanceWindow::weeksOfMonth))
            .setter(setter(Builder::weeksOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weeksOfMonth").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_ACTION_TIMEOUT_IN_MINS_FIELD, DAYS_OF_WEEK_FIELD, HOURS_OF_DAY_FIELD, IS_CUSTOM_ACTION_TIMEOUT_ENABLED_FIELD,
            LEAD_TIME_IN_WEEKS_FIELD, MONTHS_FIELD, PATCHING_MODE_FIELD, PREFERENCE_FIELD, SKIP_RU_FIELD, WEEKS_OF_MONTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer customActionTimeoutInMins;

    private final List<DayOfWeek> daysOfWeek;

    private final List<Integer> hoursOfDay;

    private final Boolean isCustomActionTimeoutEnabled;

    private final Integer leadTimeInWeeks;

    private final List<Month> months;

    private final String patchingMode;

    private final String preference;

    private final Boolean skipRu;

    private final List<Integer> weeksOfMonth;

    private MaintenanceWindow(BuilderImpl builder) {
        this.customActionTimeoutInMins = builder.customActionTimeoutInMins;
        this.daysOfWeek = builder.daysOfWeek;
        this.hoursOfDay = builder.hoursOfDay;
        this.isCustomActionTimeoutEnabled = builder.isCustomActionTimeoutEnabled;
        this.leadTimeInWeeks = builder.leadTimeInWeeks;
        this.months = builder.months;
        this.patchingMode = builder.patchingMode;
        this.preference = builder.preference;
        this.skipRu = builder.skipRu;
        this.weeksOfMonth = builder.weeksOfMonth;
    }

    /**
     * <p>
     * The custom action timeout in minutes for the maintenance window.
     * </p>
     * 
     * @return The custom action timeout in minutes for the maintenance window.
     */
    public final Integer customActionTimeoutInMins() {
        return customActionTimeoutInMins;
    }

    /**
     * For responses, this returns true if the service returned a value for the DaysOfWeek property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDaysOfWeek() {
        return daysOfWeek != null && !(daysOfWeek instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The days of the week when maintenance can be performed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDaysOfWeek} method.
     * </p>
     * 
     * @return The days of the week when maintenance can be performed.
     */
    public final List<DayOfWeek> daysOfWeek() {
        return daysOfWeek;
    }

    /**
     * For responses, this returns true if the service returned a value for the HoursOfDay property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHoursOfDay() {
        return hoursOfDay != null && !(hoursOfDay instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The hours of the day when maintenance can be performed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHoursOfDay} method.
     * </p>
     * 
     * @return The hours of the day when maintenance can be performed.
     */
    public final List<Integer> hoursOfDay() {
        return hoursOfDay;
    }

    /**
     * <p>
     * Indicates whether custom action timeout is enabled for the maintenance window.
     * </p>
     * 
     * @return Indicates whether custom action timeout is enabled for the maintenance window.
     */
    public final Boolean isCustomActionTimeoutEnabled() {
        return isCustomActionTimeoutEnabled;
    }

    /**
     * <p>
     * The lead time in weeks before the maintenance window.
     * </p>
     * 
     * @return The lead time in weeks before the maintenance window.
     */
    public final Integer leadTimeInWeeks() {
        return leadTimeInWeeks;
    }

    /**
     * For responses, this returns true if the service returned a value for the Months property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMonths() {
        return months != null && !(months instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The months when maintenance can be performed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonths} method.
     * </p>
     * 
     * @return The months when maintenance can be performed.
     */
    public final List<Month> months() {
        return months;
    }

    /**
     * <p>
     * The patching mode for the maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #patchingMode} will
     * return {@link PatchingModeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #patchingModeAsString}.
     * </p>
     * 
     * @return The patching mode for the maintenance window.
     * @see PatchingModeType
     */
    public final PatchingModeType patchingMode() {
        return PatchingModeType.fromValue(patchingMode);
    }

    /**
     * <p>
     * The patching mode for the maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #patchingMode} will
     * return {@link PatchingModeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #patchingModeAsString}.
     * </p>
     * 
     * @return The patching mode for the maintenance window.
     * @see PatchingModeType
     */
    public final String patchingModeAsString() {
        return patchingMode;
    }

    /**
     * <p>
     * The preference for the maintenance window scheduling.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preference} will
     * return {@link PreferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #preferenceAsString}.
     * </p>
     * 
     * @return The preference for the maintenance window scheduling.
     * @see PreferenceType
     */
    public final PreferenceType preference() {
        return PreferenceType.fromValue(preference);
    }

    /**
     * <p>
     * The preference for the maintenance window scheduling.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preference} will
     * return {@link PreferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #preferenceAsString}.
     * </p>
     * 
     * @return The preference for the maintenance window scheduling.
     * @see PreferenceType
     */
    public final String preferenceAsString() {
        return preference;
    }

    /**
     * <p>
     * Indicates whether to skip release updates during maintenance.
     * </p>
     * 
     * @return Indicates whether to skip release updates during maintenance.
     */
    public final Boolean skipRu() {
        return skipRu;
    }

    /**
     * For responses, this returns true if the service returned a value for the WeeksOfMonth property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWeeksOfMonth() {
        return weeksOfMonth != null && !(weeksOfMonth instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The weeks of the month when maintenance can be performed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWeeksOfMonth} method.
     * </p>
     * 
     * @return The weeks of the month when maintenance can be performed.
     */
    public final List<Integer> weeksOfMonth() {
        return weeksOfMonth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customActionTimeoutInMins());
        hashCode = 31 * hashCode + Objects.hashCode(hasDaysOfWeek() ? daysOfWeek() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHoursOfDay() ? hoursOfDay() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isCustomActionTimeoutEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(leadTimeInWeeks());
        hashCode = 31 * hashCode + Objects.hashCode(hasMonths() ? months() : null);
        hashCode = 31 * hashCode + Objects.hashCode(patchingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(skipRu());
        hashCode = 31 * hashCode + Objects.hashCode(hasWeeksOfMonth() ? weeksOfMonth() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindow)) {
            return false;
        }
        MaintenanceWindow other = (MaintenanceWindow) obj;
        return Objects.equals(customActionTimeoutInMins(), other.customActionTimeoutInMins())
                && hasDaysOfWeek() == other.hasDaysOfWeek() && Objects.equals(daysOfWeek(), other.daysOfWeek())
                && hasHoursOfDay() == other.hasHoursOfDay() && Objects.equals(hoursOfDay(), other.hoursOfDay())
                && Objects.equals(isCustomActionTimeoutEnabled(), other.isCustomActionTimeoutEnabled())
                && Objects.equals(leadTimeInWeeks(), other.leadTimeInWeeks()) && hasMonths() == other.hasMonths()
                && Objects.equals(months(), other.months())
                && Objects.equals(patchingModeAsString(), other.patchingModeAsString())
                && Objects.equals(preferenceAsString(), other.preferenceAsString()) && Objects.equals(skipRu(), other.skipRu())
                && hasWeeksOfMonth() == other.hasWeeksOfMonth() && Objects.equals(weeksOfMonth(), other.weeksOfMonth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceWindow").add("CustomActionTimeoutInMins", customActionTimeoutInMins())
                .add("DaysOfWeek", hasDaysOfWeek() ? daysOfWeek() : null)
                .add("HoursOfDay", hasHoursOfDay() ? hoursOfDay() : null)
                .add("IsCustomActionTimeoutEnabled", isCustomActionTimeoutEnabled()).add("LeadTimeInWeeks", leadTimeInWeeks())
                .add("Months", hasMonths() ? months() : null).add("PatchingMode", patchingModeAsString())
                .add("Preference", preferenceAsString()).add("SkipRu", skipRu())
                .add("WeeksOfMonth", hasWeeksOfMonth() ? weeksOfMonth() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customActionTimeoutInMins":
            return Optional.ofNullable(clazz.cast(customActionTimeoutInMins()));
        case "daysOfWeek":
            return Optional.ofNullable(clazz.cast(daysOfWeek()));
        case "hoursOfDay":
            return Optional.ofNullable(clazz.cast(hoursOfDay()));
        case "isCustomActionTimeoutEnabled":
            return Optional.ofNullable(clazz.cast(isCustomActionTimeoutEnabled()));
        case "leadTimeInWeeks":
            return Optional.ofNullable(clazz.cast(leadTimeInWeeks()));
        case "months":
            return Optional.ofNullable(clazz.cast(months()));
        case "patchingMode":
            return Optional.ofNullable(clazz.cast(patchingModeAsString()));
        case "preference":
            return Optional.ofNullable(clazz.cast(preferenceAsString()));
        case "skipRu":
            return Optional.ofNullable(clazz.cast(skipRu()));
        case "weeksOfMonth":
            return Optional.ofNullable(clazz.cast(weeksOfMonth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customActionTimeoutInMins", CUSTOM_ACTION_TIMEOUT_IN_MINS_FIELD);
        map.put("daysOfWeek", DAYS_OF_WEEK_FIELD);
        map.put("hoursOfDay", HOURS_OF_DAY_FIELD);
        map.put("isCustomActionTimeoutEnabled", IS_CUSTOM_ACTION_TIMEOUT_ENABLED_FIELD);
        map.put("leadTimeInWeeks", LEAD_TIME_IN_WEEKS_FIELD);
        map.put("months", MONTHS_FIELD);
        map.put("patchingMode", PATCHING_MODE_FIELD);
        map.put("preference", PREFERENCE_FIELD);
        map.put("skipRu", SKIP_RU_FIELD);
        map.put("weeksOfMonth", WEEKS_OF_MONTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindow, T> g) {
        return obj -> g.apply((MaintenanceWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindow> {
        /**
         * <p>
         * The custom action timeout in minutes for the maintenance window.
         * </p>
         * 
         * @param customActionTimeoutInMins
         *        The custom action timeout in minutes for the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActionTimeoutInMins(Integer customActionTimeoutInMins);

        /**
         * <p>
         * The days of the week when maintenance can be performed.
         * </p>
         * 
         * @param daysOfWeek
         *        The days of the week when maintenance can be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfWeek(Collection<DayOfWeek> daysOfWeek);

        /**
         * <p>
         * The days of the week when maintenance can be performed.
         * </p>
         * 
         * @param daysOfWeek
         *        The days of the week when maintenance can be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfWeek(DayOfWeek... daysOfWeek);

        /**
         * <p>
         * The days of the week when maintenance can be performed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.DayOfWeek.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.odb.model.DayOfWeek#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.DayOfWeek.Builder#build()} is called immediately and its
         * result is passed to {@link #daysOfWeek(List<DayOfWeek>)}.
         * 
         * @param daysOfWeek
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.DayOfWeek.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #daysOfWeek(java.util.Collection<DayOfWeek>)
         */
        Builder daysOfWeek(Consumer<DayOfWeek.Builder>... daysOfWeek);

        /**
         * <p>
         * The hours of the day when maintenance can be performed.
         * </p>
         * 
         * @param hoursOfDay
         *        The hours of the day when maintenance can be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfDay(Collection<Integer> hoursOfDay);

        /**
         * <p>
         * The hours of the day when maintenance can be performed.
         * </p>
         * 
         * @param hoursOfDay
         *        The hours of the day when maintenance can be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfDay(Integer... hoursOfDay);

        /**
         * <p>
         * Indicates whether custom action timeout is enabled for the maintenance window.
         * </p>
         * 
         * @param isCustomActionTimeoutEnabled
         *        Indicates whether custom action timeout is enabled for the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCustomActionTimeoutEnabled(Boolean isCustomActionTimeoutEnabled);

        /**
         * <p>
         * The lead time in weeks before the maintenance window.
         * </p>
         * 
         * @param leadTimeInWeeks
         *        The lead time in weeks before the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leadTimeInWeeks(Integer leadTimeInWeeks);

        /**
         * <p>
         * The months when maintenance can be performed.
         * </p>
         * 
         * @param months
         *        The months when maintenance can be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder months(Collection<Month> months);

        /**
         * <p>
         * The months when maintenance can be performed.
         * </p>
         * 
         * @param months
         *        The months when maintenance can be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder months(Month... months);

        /**
         * <p>
         * The months when maintenance can be performed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.Month.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.odb.model.Month#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.odb.model.Month.Builder#build()}
         * is called immediately and its result is passed to {@link #months(List<Month>)}.
         * 
         * @param months
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.odb.model.Month.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #months(java.util.Collection<Month>)
         */
        Builder months(Consumer<Month.Builder>... months);

        /**
         * <p>
         * The patching mode for the maintenance window.
         * </p>
         * 
         * @param patchingMode
         *        The patching mode for the maintenance window.
         * @see PatchingModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchingModeType
         */
        Builder patchingMode(String patchingMode);

        /**
         * <p>
         * The patching mode for the maintenance window.
         * </p>
         * 
         * @param patchingMode
         *        The patching mode for the maintenance window.
         * @see PatchingModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchingModeType
         */
        Builder patchingMode(PatchingModeType patchingMode);

        /**
         * <p>
         * The preference for the maintenance window scheduling.
         * </p>
         * 
         * @param preference
         *        The preference for the maintenance window scheduling.
         * @see PreferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreferenceType
         */
        Builder preference(String preference);

        /**
         * <p>
         * The preference for the maintenance window scheduling.
         * </p>
         * 
         * @param preference
         *        The preference for the maintenance window scheduling.
         * @see PreferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreferenceType
         */
        Builder preference(PreferenceType preference);

        /**
         * <p>
         * Indicates whether to skip release updates during maintenance.
         * </p>
         * 
         * @param skipRu
         *        Indicates whether to skip release updates during maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipRu(Boolean skipRu);

        /**
         * <p>
         * The weeks of the month when maintenance can be performed.
         * </p>
         * 
         * @param weeksOfMonth
         *        The weeks of the month when maintenance can be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeksOfMonth(Collection<Integer> weeksOfMonth);

        /**
         * <p>
         * The weeks of the month when maintenance can be performed.
         * </p>
         * 
         * @param weeksOfMonth
         *        The weeks of the month when maintenance can be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeksOfMonth(Integer... weeksOfMonth);
    }

    static final class BuilderImpl implements Builder {
        private Integer customActionTimeoutInMins;

        private List<DayOfWeek> daysOfWeek = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> hoursOfDay = DefaultSdkAutoConstructList.getInstance();

        private Boolean isCustomActionTimeoutEnabled;

        private Integer leadTimeInWeeks;

        private List<Month> months = DefaultSdkAutoConstructList.getInstance();

        private String patchingMode;

        private String preference;

        private Boolean skipRu;

        private List<Integer> weeksOfMonth = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindow model) {
            customActionTimeoutInMins(model.customActionTimeoutInMins);
            daysOfWeek(model.daysOfWeek);
            hoursOfDay(model.hoursOfDay);
            isCustomActionTimeoutEnabled(model.isCustomActionTimeoutEnabled);
            leadTimeInWeeks(model.leadTimeInWeeks);
            months(model.months);
            patchingMode(model.patchingMode);
            preference(model.preference);
            skipRu(model.skipRu);
            weeksOfMonth(model.weeksOfMonth);
        }

        public final Integer getCustomActionTimeoutInMins() {
            return customActionTimeoutInMins;
        }

        public final void setCustomActionTimeoutInMins(Integer customActionTimeoutInMins) {
            this.customActionTimeoutInMins = customActionTimeoutInMins;
        }

        @Override
        public final Builder customActionTimeoutInMins(Integer customActionTimeoutInMins) {
            this.customActionTimeoutInMins = customActionTimeoutInMins;
            return this;
        }

        public final List<DayOfWeek.Builder> getDaysOfWeek() {
            List<DayOfWeek.Builder> result = DaysOfWeekCopier.copyToBuilder(this.daysOfWeek);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDaysOfWeek(Collection<DayOfWeek.BuilderImpl> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copyFromBuilder(daysOfWeek);
        }

        @Override
        public final Builder daysOfWeek(Collection<DayOfWeek> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfWeek(DayOfWeek... daysOfWeek) {
            daysOfWeek(Arrays.asList(daysOfWeek));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfWeek(Consumer<DayOfWeek.Builder>... daysOfWeek) {
            daysOfWeek(Stream.of(daysOfWeek).map(c -> DayOfWeek.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Integer> getHoursOfDay() {
            if (hoursOfDay instanceof SdkAutoConstructList) {
                return null;
            }
            return hoursOfDay;
        }

        public final void setHoursOfDay(Collection<Integer> hoursOfDay) {
            this.hoursOfDay = HoursOfDayCopier.copy(hoursOfDay);
        }

        @Override
        public final Builder hoursOfDay(Collection<Integer> hoursOfDay) {
            this.hoursOfDay = HoursOfDayCopier.copy(hoursOfDay);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfDay(Integer... hoursOfDay) {
            hoursOfDay(Arrays.asList(hoursOfDay));
            return this;
        }

        public final Boolean getIsCustomActionTimeoutEnabled() {
            return isCustomActionTimeoutEnabled;
        }

        public final void setIsCustomActionTimeoutEnabled(Boolean isCustomActionTimeoutEnabled) {
            this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
        }

        @Override
        public final Builder isCustomActionTimeoutEnabled(Boolean isCustomActionTimeoutEnabled) {
            this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
            return this;
        }

        public final Integer getLeadTimeInWeeks() {
            return leadTimeInWeeks;
        }

        public final void setLeadTimeInWeeks(Integer leadTimeInWeeks) {
            this.leadTimeInWeeks = leadTimeInWeeks;
        }

        @Override
        public final Builder leadTimeInWeeks(Integer leadTimeInWeeks) {
            this.leadTimeInWeeks = leadTimeInWeeks;
            return this;
        }

        public final List<Month.Builder> getMonths() {
            List<Month.Builder> result = MonthsCopier.copyToBuilder(this.months);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonths(Collection<Month.BuilderImpl> months) {
            this.months = MonthsCopier.copyFromBuilder(months);
        }

        @Override
        public final Builder months(Collection<Month> months) {
            this.months = MonthsCopier.copy(months);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder months(Month... months) {
            months(Arrays.asList(months));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder months(Consumer<Month.Builder>... months) {
            months(Stream.of(months).map(c -> Month.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPatchingMode() {
            return patchingMode;
        }

        public final void setPatchingMode(String patchingMode) {
            this.patchingMode = patchingMode;
        }

        @Override
        public final Builder patchingMode(String patchingMode) {
            this.patchingMode = patchingMode;
            return this;
        }

        @Override
        public final Builder patchingMode(PatchingModeType patchingMode) {
            this.patchingMode(patchingMode == null ? null : patchingMode.toString());
            return this;
        }

        public final String getPreference() {
            return preference;
        }

        public final void setPreference(String preference) {
            this.preference = preference;
        }

        @Override
        public final Builder preference(String preference) {
            this.preference = preference;
            return this;
        }

        @Override
        public final Builder preference(PreferenceType preference) {
            this.preference(preference == null ? null : preference.toString());
            return this;
        }

        public final Boolean getSkipRu() {
            return skipRu;
        }

        public final void setSkipRu(Boolean skipRu) {
            this.skipRu = skipRu;
        }

        @Override
        public final Builder skipRu(Boolean skipRu) {
            this.skipRu = skipRu;
            return this;
        }

        public final Collection<Integer> getWeeksOfMonth() {
            if (weeksOfMonth instanceof SdkAutoConstructList) {
                return null;
            }
            return weeksOfMonth;
        }

        public final void setWeeksOfMonth(Collection<Integer> weeksOfMonth) {
            this.weeksOfMonth = WeeksOfMonthCopier.copy(weeksOfMonth);
        }

        @Override
        public final Builder weeksOfMonth(Collection<Integer> weeksOfMonth) {
            this.weeksOfMonth = WeeksOfMonthCopier.copy(weeksOfMonth);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weeksOfMonth(Integer... weeksOfMonth) {
            weeksOfMonth(Arrays.asList(weeksOfMonth));
            return this;
        }

        @Override
        public MaintenanceWindow build() {
            return new MaintenanceWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
