/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Oracle Database@Amazon Web Services is an offering that enables you to access Oracle Exadata infrastructure managed
 * by Oracle Cloud Infrastructure (OCI) inside Amazon Web Services data centers. You can migrate your Oracle Exadata
 * workloads, establish low-latency connectivity with applications running on Amazon Web Services, and integrate with
 * Amazon Web Services services. For example, you can run application servers in a virtual private cloud (VPC) and
 * access an Oracle Exadata system running in Oracle Database@Amazon Web Services. You can get started with Oracle
 * Database@Amazon Web Services by using the familiar Amazon Web Services Management Console, APIs, or CLI.
 * </p>
 * <p>
 * This interface reference for Oracle Database@Amazon Web Services contains documentation for a programming or command
 * line interface that you can use to manage Oracle Database@Amazon Web Services. Oracle Database@Amazon Web Services is
 * asynchronous, which means that some interfaces might require techniques such as polling or callback functions to
 * determine when a command has been applied. The reference structure is as follows.
 * </p>
 * <note>
 * <p>
 * In this preview release documentation, the links in the "See Also" sections do not work.
 * </p>
 * </note>
 * <p>
 * <b>Oracle Database@Amazon Web Services API Reference</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For the alphabetical list of API actions, see .
 * </p>
 * </li>
 * <li>
 * <p>
 * For the alphabetical list of data types, see .
 * </p>
 * </li>
 * <li>
 * <p>
 * For a list of common parameters, see <a>CommonParameters</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For descriptions of the error codes, see <a>CommonErrors</a>.
 * </p>
 * </li>
 * </ul>
 */
package software.amazon.awssdk.services.odb;