/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of an Autonomous Virtual Machine (VM) within an Autonomous VM cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutonomousVirtualMachineSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AutonomousVirtualMachineSummary.Builder, AutonomousVirtualMachineSummary> {
    private static final SdkField<String> AUTONOMOUS_VIRTUAL_MACHINE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("autonomousVirtualMachineId")
            .getter(getter(AutonomousVirtualMachineSummary::autonomousVirtualMachineId))
            .setter(setter(Builder::autonomousVirtualMachineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousVirtualMachineId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AutonomousVirtualMachineSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(AutonomousVirtualMachineSummary::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> VM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vmName")
            .getter(getter(AutonomousVirtualMachineSummary::vmName)).setter(setter(Builder::vmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmName").build()).build();

    private static final SdkField<String> DB_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbServerId").getter(getter(AutonomousVirtualMachineSummary::dbServerId))
            .setter(setter(Builder::dbServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerId").build()).build();

    private static final SdkField<String> DB_SERVER_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbServerDisplayName").getter(getter(AutonomousVirtualMachineSummary::dbServerDisplayName))
            .setter(setter(Builder::dbServerDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerDisplayName").build())
            .build();

    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuCoreCount").getter(getter(AutonomousVirtualMachineSummary::cpuCoreCount))
            .setter(setter(Builder::cpuCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySizeInGBs").getter(getter(AutonomousVirtualMachineSummary::memorySizeInGBs))
            .setter(setter(Builder::memorySizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()).build();

    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs")
            .getter(getter(AutonomousVirtualMachineSummary::dbNodeStorageSizeInGBs))
            .setter(setter(Builder::dbNodeStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build())
            .build();

    private static final SdkField<String> CLIENT_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientIpAddress").getter(getter(AutonomousVirtualMachineSummary::clientIpAddress))
            .setter(setter(Builder::clientIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIpAddress").build()).build();

    private static final SdkField<String> CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudAutonomousVmClusterId")
            .getter(getter(AutonomousVirtualMachineSummary::cloudAutonomousVmClusterId))
            .setter(setter(Builder::cloudAutonomousVmClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusterId").build())
            .build();

    private static final SdkField<String> OCID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ocid")
            .getter(getter(AutonomousVirtualMachineSummary::ocid)).setter(setter(Builder::ocid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()).build();

    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociResourceAnchorName").getter(getter(AutonomousVirtualMachineSummary::ociResourceAnchorName))
            .setter(setter(Builder::ociResourceAnchorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTONOMOUS_VIRTUAL_MACHINE_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, VM_NAME_FIELD, DB_SERVER_ID_FIELD,
            DB_SERVER_DISPLAY_NAME_FIELD, CPU_CORE_COUNT_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD,
            CLIENT_IP_ADDRESS_FIELD, CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD, OCID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String autonomousVirtualMachineId;

    private final String status;

    private final String statusReason;

    private final String vmName;

    private final String dbServerId;

    private final String dbServerDisplayName;

    private final Integer cpuCoreCount;

    private final Integer memorySizeInGBs;

    private final Integer dbNodeStorageSizeInGBs;

    private final String clientIpAddress;

    private final String cloudAutonomousVmClusterId;

    private final String ocid;

    private final String ociResourceAnchorName;

    private AutonomousVirtualMachineSummary(BuilderImpl builder) {
        this.autonomousVirtualMachineId = builder.autonomousVirtualMachineId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.vmName = builder.vmName;
        this.dbServerId = builder.dbServerId;
        this.dbServerDisplayName = builder.dbServerDisplayName;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.clientIpAddress = builder.clientIpAddress;
        this.cloudAutonomousVmClusterId = builder.cloudAutonomousVmClusterId;
        this.ocid = builder.ocid;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
    }

    /**
     * <p>
     * The unique identifier of the Autonomous VM.
     * </p>
     * 
     * @return The unique identifier of the Autonomous VM.
     */
    public final String autonomousVirtualMachineId() {
        return autonomousVirtualMachineId;
    }

    /**
     * <p>
     * The current status of the Autonomous VM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Autonomous VM.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Autonomous VM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Autonomous VM.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the current status of the Autonomous VM, if applicable.
     * </p>
     * 
     * @return Additional information about the current status of the Autonomous VM, if applicable.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The name of the Autonomous VM.
     * </p>
     * 
     * @return The name of the Autonomous VM.
     */
    public final String vmName() {
        return vmName;
    }

    /**
     * <p>
     * The unique identifier of the database server hosting this Autonomous VM.
     * </p>
     * 
     * @return The unique identifier of the database server hosting this Autonomous VM.
     */
    public final String dbServerId() {
        return dbServerId;
    }

    /**
     * <p>
     * The display name of the database server hosting this Autonomous VM.
     * </p>
     * 
     * @return The display name of the database server hosting this Autonomous VM.
     */
    public final String dbServerDisplayName() {
        return dbServerDisplayName;
    }

    /**
     * <p>
     * The number of CPU cores allocated to this Autonomous VM.
     * </p>
     * 
     * @return The number of CPU cores allocated to this Autonomous VM.
     */
    public final Integer cpuCoreCount() {
        return cpuCoreCount;
    }

    /**
     * <p>
     * The amount of memory allocated to this Autonomous VM, in gigabytes (GB).
     * </p>
     * 
     * @return The amount of memory allocated to this Autonomous VM, in gigabytes (GB).
     */
    public final Integer memorySizeInGBs() {
        return memorySizeInGBs;
    }

    /**
     * <p>
     * The amount of storage allocated to this Autonomous Virtual Machine, in gigabytes (GB).
     * </p>
     * 
     * @return The amount of storage allocated to this Autonomous Virtual Machine, in gigabytes (GB).
     */
    public final Integer dbNodeStorageSizeInGBs() {
        return dbNodeStorageSizeInGBs;
    }

    /**
     * <p>
     * The IP address used by clients to connect to this Autonomous VM.
     * </p>
     * 
     * @return The IP address used by clients to connect to this Autonomous VM.
     */
    public final String clientIpAddress() {
        return clientIpAddress;
    }

    /**
     * <p>
     * The unique identifier of the Autonomous VM cluster containing this Autonomous VM.
     * </p>
     * 
     * @return The unique identifier of the Autonomous VM cluster containing this Autonomous VM.
     */
    public final String cloudAutonomousVmClusterId() {
        return cloudAutonomousVmClusterId;
    }

    /**
     * <p>
     * The Oracle Cloud Identifier (OCID) of the Autonomous VM.
     * </p>
     * 
     * @return The Oracle Cloud Identifier (OCID) of the Autonomous VM.
     */
    public final String ocid() {
        return ocid;
    }

    /**
     * <p>
     * The name of the Oracle Cloud Infrastructure (OCI) resource anchor associated with this Autonomous VM.
     * </p>
     * 
     * @return The name of the Oracle Cloud Infrastructure (OCI) resource anchor associated with this Autonomous VM.
     */
    public final String ociResourceAnchorName() {
        return ociResourceAnchorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autonomousVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(vmName());
        hashCode = 31 * hashCode + Objects.hashCode(dbServerId());
        hashCode = 31 * hashCode + Objects.hashCode(dbServerDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(clientIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(cloudAutonomousVmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(ocid());
        hashCode = 31 * hashCode + Objects.hashCode(ociResourceAnchorName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutonomousVirtualMachineSummary)) {
            return false;
        }
        AutonomousVirtualMachineSummary other = (AutonomousVirtualMachineSummary) obj;
        return Objects.equals(autonomousVirtualMachineId(), other.autonomousVirtualMachineId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(vmName(), other.vmName())
                && Objects.equals(dbServerId(), other.dbServerId())
                && Objects.equals(dbServerDisplayName(), other.dbServerDisplayName())
                && Objects.equals(cpuCoreCount(), other.cpuCoreCount())
                && Objects.equals(memorySizeInGBs(), other.memorySizeInGBs())
                && Objects.equals(dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs())
                && Objects.equals(clientIpAddress(), other.clientIpAddress())
                && Objects.equals(cloudAutonomousVmClusterId(), other.cloudAutonomousVmClusterId())
                && Objects.equals(ocid(), other.ocid()) && Objects.equals(ociResourceAnchorName(), other.ociResourceAnchorName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutonomousVirtualMachineSummary")
                .add("AutonomousVirtualMachineId", autonomousVirtualMachineId()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("VmName", vmName()).add("DbServerId", dbServerId())
                .add("DbServerDisplayName", dbServerDisplayName()).add("CpuCoreCount", cpuCoreCount())
                .add("MemorySizeInGBs", memorySizeInGBs()).add("DbNodeStorageSizeInGBs", dbNodeStorageSizeInGBs())
                .add("ClientIpAddress", clientIpAddress()).add("CloudAutonomousVmClusterId", cloudAutonomousVmClusterId())
                .add("Ocid", ocid()).add("OciResourceAnchorName", ociResourceAnchorName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autonomousVirtualMachineId":
            return Optional.ofNullable(clazz.cast(autonomousVirtualMachineId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "vmName":
            return Optional.ofNullable(clazz.cast(vmName()));
        case "dbServerId":
            return Optional.ofNullable(clazz.cast(dbServerId()));
        case "dbServerDisplayName":
            return Optional.ofNullable(clazz.cast(dbServerDisplayName()));
        case "cpuCoreCount":
            return Optional.ofNullable(clazz.cast(cpuCoreCount()));
        case "memorySizeInGBs":
            return Optional.ofNullable(clazz.cast(memorySizeInGBs()));
        case "dbNodeStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(dbNodeStorageSizeInGBs()));
        case "clientIpAddress":
            return Optional.ofNullable(clazz.cast(clientIpAddress()));
        case "cloudAutonomousVmClusterId":
            return Optional.ofNullable(clazz.cast(cloudAutonomousVmClusterId()));
        case "ocid":
            return Optional.ofNullable(clazz.cast(ocid()));
        case "ociResourceAnchorName":
            return Optional.ofNullable(clazz.cast(ociResourceAnchorName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("autonomousVirtualMachineId", AUTONOMOUS_VIRTUAL_MACHINE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("vmName", VM_NAME_FIELD);
        map.put("dbServerId", DB_SERVER_ID_FIELD);
        map.put("dbServerDisplayName", DB_SERVER_DISPLAY_NAME_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("clientIpAddress", CLIENT_IP_ADDRESS_FIELD);
        map.put("cloudAutonomousVmClusterId", CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutonomousVirtualMachineSummary, T> g) {
        return obj -> g.apply((AutonomousVirtualMachineSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutonomousVirtualMachineSummary> {
        /**
         * <p>
         * The unique identifier of the Autonomous VM.
         * </p>
         * 
         * @param autonomousVirtualMachineId
         *        The unique identifier of the Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autonomousVirtualMachineId(String autonomousVirtualMachineId);

        /**
         * <p>
         * The current status of the Autonomous VM.
         * </p>
         * 
         * @param status
         *        The current status of the Autonomous VM.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Autonomous VM.
         * </p>
         * 
         * @param status
         *        The current status of the Autonomous VM.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Additional information about the current status of the Autonomous VM, if applicable.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the current status of the Autonomous VM, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The name of the Autonomous VM.
         * </p>
         * 
         * @param vmName
         *        The name of the Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmName(String vmName);

        /**
         * <p>
         * The unique identifier of the database server hosting this Autonomous VM.
         * </p>
         * 
         * @param dbServerId
         *        The unique identifier of the database server hosting this Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServerId(String dbServerId);

        /**
         * <p>
         * The display name of the database server hosting this Autonomous VM.
         * </p>
         * 
         * @param dbServerDisplayName
         *        The display name of the database server hosting this Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServerDisplayName(String dbServerDisplayName);

        /**
         * <p>
         * The number of CPU cores allocated to this Autonomous VM.
         * </p>
         * 
         * @param cpuCoreCount
         *        The number of CPU cores allocated to this Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCoreCount(Integer cpuCoreCount);

        /**
         * <p>
         * The amount of memory allocated to this Autonomous VM, in gigabytes (GB).
         * </p>
         * 
         * @param memorySizeInGBs
         *        The amount of memory allocated to this Autonomous VM, in gigabytes (GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInGBs(Integer memorySizeInGBs);

        /**
         * <p>
         * The amount of storage allocated to this Autonomous Virtual Machine, in gigabytes (GB).
         * </p>
         * 
         * @param dbNodeStorageSizeInGBs
         *        The amount of storage allocated to this Autonomous Virtual Machine, in gigabytes (GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs);

        /**
         * <p>
         * The IP address used by clients to connect to this Autonomous VM.
         * </p>
         * 
         * @param clientIpAddress
         *        The IP address used by clients to connect to this Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIpAddress(String clientIpAddress);

        /**
         * <p>
         * The unique identifier of the Autonomous VM cluster containing this Autonomous VM.
         * </p>
         * 
         * @param cloudAutonomousVmClusterId
         *        The unique identifier of the Autonomous VM cluster containing this Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId);

        /**
         * <p>
         * The Oracle Cloud Identifier (OCID) of the Autonomous VM.
         * </p>
         * 
         * @param ocid
         *        The Oracle Cloud Identifier (OCID) of the Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocid(String ocid);

        /**
         * <p>
         * The name of the Oracle Cloud Infrastructure (OCI) resource anchor associated with this Autonomous VM.
         * </p>
         * 
         * @param ociResourceAnchorName
         *        The name of the Oracle Cloud Infrastructure (OCI) resource anchor associated with this Autonomous VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociResourceAnchorName(String ociResourceAnchorName);
    }

    static final class BuilderImpl implements Builder {
        private String autonomousVirtualMachineId;

        private String status;

        private String statusReason;

        private String vmName;

        private String dbServerId;

        private String dbServerDisplayName;

        private Integer cpuCoreCount;

        private Integer memorySizeInGBs;

        private Integer dbNodeStorageSizeInGBs;

        private String clientIpAddress;

        private String cloudAutonomousVmClusterId;

        private String ocid;

        private String ociResourceAnchorName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutonomousVirtualMachineSummary model) {
            autonomousVirtualMachineId(model.autonomousVirtualMachineId);
            status(model.status);
            statusReason(model.statusReason);
            vmName(model.vmName);
            dbServerId(model.dbServerId);
            dbServerDisplayName(model.dbServerDisplayName);
            cpuCoreCount(model.cpuCoreCount);
            memorySizeInGBs(model.memorySizeInGBs);
            dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            clientIpAddress(model.clientIpAddress);
            cloudAutonomousVmClusterId(model.cloudAutonomousVmClusterId);
            ocid(model.ocid);
            ociResourceAnchorName(model.ociResourceAnchorName);
        }

        public final String getAutonomousVirtualMachineId() {
            return autonomousVirtualMachineId;
        }

        public final void setAutonomousVirtualMachineId(String autonomousVirtualMachineId) {
            this.autonomousVirtualMachineId = autonomousVirtualMachineId;
        }

        @Override
        public final Builder autonomousVirtualMachineId(String autonomousVirtualMachineId) {
            this.autonomousVirtualMachineId = autonomousVirtualMachineId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getVmName() {
            return vmName;
        }

        public final void setVmName(String vmName) {
            this.vmName = vmName;
        }

        @Override
        public final Builder vmName(String vmName) {
            this.vmName = vmName;
            return this;
        }

        public final String getDbServerId() {
            return dbServerId;
        }

        public final void setDbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
        }

        @Override
        public final Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            return this;
        }

        public final String getDbServerDisplayName() {
            return dbServerDisplayName;
        }

        public final void setDbServerDisplayName(String dbServerDisplayName) {
            this.dbServerDisplayName = dbServerDisplayName;
        }

        @Override
        public final Builder dbServerDisplayName(String dbServerDisplayName) {
            this.dbServerDisplayName = dbServerDisplayName;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final String getClientIpAddress() {
            return clientIpAddress;
        }

        public final void setClientIpAddress(String clientIpAddress) {
            this.clientIpAddress = clientIpAddress;
        }

        @Override
        public final Builder clientIpAddress(String clientIpAddress) {
            this.clientIpAddress = clientIpAddress;
            return this;
        }

        public final String getCloudAutonomousVmClusterId() {
            return cloudAutonomousVmClusterId;
        }

        public final void setCloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
        }

        @Override
        public final Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            return this;
        }

        public final String getOcid() {
            return ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        @Override
        public AutonomousVirtualMachineSummary build() {
            return new AutonomousVirtualMachineSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
