/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about unallocated resources in the Cloud Exadata infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudExadataInfrastructureUnallocatedResources implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudExadataInfrastructureUnallocatedResources.Builder, CloudExadataInfrastructureUnallocatedResources> {
    private static final SdkField<List<CloudAutonomousVmClusterResourceDetails>> CLOUD_AUTONOMOUS_VM_CLUSTERS_FIELD = SdkField
            .<List<CloudAutonomousVmClusterResourceDetails>> builder(MarshallingType.LIST)
            .memberName("cloudAutonomousVmClusters")
            .getter(getter(CloudExadataInfrastructureUnallocatedResources::cloudAutonomousVmClusters))
            .setter(setter(Builder::cloudAutonomousVmClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudAutonomousVmClusterResourceDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudAutonomousVmClusterResourceDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudExadataInfrastructureDisplayName")
            .getter(getter(CloudExadataInfrastructureUnallocatedResources::cloudExadataInfrastructureDisplayName))
            .setter(setter(Builder::cloudExadataInfrastructureDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("cloudExadataInfrastructureDisplayName").build()).build();

    private static final SdkField<Double> EXADATA_STORAGE_IN_T_BS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("exadataStorageInTBs")
            .getter(getter(CloudExadataInfrastructureUnallocatedResources::exadataStorageInTBs))
            .setter(setter(Builder::exadataStorageInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exadataStorageInTBs").build())
            .build();

    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudExadataInfrastructureId")
            .getter(getter(CloudExadataInfrastructureUnallocatedResources::cloudExadataInfrastructureId))
            .setter(setter(Builder::cloudExadataInfrastructureId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId")
                    .build()).build();

    private static final SdkField<Integer> LOCAL_STORAGE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("localStorageInGBs").getter(getter(CloudExadataInfrastructureUnallocatedResources::localStorageInGBs))
            .setter(setter(Builder::localStorageInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localStorageInGBs").build()).build();

    private static final SdkField<Integer> MEMORY_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memoryInGBs").getter(getter(CloudExadataInfrastructureUnallocatedResources::memoryInGBs))
            .setter(setter(Builder::memoryInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryInGBs").build()).build();

    private static final SdkField<Integer> OCPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("ocpus")
            .getter(getter(CloudExadataInfrastructureUnallocatedResources::ocpus)).setter(setter(Builder::ocpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocpus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_AUTONOMOUS_VM_CLUSTERS_FIELD, CLOUD_EXADATA_INFRASTRUCTURE_DISPLAY_NAME_FIELD, EXADATA_STORAGE_IN_T_BS_FIELD,
            CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, LOCAL_STORAGE_IN_G_BS_FIELD, MEMORY_IN_G_BS_FIELD, OCPUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CloudAutonomousVmClusterResourceDetails> cloudAutonomousVmClusters;

    private final String cloudExadataInfrastructureDisplayName;

    private final Double exadataStorageInTBs;

    private final String cloudExadataInfrastructureId;

    private final Integer localStorageInGBs;

    private final Integer memoryInGBs;

    private final Integer ocpus;

    private CloudExadataInfrastructureUnallocatedResources(BuilderImpl builder) {
        this.cloudAutonomousVmClusters = builder.cloudAutonomousVmClusters;
        this.cloudExadataInfrastructureDisplayName = builder.cloudExadataInfrastructureDisplayName;
        this.exadataStorageInTBs = builder.exadataStorageInTBs;
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.localStorageInGBs = builder.localStorageInGBs;
        this.memoryInGBs = builder.memoryInGBs;
        this.ocpus = builder.ocpus;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudAutonomousVmClusters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCloudAutonomousVmClusters() {
        return cloudAutonomousVmClusters != null && !(cloudAutonomousVmClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Autonomous VM clusters associated with this Cloud Exadata Infrastructure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudAutonomousVmClusters} method.
     * </p>
     * 
     * @return A list of Autonomous VM clusters associated with this Cloud Exadata Infrastructure.
     */
    public final List<CloudAutonomousVmClusterResourceDetails> cloudAutonomousVmClusters() {
        return cloudAutonomousVmClusters;
    }

    /**
     * <p>
     * The display name of the Cloud Exadata infrastructure.
     * </p>
     * 
     * @return The display name of the Cloud Exadata infrastructure.
     */
    public final String cloudExadataInfrastructureDisplayName() {
        return cloudExadataInfrastructureDisplayName;
    }

    /**
     * <p>
     * The amount of unallocated Exadata storage available, in terabytes (TB).
     * </p>
     * 
     * @return The amount of unallocated Exadata storage available, in terabytes (TB).
     */
    public final Double exadataStorageInTBs() {
        return exadataStorageInTBs;
    }

    /**
     * <p>
     * The unique identifier of the Cloud Exadata infrastructure.
     * </p>
     * 
     * @return The unique identifier of the Cloud Exadata infrastructure.
     */
    public final String cloudExadataInfrastructureId() {
        return cloudExadataInfrastructureId;
    }

    /**
     * <p>
     * The amount of unallocated local storage available, in gigabytes (GB).
     * </p>
     * 
     * @return The amount of unallocated local storage available, in gigabytes (GB).
     */
    public final Integer localStorageInGBs() {
        return localStorageInGBs;
    }

    /**
     * <p>
     * The amount of unallocated memory available, in gigabytes (GB).
     * </p>
     * 
     * @return The amount of unallocated memory available, in gigabytes (GB).
     */
    public final Integer memoryInGBs() {
        return memoryInGBs;
    }

    /**
     * <p>
     * The number of unallocated Oracle CPU Units (OCPUs) available.
     * </p>
     * 
     * @return The number of unallocated Oracle CPU Units (OCPUs) available.
     */
    public final Integer ocpus() {
        return ocpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudAutonomousVmClusters() ? cloudAutonomousVmClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(exadataStorageInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(localStorageInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(ocpus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudExadataInfrastructureUnallocatedResources)) {
            return false;
        }
        CloudExadataInfrastructureUnallocatedResources other = (CloudExadataInfrastructureUnallocatedResources) obj;
        return hasCloudAutonomousVmClusters() == other.hasCloudAutonomousVmClusters()
                && Objects.equals(cloudAutonomousVmClusters(), other.cloudAutonomousVmClusters())
                && Objects.equals(cloudExadataInfrastructureDisplayName(), other.cloudExadataInfrastructureDisplayName())
                && Objects.equals(exadataStorageInTBs(), other.exadataStorageInTBs())
                && Objects.equals(cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId())
                && Objects.equals(localStorageInGBs(), other.localStorageInGBs())
                && Objects.equals(memoryInGBs(), other.memoryInGBs()) && Objects.equals(ocpus(), other.ocpus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudExadataInfrastructureUnallocatedResources")
                .add("CloudAutonomousVmClusters", hasCloudAutonomousVmClusters() ? cloudAutonomousVmClusters() : null)
                .add("CloudExadataInfrastructureDisplayName", cloudExadataInfrastructureDisplayName())
                .add("ExadataStorageInTBs", exadataStorageInTBs())
                .add("CloudExadataInfrastructureId", cloudExadataInfrastructureId())
                .add("LocalStorageInGBs", localStorageInGBs()).add("MemoryInGBs", memoryInGBs()).add("Ocpus", ocpus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudAutonomousVmClusters":
            return Optional.ofNullable(clazz.cast(cloudAutonomousVmClusters()));
        case "cloudExadataInfrastructureDisplayName":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureDisplayName()));
        case "exadataStorageInTBs":
            return Optional.ofNullable(clazz.cast(exadataStorageInTBs()));
        case "cloudExadataInfrastructureId":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureId()));
        case "localStorageInGBs":
            return Optional.ofNullable(clazz.cast(localStorageInGBs()));
        case "memoryInGBs":
            return Optional.ofNullable(clazz.cast(memoryInGBs()));
        case "ocpus":
            return Optional.ofNullable(clazz.cast(ocpus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudAutonomousVmClusters", CLOUD_AUTONOMOUS_VM_CLUSTERS_FIELD);
        map.put("cloudExadataInfrastructureDisplayName", CLOUD_EXADATA_INFRASTRUCTURE_DISPLAY_NAME_FIELD);
        map.put("exadataStorageInTBs", EXADATA_STORAGE_IN_T_BS_FIELD);
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("localStorageInGBs", LOCAL_STORAGE_IN_G_BS_FIELD);
        map.put("memoryInGBs", MEMORY_IN_G_BS_FIELD);
        map.put("ocpus", OCPUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudExadataInfrastructureUnallocatedResources, T> g) {
        return obj -> g.apply((CloudExadataInfrastructureUnallocatedResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudExadataInfrastructureUnallocatedResources> {
        /**
         * <p>
         * A list of Autonomous VM clusters associated with this Cloud Exadata Infrastructure.
         * </p>
         * 
         * @param cloudAutonomousVmClusters
         *        A list of Autonomous VM clusters associated with this Cloud Exadata Infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudAutonomousVmClusters(Collection<CloudAutonomousVmClusterResourceDetails> cloudAutonomousVmClusters);

        /**
         * <p>
         * A list of Autonomous VM clusters associated with this Cloud Exadata Infrastructure.
         * </p>
         * 
         * @param cloudAutonomousVmClusters
         *        A list of Autonomous VM clusters associated with this Cloud Exadata Infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudAutonomousVmClusters(CloudAutonomousVmClusterResourceDetails... cloudAutonomousVmClusters);

        /**
         * <p>
         * A list of Autonomous VM clusters associated with this Cloud Exadata Infrastructure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.CloudAutonomousVmClusterResourceDetails.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.odb.model.CloudAutonomousVmClusterResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.CloudAutonomousVmClusterResourceDetails.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #cloudAutonomousVmClusters(List<CloudAutonomousVmClusterResourceDetails>)}.
         * 
         * @param cloudAutonomousVmClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.CloudAutonomousVmClusterResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudAutonomousVmClusters(java.util.Collection<CloudAutonomousVmClusterResourceDetails>)
         */
        Builder cloudAutonomousVmClusters(Consumer<CloudAutonomousVmClusterResourceDetails.Builder>... cloudAutonomousVmClusters);

        /**
         * <p>
         * The display name of the Cloud Exadata infrastructure.
         * </p>
         * 
         * @param cloudExadataInfrastructureDisplayName
         *        The display name of the Cloud Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureDisplayName(String cloudExadataInfrastructureDisplayName);

        /**
         * <p>
         * The amount of unallocated Exadata storage available, in terabytes (TB).
         * </p>
         * 
         * @param exadataStorageInTBs
         *        The amount of unallocated Exadata storage available, in terabytes (TB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exadataStorageInTBs(Double exadataStorageInTBs);

        /**
         * <p>
         * The unique identifier of the Cloud Exadata infrastructure.
         * </p>
         * 
         * @param cloudExadataInfrastructureId
         *        The unique identifier of the Cloud Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId);

        /**
         * <p>
         * The amount of unallocated local storage available, in gigabytes (GB).
         * </p>
         * 
         * @param localStorageInGBs
         *        The amount of unallocated local storage available, in gigabytes (GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localStorageInGBs(Integer localStorageInGBs);

        /**
         * <p>
         * The amount of unallocated memory available, in gigabytes (GB).
         * </p>
         * 
         * @param memoryInGBs
         *        The amount of unallocated memory available, in gigabytes (GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInGBs(Integer memoryInGBs);

        /**
         * <p>
         * The number of unallocated Oracle CPU Units (OCPUs) available.
         * </p>
         * 
         * @param ocpus
         *        The number of unallocated Oracle CPU Units (OCPUs) available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocpus(Integer ocpus);
    }

    static final class BuilderImpl implements Builder {
        private List<CloudAutonomousVmClusterResourceDetails> cloudAutonomousVmClusters = DefaultSdkAutoConstructList
                .getInstance();

        private String cloudExadataInfrastructureDisplayName;

        private Double exadataStorageInTBs;

        private String cloudExadataInfrastructureId;

        private Integer localStorageInGBs;

        private Integer memoryInGBs;

        private Integer ocpus;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudExadataInfrastructureUnallocatedResources model) {
            cloudAutonomousVmClusters(model.cloudAutonomousVmClusters);
            cloudExadataInfrastructureDisplayName(model.cloudExadataInfrastructureDisplayName);
            exadataStorageInTBs(model.exadataStorageInTBs);
            cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            localStorageInGBs(model.localStorageInGBs);
            memoryInGBs(model.memoryInGBs);
            ocpus(model.ocpus);
        }

        public final List<CloudAutonomousVmClusterResourceDetails.Builder> getCloudAutonomousVmClusters() {
            List<CloudAutonomousVmClusterResourceDetails.Builder> result = CloudAutonomousVmClusterResourceDetailsListCopier
                    .copyToBuilder(this.cloudAutonomousVmClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudAutonomousVmClusters(
                Collection<CloudAutonomousVmClusterResourceDetails.BuilderImpl> cloudAutonomousVmClusters) {
            this.cloudAutonomousVmClusters = CloudAutonomousVmClusterResourceDetailsListCopier
                    .copyFromBuilder(cloudAutonomousVmClusters);
        }

        @Override
        public final Builder cloudAutonomousVmClusters(
                Collection<CloudAutonomousVmClusterResourceDetails> cloudAutonomousVmClusters) {
            this.cloudAutonomousVmClusters = CloudAutonomousVmClusterResourceDetailsListCopier.copy(cloudAutonomousVmClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudAutonomousVmClusters(CloudAutonomousVmClusterResourceDetails... cloudAutonomousVmClusters) {
            cloudAutonomousVmClusters(Arrays.asList(cloudAutonomousVmClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudAutonomousVmClusters(
                Consumer<CloudAutonomousVmClusterResourceDetails.Builder>... cloudAutonomousVmClusters) {
            cloudAutonomousVmClusters(Stream.of(cloudAutonomousVmClusters)
                    .map(c -> CloudAutonomousVmClusterResourceDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCloudExadataInfrastructureDisplayName() {
            return cloudExadataInfrastructureDisplayName;
        }

        public final void setCloudExadataInfrastructureDisplayName(String cloudExadataInfrastructureDisplayName) {
            this.cloudExadataInfrastructureDisplayName = cloudExadataInfrastructureDisplayName;
        }

        @Override
        public final Builder cloudExadataInfrastructureDisplayName(String cloudExadataInfrastructureDisplayName) {
            this.cloudExadataInfrastructureDisplayName = cloudExadataInfrastructureDisplayName;
            return this;
        }

        public final Double getExadataStorageInTBs() {
            return exadataStorageInTBs;
        }

        public final void setExadataStorageInTBs(Double exadataStorageInTBs) {
            this.exadataStorageInTBs = exadataStorageInTBs;
        }

        @Override
        public final Builder exadataStorageInTBs(Double exadataStorageInTBs) {
            this.exadataStorageInTBs = exadataStorageInTBs;
            return this;
        }

        public final String getCloudExadataInfrastructureId() {
            return cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final Integer getLocalStorageInGBs() {
            return localStorageInGBs;
        }

        public final void setLocalStorageInGBs(Integer localStorageInGBs) {
            this.localStorageInGBs = localStorageInGBs;
        }

        @Override
        public final Builder localStorageInGBs(Integer localStorageInGBs) {
            this.localStorageInGBs = localStorageInGBs;
            return this;
        }

        public final Integer getMemoryInGBs() {
            return memoryInGBs;
        }

        public final void setMemoryInGBs(Integer memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
        }

        @Override
        public final Builder memoryInGBs(Integer memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            return this;
        }

        public final Integer getOcpus() {
            return ocpus;
        }

        public final void setOcpus(Integer ocpus) {
            this.ocpus = ocpus;
        }

        @Override
        public final Builder ocpus(Integer ocpus) {
            this.ocpus = ocpus;
            return this;
        }

        @Override
        public CloudExadataInfrastructureUnallocatedResources build() {
            return new CloudExadataInfrastructureUnallocatedResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
