/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudVmClusterRequest extends OdbRequest implements
        ToCopyableBuilder<CreateCloudVmClusterRequest.Builder, CreateCloudVmClusterRequest> {
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudExadataInfrastructureId")
            .getter(getter(CreateCloudVmClusterRequest::cloudExadataInfrastructureId))
            .setter(setter(Builder::cloudExadataInfrastructureId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId")
                    .build()).build();

    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuCoreCount").getter(getter(CreateCloudVmClusterRequest::cpuCoreCount))
            .setter(setter(Builder::cpuCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateCloudVmClusterRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> GI_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("giVersion").getter(getter(CreateCloudVmClusterRequest::giVersion)).setter(setter(Builder::giVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("giVersion").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(CreateCloudVmClusterRequest::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<List<String>> SSH_PUBLIC_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sshPublicKeys")
            .getter(getter(CreateCloudVmClusterRequest::sshPublicKeys))
            .setter(setter(Builder::sshPublicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbNetworkId").getter(getter(CreateCloudVmClusterRequest::odbNetworkId))
            .setter(setter(Builder::odbNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(CreateCloudVmClusterRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<DataCollectionOptions> DATA_COLLECTION_OPTIONS_FIELD = SdkField
            .<DataCollectionOptions> builder(MarshallingType.SDK_POJO).memberName("dataCollectionOptions")
            .getter(getter(CreateCloudVmClusterRequest::dataCollectionOptions)).setter(setter(Builder::dataCollectionOptions))
            .constructor(DataCollectionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionOptions").build())
            .build();

    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("dataStorageSizeInTBs").getter(getter(CreateCloudVmClusterRequest::dataStorageSizeInTBs))
            .setter(setter(Builder::dataStorageSizeInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInTBs").build())
            .build();

    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs")
            .getter(getter(CreateCloudVmClusterRequest::dbNodeStorageSizeInGBs)).setter(setter(Builder::dbNodeStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build())
            .build();

    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dbServers")
            .getter(getter(CreateCloudVmClusterRequest::dbServers))
            .setter(setter(Builder::dbServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCloudVmClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_LOCAL_BACKUP_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isLocalBackupEnabled").getter(getter(CreateCloudVmClusterRequest::isLocalBackupEnabled))
            .setter(setter(Builder::isLocalBackupEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLocalBackupEnabled").build())
            .build();

    private static final SdkField<Boolean> IS_SPARSE_DISKGROUP_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("isSparseDiskgroupEnabled")
            .getter(getter(CreateCloudVmClusterRequest::isSparseDiskgroupEnabled))
            .setter(setter(Builder::isSparseDiskgroupEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSparseDiskgroupEnabled").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseModel").getter(getter(CreateCloudVmClusterRequest::licenseModelAsString))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySizeInGBs").getter(getter(CreateCloudVmClusterRequest::memorySizeInGBs))
            .setter(setter(Builder::memorySizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()).build();

    private static final SdkField<String> SYSTEM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemVersion").getter(getter(CreateCloudVmClusterRequest::systemVersion))
            .setter(setter(Builder::systemVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemVersion").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeZone").getter(getter(CreateCloudVmClusterRequest::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateCloudVmClusterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Integer> SCAN_LISTENER_PORT_TCP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scanListenerPortTcp").getter(getter(CreateCloudVmClusterRequest::scanListenerPortTcp))
            .setter(setter(Builder::scanListenerPortTcp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortTcp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, CPU_CORE_COUNT_FIELD, DISPLAY_NAME_FIELD, GI_VERSION_FIELD, HOSTNAME_FIELD,
            SSH_PUBLIC_KEYS_FIELD, ODB_NETWORK_ID_FIELD, CLUSTER_NAME_FIELD, DATA_COLLECTION_OPTIONS_FIELD,
            DATA_STORAGE_SIZE_IN_T_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVERS_FIELD, TAGS_FIELD,
            IS_LOCAL_BACKUP_ENABLED_FIELD, IS_SPARSE_DISKGROUP_ENABLED_FIELD, LICENSE_MODEL_FIELD, MEMORY_SIZE_IN_G_BS_FIELD,
            SYSTEM_VERSION_FIELD, TIME_ZONE_FIELD, CLIENT_TOKEN_FIELD, SCAN_LISTENER_PORT_TCP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cloudExadataInfrastructureId;

    private final Integer cpuCoreCount;

    private final String displayName;

    private final String giVersion;

    private final String hostname;

    private final List<String> sshPublicKeys;

    private final String odbNetworkId;

    private final String clusterName;

    private final DataCollectionOptions dataCollectionOptions;

    private final Double dataStorageSizeInTBs;

    private final Integer dbNodeStorageSizeInGBs;

    private final List<String> dbServers;

    private final Map<String, String> tags;

    private final Boolean isLocalBackupEnabled;

    private final Boolean isSparseDiskgroupEnabled;

    private final String licenseModel;

    private final Integer memorySizeInGBs;

    private final String systemVersion;

    private final String timeZone;

    private final String clientToken;

    private final Integer scanListenerPortTcp;

    private CreateCloudVmClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.displayName = builder.displayName;
        this.giVersion = builder.giVersion;
        this.hostname = builder.hostname;
        this.sshPublicKeys = builder.sshPublicKeys;
        this.odbNetworkId = builder.odbNetworkId;
        this.clusterName = builder.clusterName;
        this.dataCollectionOptions = builder.dataCollectionOptions;
        this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServers = builder.dbServers;
        this.tags = builder.tags;
        this.isLocalBackupEnabled = builder.isLocalBackupEnabled;
        this.isSparseDiskgroupEnabled = builder.isSparseDiskgroupEnabled;
        this.licenseModel = builder.licenseModel;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.systemVersion = builder.systemVersion;
        this.timeZone = builder.timeZone;
        this.clientToken = builder.clientToken;
        this.scanListenerPortTcp = builder.scanListenerPortTcp;
    }

    /**
     * <p>
     * The unique identifier of the Exadata infrastructure for this VM cluster.
     * </p>
     * 
     * @return The unique identifier of the Exadata infrastructure for this VM cluster.
     */
    public final String cloudExadataInfrastructureId() {
        return cloudExadataInfrastructureId;
    }

    /**
     * <p>
     * The number of CPU cores to enable on the VM cluster.
     * </p>
     * 
     * @return The number of CPU cores to enable on the VM cluster.
     */
    public final Integer cpuCoreCount() {
        return cpuCoreCount;
    }

    /**
     * <p>
     * A user-friendly name for the VM cluster.
     * </p>
     * 
     * @return A user-friendly name for the VM cluster.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the
     * <code>ListGiVersions</code> operation and specify the shape of the Exadata infrastructure.
     * </p>
     * <p>
     * Example: <code>19.0.0.0</code>
     * </p>
     * 
     * @return A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the
     *         <code>ListGiVersions</code> operation and specify the shape of the Exadata infrastructure.</p>
     *         <p>
     *         Example: <code>19.0.0.0</code>
     */
    public final String giVersion() {
        return giVersion;
    }

    /**
     * <p>
     * The host name for the VM cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be "localhost" or "hostname".
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't contain "-version".
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum length of the combined hostname and domain is 63 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * The hostname must be unique within the subnet.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The host name for the VM cluster.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be "localhost" or "hostname".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't contain "-version".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The maximum length of the combined hostname and domain is 63 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The hostname must be unique within the subnet.
     *         </p>
     *         </li>
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * For responses, this returns true if the service returned a value for the SshPublicKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSshPublicKeys() {
        return sshPublicKeys != null && !(sshPublicKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The public key portion of one or more key pairs used for SSH access to the VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSshPublicKeys} method.
     * </p>
     * 
     * @return The public key portion of one or more key pairs used for SSH access to the VM cluster.
     */
    public final List<String> sshPublicKeys() {
        return sshPublicKeys;
    }

    /**
     * <p>
     * The unique identifier of the ODB network for the VM cluster.
     * </p>
     * 
     * @return The unique identifier of the ODB network for the VM cluster.
     */
    public final String odbNetworkId() {
        return odbNetworkId;
    }

    /**
     * <p>
     * A name for the Grid Infrastructure cluster. The name isn't case sensitive.
     * </p>
     * 
     * @return A name for the Grid Infrastructure cluster. The name isn't case sensitive.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The set of preferences for the various diagnostic collection options for the VM cluster.
     * </p>
     * 
     * @return The set of preferences for the various diagnostic collection options for the VM cluster.
     */
    public final DataCollectionOptions dataCollectionOptions() {
        return dataCollectionOptions;
    }

    /**
     * <p>
     * The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster.
     * </p>
     * 
     * @return The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster.
     */
    public final Double dataStorageSizeInTBs() {
        return dataStorageSizeInTBs;
    }

    /**
     * <p>
     * The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster.
     * </p>
     * 
     * @return The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster.
     */
    public final Integer dbNodeStorageSizeInGBs() {
        return dbNodeStorageSizeInGBs;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbServers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDbServers() {
        return dbServers != null && !(dbServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of database servers for the VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbServers} method.
     * </p>
     * 
     * @return The list of database servers for the VM cluster.
     */
    public final List<String> dbServers() {
        return dbServers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of resource tags to apply to the VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of resource tags to apply to the VM cluster.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether to enable database backups to local Exadata storage for the VM cluster.
     * </p>
     * 
     * @return Specifies whether to enable database backups to local Exadata storage for the VM cluster.
     */
    public final Boolean isLocalBackupEnabled() {
        return isLocalBackupEnabled;
    }

    /**
     * <p>
     * Specifies whether to create a sparse disk group for the VM cluster.
     * </p>
     * 
     * @return Specifies whether to create a sparse disk group for the VM cluster.
     */
    public final Boolean isSparseDiskgroupEnabled() {
        return isSparseDiskgroupEnabled;
    }

    /**
     * <p>
     * The Oracle license model to apply to the VM cluster.
     * </p>
     * <p>
     * Default: <code>LICENSE_INCLUDED</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The Oracle license model to apply to the VM cluster.</p>
     *         <p>
     *         Default: <code>LICENSE_INCLUDED</code>
     * @see LicenseModel
     */
    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(licenseModel);
    }

    /**
     * <p>
     * The Oracle license model to apply to the VM cluster.
     * </p>
     * <p>
     * Default: <code>LICENSE_INCLUDED</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The Oracle license model to apply to the VM cluster.</p>
     *         <p>
     *         Default: <code>LICENSE_INCLUDED</code>
     * @see LicenseModel
     */
    public final String licenseModelAsString() {
        return licenseModel;
    }

    /**
     * <p>
     * The amount of memory, in gigabytes (GBs), to allocate for the VM cluster.
     * </p>
     * 
     * @return The amount of memory, in gigabytes (GBs), to allocate for the VM cluster.
     */
    public final Integer memorySizeInGBs() {
        return memorySizeInGBs;
    }

    /**
     * <p>
     * The version of the operating system of the image for the VM cluster.
     * </p>
     * 
     * @return The version of the operating system of the image for the VM cluster.
     */
    public final String systemVersion() {
        return systemVersion;
    }

    /**
     * <p>
     * The time zone for the VM cluster. For a list of valid values for time zone, you can check the options in the
     * console.
     * </p>
     * <p>
     * Default: UTC
     * </p>
     * 
     * @return The time zone for the VM cluster. For a list of valid values for time zone, you can check the options in
     *         the console.</p>
     *         <p>
     *         Default: UTC
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
     * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the
     * request to ensure idempotency. The client token is valid for up to 24 hours after it's first used.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
     *         don't specify a client token, the Amazon Web Services SDK automatically generates a client token and uses
     *         it for the request to ensure idempotency. The client token is valid for up to 24 hours after it's first
     *         used.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The port number for TCP connections to the single client access name (SCAN) listener.
     * </p>
     * <p>
     * Valid values: <code>1024–8999</code> with the following exceptions: <code>2484</code>, <code>6100</code>,
     * <code>6200</code>, <code>7060</code>, <code>7070</code>, <code>7085</code>, and <code>7879</code>
     * </p>
     * <p>
     * Default: <code>1521</code>
     * </p>
     * 
     * @return The port number for TCP connections to the single client access name (SCAN) listener. </p>
     *         <p>
     *         Valid values: <code>1024–8999</code> with the following exceptions: <code>2484</code>, <code>6100</code>,
     *         <code>6200</code>, <code>7060</code>, <code>7070</code>, <code>7085</code>, and <code>7879</code>
     *         </p>
     *         <p>
     *         Default: <code>1521</code>
     */
    public final Integer scanListenerPortTcp() {
        return scanListenerPortTcp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(giVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(hasSshPublicKeys() ? sshPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(dataCollectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbServers() ? dbServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isLocalBackupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(isSparseDiskgroupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(systemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(scanListenerPortTcp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudVmClusterRequest)) {
            return false;
        }
        CreateCloudVmClusterRequest other = (CreateCloudVmClusterRequest) obj;
        return Objects.equals(cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId())
                && Objects.equals(cpuCoreCount(), other.cpuCoreCount()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(giVersion(), other.giVersion()) && Objects.equals(hostname(), other.hostname())
                && hasSshPublicKeys() == other.hasSshPublicKeys() && Objects.equals(sshPublicKeys(), other.sshPublicKeys())
                && Objects.equals(odbNetworkId(), other.odbNetworkId()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(dataCollectionOptions(), other.dataCollectionOptions())
                && Objects.equals(dataStorageSizeInTBs(), other.dataStorageSizeInTBs())
                && Objects.equals(dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs())
                && hasDbServers() == other.hasDbServers() && Objects.equals(dbServers(), other.dbServers())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(isLocalBackupEnabled(), other.isLocalBackupEnabled())
                && Objects.equals(isSparseDiskgroupEnabled(), other.isSparseDiskgroupEnabled())
                && Objects.equals(licenseModelAsString(), other.licenseModelAsString())
                && Objects.equals(memorySizeInGBs(), other.memorySizeInGBs())
                && Objects.equals(systemVersion(), other.systemVersion()) && Objects.equals(timeZone(), other.timeZone())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(scanListenerPortTcp(), other.scanListenerPortTcp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudVmClusterRequest")
                .add("CloudExadataInfrastructureId", cloudExadataInfrastructureId()).add("CpuCoreCount", cpuCoreCount())
                .add("DisplayName", displayName()).add("GiVersion", giVersion()).add("Hostname", hostname())
                .add("SshPublicKeys", hasSshPublicKeys() ? sshPublicKeys() : null).add("OdbNetworkId", odbNetworkId())
                .add("ClusterName", clusterName()).add("DataCollectionOptions", dataCollectionOptions())
                .add("DataStorageSizeInTBs", dataStorageSizeInTBs()).add("DbNodeStorageSizeInGBs", dbNodeStorageSizeInGBs())
                .add("DbServers", hasDbServers() ? dbServers() : null).add("Tags", hasTags() ? tags() : null)
                .add("IsLocalBackupEnabled", isLocalBackupEnabled()).add("IsSparseDiskgroupEnabled", isSparseDiskgroupEnabled())
                .add("LicenseModel", licenseModelAsString()).add("MemorySizeInGBs", memorySizeInGBs())
                .add("SystemVersion", systemVersion()).add("TimeZone", timeZone()).add("ClientToken", clientToken())
                .add("ScanListenerPortTcp", scanListenerPortTcp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudExadataInfrastructureId":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureId()));
        case "cpuCoreCount":
            return Optional.ofNullable(clazz.cast(cpuCoreCount()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "giVersion":
            return Optional.ofNullable(clazz.cast(giVersion()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "sshPublicKeys":
            return Optional.ofNullable(clazz.cast(sshPublicKeys()));
        case "odbNetworkId":
            return Optional.ofNullable(clazz.cast(odbNetworkId()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "dataCollectionOptions":
            return Optional.ofNullable(clazz.cast(dataCollectionOptions()));
        case "dataStorageSizeInTBs":
            return Optional.ofNullable(clazz.cast(dataStorageSizeInTBs()));
        case "dbNodeStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(dbNodeStorageSizeInGBs()));
        case "dbServers":
            return Optional.ofNullable(clazz.cast(dbServers()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "isLocalBackupEnabled":
            return Optional.ofNullable(clazz.cast(isLocalBackupEnabled()));
        case "isSparseDiskgroupEnabled":
            return Optional.ofNullable(clazz.cast(isSparseDiskgroupEnabled()));
        case "licenseModel":
            return Optional.ofNullable(clazz.cast(licenseModelAsString()));
        case "memorySizeInGBs":
            return Optional.ofNullable(clazz.cast(memorySizeInGBs()));
        case "systemVersion":
            return Optional.ofNullable(clazz.cast(systemVersion()));
        case "timeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "scanListenerPortTcp":
            return Optional.ofNullable(clazz.cast(scanListenerPortTcp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("giVersion", GI_VERSION_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("sshPublicKeys", SSH_PUBLIC_KEYS_FIELD);
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("dataCollectionOptions", DATA_COLLECTION_OPTIONS_FIELD);
        map.put("dataStorageSizeInTBs", DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("isLocalBackupEnabled", IS_LOCAL_BACKUP_ENABLED_FIELD);
        map.put("isSparseDiskgroupEnabled", IS_SPARSE_DISKGROUP_ENABLED_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("systemVersion", SYSTEM_VERSION_FIELD);
        map.put("timeZone", TIME_ZONE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("scanListenerPortTcp", SCAN_LISTENER_PORT_TCP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudVmClusterRequest, T> g) {
        return obj -> g.apply((CreateCloudVmClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCloudVmClusterRequest> {
        /**
         * <p>
         * The unique identifier of the Exadata infrastructure for this VM cluster.
         * </p>
         * 
         * @param cloudExadataInfrastructureId
         *        The unique identifier of the Exadata infrastructure for this VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId);

        /**
         * <p>
         * The number of CPU cores to enable on the VM cluster.
         * </p>
         * 
         * @param cpuCoreCount
         *        The number of CPU cores to enable on the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCoreCount(Integer cpuCoreCount);

        /**
         * <p>
         * A user-friendly name for the VM cluster.
         * </p>
         * 
         * @param displayName
         *        A user-friendly name for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the
         * <code>ListGiVersions</code> operation and specify the shape of the Exadata infrastructure.
         * </p>
         * <p>
         * Example: <code>19.0.0.0</code>
         * </p>
         * 
         * @param giVersion
         *        A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the
         *        <code>ListGiVersions</code> operation and specify the shape of the Exadata infrastructure.</p>
         *        <p>
         *        Example: <code>19.0.0.0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder giVersion(String giVersion);

        /**
         * <p>
         * The host name for the VM cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be "localhost" or "hostname".
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't contain "-version".
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of the combined hostname and domain is 63 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * The hostname must be unique within the subnet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param hostname
         *        The host name for the VM cluster.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be "localhost" or "hostname".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't contain "-version".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of the combined hostname and domain is 63 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The hostname must be unique within the subnet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * </p>
         * 
         * @param sshPublicKeys
         *        The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeys(Collection<String> sshPublicKeys);

        /**
         * <p>
         * The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * </p>
         * 
         * @param sshPublicKeys
         *        The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeys(String... sshPublicKeys);

        /**
         * <p>
         * The unique identifier of the ODB network for the VM cluster.
         * </p>
         * 
         * @param odbNetworkId
         *        The unique identifier of the ODB network for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkId(String odbNetworkId);

        /**
         * <p>
         * A name for the Grid Infrastructure cluster. The name isn't case sensitive.
         * </p>
         * 
         * @param clusterName
         *        A name for the Grid Infrastructure cluster. The name isn't case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The set of preferences for the various diagnostic collection options for the VM cluster.
         * </p>
         * 
         * @param dataCollectionOptions
         *        The set of preferences for the various diagnostic collection options for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions);

        /**
         * <p>
         * The set of preferences for the various diagnostic collection options for the VM cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataCollectionOptions.Builder} avoiding
         * the need to create one manually via {@link DataCollectionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataCollectionOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #dataCollectionOptions(DataCollectionOptions)}.
         * 
         * @param dataCollectionOptions
         *        a consumer that will call methods on {@link DataCollectionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCollectionOptions(DataCollectionOptions)
         */
        default Builder dataCollectionOptions(Consumer<DataCollectionOptions.Builder> dataCollectionOptions) {
            return dataCollectionOptions(DataCollectionOptions.builder().applyMutation(dataCollectionOptions).build());
        }

        /**
         * <p>
         * The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster.
         * </p>
         * 
         * @param dataStorageSizeInTBs
         *        The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs);

        /**
         * <p>
         * The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster.
         * </p>
         * 
         * @param dbNodeStorageSizeInGBs
         *        The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs);

        /**
         * <p>
         * The list of database servers for the VM cluster.
         * </p>
         * 
         * @param dbServers
         *        The list of database servers for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServers(Collection<String> dbServers);

        /**
         * <p>
         * The list of database servers for the VM cluster.
         * </p>
         * 
         * @param dbServers
         *        The list of database servers for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServers(String... dbServers);

        /**
         * <p>
         * The list of resource tags to apply to the VM cluster.
         * </p>
         * 
         * @param tags
         *        The list of resource tags to apply to the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Specifies whether to enable database backups to local Exadata storage for the VM cluster.
         * </p>
         * 
         * @param isLocalBackupEnabled
         *        Specifies whether to enable database backups to local Exadata storage for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled);

        /**
         * <p>
         * Specifies whether to create a sparse disk group for the VM cluster.
         * </p>
         * 
         * @param isSparseDiskgroupEnabled
         *        Specifies whether to create a sparse disk group for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled);

        /**
         * <p>
         * The Oracle license model to apply to the VM cluster.
         * </p>
         * <p>
         * Default: <code>LICENSE_INCLUDED</code>
         * </p>
         * 
         * @param licenseModel
         *        The Oracle license model to apply to the VM cluster.</p>
         *        <p>
         *        Default: <code>LICENSE_INCLUDED</code>
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The Oracle license model to apply to the VM cluster.
         * </p>
         * <p>
         * Default: <code>LICENSE_INCLUDED</code>
         * </p>
         * 
         * @param licenseModel
         *        The Oracle license model to apply to the VM cluster.</p>
         *        <p>
         *        Default: <code>LICENSE_INCLUDED</code>
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(LicenseModel licenseModel);

        /**
         * <p>
         * The amount of memory, in gigabytes (GBs), to allocate for the VM cluster.
         * </p>
         * 
         * @param memorySizeInGBs
         *        The amount of memory, in gigabytes (GBs), to allocate for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInGBs(Integer memorySizeInGBs);

        /**
         * <p>
         * The version of the operating system of the image for the VM cluster.
         * </p>
         * 
         * @param systemVersion
         *        The version of the operating system of the image for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemVersion(String systemVersion);

        /**
         * <p>
         * The time zone for the VM cluster. For a list of valid values for time zone, you can check the options in the
         * console.
         * </p>
         * <p>
         * Default: UTC
         * </p>
         * 
         * @param timeZone
         *        The time zone for the VM cluster. For a list of valid values for time zone, you can check the options
         *        in the console.</p>
         *        <p>
         *        Default: UTC
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
         * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for
         * the request to ensure idempotency. The client token is valid for up to 24 hours after it's first used.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don't specify a client token, the Amazon Web Services SDK automatically generates a client token and
         *        uses it for the request to ensure idempotency. The client token is valid for up to 24 hours after it's
         *        first used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The port number for TCP connections to the single client access name (SCAN) listener.
         * </p>
         * <p>
         * Valid values: <code>1024–8999</code> with the following exceptions: <code>2484</code>, <code>6100</code>,
         * <code>6200</code>, <code>7060</code>, <code>7070</code>, <code>7085</code>, and <code>7879</code>
         * </p>
         * <p>
         * Default: <code>1521</code>
         * </p>
         * 
         * @param scanListenerPortTcp
         *        The port number for TCP connections to the single client access name (SCAN) listener. </p>
         *        <p>
         *        Valid values: <code>1024–8999</code> with the following exceptions: <code>2484</code>,
         *        <code>6100</code>, <code>6200</code>, <code>7060</code>, <code>7070</code>, <code>7085</code>, and
         *        <code>7879</code>
         *        </p>
         *        <p>
         *        Default: <code>1521</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanListenerPortTcp(Integer scanListenerPortTcp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String cloudExadataInfrastructureId;

        private Integer cpuCoreCount;

        private String displayName;

        private String giVersion;

        private String hostname;

        private List<String> sshPublicKeys = DefaultSdkAutoConstructList.getInstance();

        private String odbNetworkId;

        private String clusterName;

        private DataCollectionOptions dataCollectionOptions;

        private Double dataStorageSizeInTBs;

        private Integer dbNodeStorageSizeInGBs;

        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean isLocalBackupEnabled;

        private Boolean isSparseDiskgroupEnabled;

        private String licenseModel;

        private Integer memorySizeInGBs;

        private String systemVersion;

        private String timeZone;

        private String clientToken;

        private Integer scanListenerPortTcp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudVmClusterRequest model) {
            super(model);
            cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            cpuCoreCount(model.cpuCoreCount);
            displayName(model.displayName);
            giVersion(model.giVersion);
            hostname(model.hostname);
            sshPublicKeys(model.sshPublicKeys);
            odbNetworkId(model.odbNetworkId);
            clusterName(model.clusterName);
            dataCollectionOptions(model.dataCollectionOptions);
            dataStorageSizeInTBs(model.dataStorageSizeInTBs);
            dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            dbServers(model.dbServers);
            tags(model.tags);
            isLocalBackupEnabled(model.isLocalBackupEnabled);
            isSparseDiskgroupEnabled(model.isSparseDiskgroupEnabled);
            licenseModel(model.licenseModel);
            memorySizeInGBs(model.memorySizeInGBs);
            systemVersion(model.systemVersion);
            timeZone(model.timeZone);
            clientToken(model.clientToken);
            scanListenerPortTcp(model.scanListenerPortTcp);
        }

        public final String getCloudExadataInfrastructureId() {
            return cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getGiVersion() {
            return giVersion;
        }

        public final void setGiVersion(String giVersion) {
            this.giVersion = giVersion;
        }

        @Override
        public final Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final Collection<String> getSshPublicKeys() {
            if (sshPublicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return sshPublicKeys;
        }

        public final void setSshPublicKeys(Collection<String> sshPublicKeys) {
            this.sshPublicKeys = StringListCopier.copy(sshPublicKeys);
        }

        @Override
        public final Builder sshPublicKeys(Collection<String> sshPublicKeys) {
            this.sshPublicKeys = StringListCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(String... sshPublicKeys) {
            sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        public final String getOdbNetworkId() {
            return odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final DataCollectionOptions.Builder getDataCollectionOptions() {
            return dataCollectionOptions != null ? dataCollectionOptions.toBuilder() : null;
        }

        public final void setDataCollectionOptions(DataCollectionOptions.BuilderImpl dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions != null ? dataCollectionOptions.build() : null;
        }

        @Override
        public final Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            return this;
        }

        public final Double getDataStorageSizeInTBs() {
            return dataStorageSizeInTBs;
        }

        public final void setDataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        }

        @Override
        public final Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String... dbServers) {
            dbServers(Arrays.asList(dbServers));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getIsLocalBackupEnabled() {
            return isLocalBackupEnabled;
        }

        public final void setIsLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
        }

        @Override
        public final Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            return this;
        }

        public final Boolean getIsSparseDiskgroupEnabled() {
            return isSparseDiskgroupEnabled;
        }

        public final void setIsSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
        }

        @Override
        public final Builder isSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final String getSystemVersion() {
            return systemVersion;
        }

        public final void setSystemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
        }

        @Override
        public final Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getScanListenerPortTcp() {
            return scanListenerPortTcp;
        }

        public final void setScanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
        }

        @Override
        public final Builder scanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudVmClusterRequest build() {
            return new CreateCloudVmClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
